---
generated_at: 2026-01-29 21:42:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-batch-sending-service-job

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/email-service/batch-sending-service.js`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 最大1,000件のバッチに分割 | E-02, E-01 L250 | ○ |
| C-02 | 並列度2で送信 | E-01 L13, L468 | ○ |
| C-03 | リトライ最大10回、最大10分（送信前） | E-01 L39 | ○ |
| C-04 | リトライ最大20回、最大30分（送信後） | E-01 L40 | ○ |
| C-05 | Mailgun APIリトライ最大6回、10秒間隔 | E-01 L41 | ○ |
| C-06 | updateStatusLockでステータスロック | E-01 L142-147 | ○ |
| C-07 | pending/failedからsubmittingへ更新 | E-01 L144 | ○ |
| C-08 | newsletter, postのリレーション取得 | E-01 L203-209 | ○ |
| C-09 | getBatchesで既存バッチ取得 | E-01 L226-232 | ○ |
| C-10 | createBatchesでバッチ・受信者登録 | E-01 L238-342 | ○ |
| C-11 | セグメントごとに購読者取得 | E-01 L253-315 | ○ |
| C-12 | email_batchesテーブルにINSERT | E-01 L393-398 | ○ |
| C-13 | email_recipientsテーブルにINSERT | E-01 L400-426 | ○ |
| C-14 | sendBatchesで並列送信 | E-01 L430-480 | ○ |
| C-15 | 配信デッドライン計算 | E-01 L432-436, L737-774 | ○ |
| C-16 | バッチステータスsubmitted/failed更新 | E-01 L540-588 | ○ |
| C-17 | provider_idをMailgunレスポンスから取得 | E-01 L543 | ○ |
| C-18 | processed_atを更新 | E-01 L592-598 | ○ |
| C-19 | 部分失敗時は「partially sent」エラー | E-01 L471-479 | ○ |
| C-20 | retryDbで自動リトライ | E-01 L676-728 | ○ |
| C-21 | 指数バックオフ（sleep * 2） | E-01 L727 | ○ |
| C-22 | FOR UPDATEによるDBロック | E-01 L650 | ○ |
| C-23 | Sentryへのエラー報告 | E-01 L179-182, L556-558 | ○ |
| C-24 | email_count不整合時にSentry報告 | E-01 L324-328 | ○ |
| C-25 | ドメインウォーミング機能 | E-01 L243-246, L277-306 | ○ |
| C-26 | fallback_sending_domain対応 | E-01 L397 | ○ |
| C-27 | EmailBodyCacheで重複レンダリング回避 | E-01 L438 | ○ |
| C-28 | deliveryTimeで配信時刻分散 | E-01 L441, L757-773 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから全ての主張が裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] バッチサイズ1,000件が環境に適切か確認
- [ ] リトライ設定が運用要件と合致しているか確認
- [ ] Sentry連携が正しく設定されているか確認
