---
generated_at: 2026-01-29 21:44:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-clean-expired-comped

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/members/jobs/clean-expired-comped.js`
- E-02: `ghost/core/core/server/services/members/jobs/index.js`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 毎日0-5時のランダムな時刻に実行 | E-02 L16-18, E-03 | ○ |
| C-02 | cronスケジュール `${s} ${m} ${h} * * *` | E-02 L22 | ○ |
| C-03 | テスト環境では実行されない | E-02 L12-13 | ○ |
| C-04 | hasScheduled.expiredCompedで重複防止 | E-02 L11-12 | ○ |
| C-05 | members_productsから期限切れレコード取得 | E-01 L34-36 | ○ |
| C-06 | expiry_at < 今日のUTC開始時刻で判定 | E-01 L35 | ○ |
| C-07 | members_productsから期限切れレコード削除 | E-01 L50-52 | ○ |
| C-08 | status='comped'のメンバーを取得 | E-01 L55-57 | ○ |
| C-09 | メンバーstatusを'free'に更新 | E-01 L62-66 | ○ |
| C-10 | members_status_eventsにイベント挿入 | E-01 L68-89 | ○ |
| C-11 | from_statusに元ステータス設定 | E-01 L74 | ○ |
| C-12 | to_statusに'free'設定 | E-01 L75 | ○ |
| C-13 | created_atにCURRENT_TIMESTAMP | E-01 L76 | ○ |
| C-14 | 6553件ずつチャンク処理 | E-01 L82-84 | ○ |
| C-15 | SQLite 32766パラメータ対応 | E-01 L80-81コメント | ○ |
| C-16 | ObjectIDでID生成 | E-01 L72 | ○ |
| C-17 | キャンセル時にcancelledメッセージ送信 | E-01 L11-19 | ○ |
| C-18 | 処理結果をログ出力 | E-01 L94, L97 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから全ての主張が裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] 実行時刻（0-5時）がシステム運用と整合しているか確認
- [ ] チャンクサイズ6553が使用環境のSQLiteバージョンと整合しているか確認
- [ ] トランザクション管理が運用要件に適切か確認
