---
generated_at: 2026-01-29 21:48:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-post-scheduling

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/adapters/scheduling/post-scheduling/PostScheduler.js`
- E-02: `ghost/core/core/server/adapters/scheduling/scheduling-default.js`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 5分ごとにウェイクアップ | E-02 L24, E-03 | ○ |
| C-02 | 10分以内の投稿をチェック | E-02 L27, E-03 | ○ |
| C-03 | 起動時に既存予約を再登録 | E-01 L13-23 | ○ |
| C-04 | post.scheduled イベントで登録 | E-01 L29-31 | ○ |
| C-05 | post.rescheduled でunschedule→schedule | E-01 L37-39 | ○ |
| C-06 | post.unscheduled でunschedule | E-01 L42-44 | ○ |
| C-07 | normalizeでジョブ情報を正規化 | E-01 L53-75 | ○ |
| C-08 | 署名付きトークンでAPI認証 | E-01 L56-63 | ○ |
| C-09 | isRunningフラグで重複防止 | E-02 L98-100 | ○ |
| C-10 | allJobsに時刻でソートして登録 | E-02 L160-167 | ○ |
| C-11 | 10分以内は即座に_execute | E-02 L144-149 | ○ |
| C-12 | 指定時刻の70ms前にsetTimeout | E-02 L256 | ○ |
| C-13 | setImmediateで正確タイミング検出 | E-02 L225-255 | ○ |
| C-14 | beforePingInMsは-50ms | E-02 L28 | ○ |
| C-15 | 削除済みジョブはdeletedJobsで管理 | E-02 L179-194 | ○ |
| C-16 | _pingUrlでAPI呼び出し | E-02 L266-323 | ○ |
| C-17 | 404エラーは処理スキップ | E-02 L298-300 | ○ |
| C-18 | 503エラーは5秒間隔でリトライ | E-02 L304-316 | ○ |
| C-19 | 最大30回リトライ | E-02 L274 | ○ |
| C-20 | 過去時刻は{force: true}付与 | E-02 L287-292 | ○ |
| C-21 | setTimeoutは24.3日上限 | E-02 L204-205コメント | ○ |
| C-22 | rescheduleOnBoot: true | E-02 L32 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから全ての主張が裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] 5分間隔と10分オフセットがシステム要件と整合しているか確認
- [ ] リトライ設定（30回、5秒間隔）が運用要件に適切か確認
- [ ] 署名付きトークンの有効期限設定を確認
