---
generated_at: 2026-01-29 21:50:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-update-check

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/update-check/update-check-service.js`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 毎日ランダムな時刻に実行 | E-02 | ○ |
| C-02 | next_update_check設定で次回チェック管理 | E-01 L373-382 | ○ |
| C-03 | 現在時刻+24時間で次回設定 | E-01 L64-65 | ○ |
| C-04 | forceUpdateで強制チェック | E-01 L381 | ○ |
| C-05 | 統計情報収集（updateCheckData） | E-01 L102-154 | ○ |
| C-06 | ghost_version, node_version収集 | E-01 L106-107 | ○ |
| C-07 | db_hash, active_theme取得 | E-01 L116-117 | ○ |
| C-08 | blog_idはMD5ハッシュ | E-01 L130 | ○ |
| C-09 | blog_created_atはOwner作成日 | E-01 L135-147 | ○ |
| C-10 | プライバシー設定でPOST/GET選択 | E-01 L176-186 | ○ |
| C-11 | POSTで統計情報送信 | E-01 L180-181 | ○ |
| C-12 | GETでghost_versionのみ | E-01 L183-185 | ○ |
| C-13 | APIタイムアウト1秒 | E-01 L170 | ○ |
| C-14 | 404で空の通知配列 | E-01 L195-199 | ○ |
| C-15 | エラー時もnext_update_check更新 | E-01 L81-86 | ○ |
| C-16 | notificationGroupsでフィルタリング | E-01 L282-297 | ○ |
| C-17 | 'all'グループは全カスタム通知受信 | E-01 L251 | ○ |
| C-18 | createCustomNotificationで通知登録 | E-01 L311-363 | ○ |
| C-19 | type: alertで管理者にメール | E-01 L343-358 | ○ |
| C-20 | Owner/Administratorにメール送信 | E-01 L324-326 | ○ |
| C-21 | rethrowErrorsで例外再スロー | E-01 L93-95 | ○ |
| C-22 | npm -vでnpm_version取得 | E-01 L123 | ○ |
| C-23 | post_count, user_count取得 | E-01 L132-133 | ○ |
| C-24 | email_transport情報収集 | E-01 L110-113 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから全ての主張が裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] プライバシー設定（useUpdateCheck）がユーザーに適切に説明されているか確認
- [ ] 更新チェックエンドポイント（updates.ghost.org）が正しく設定されているか確認
- [ ] 管理者メール送信機能が正しく動作するか確認
