---
generated_at: 2026-01-29 21:52:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-process-outbox

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/outbox/jobs/index.js`
- E-02: `ghost/core/core/server/services/outbox/jobs/outbox-job.js`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 5分ごとにcronスケジュールで実行 | E-01 L23, E-03 | ○ |
| C-02 | ランダムな秒・分オフセット | E-01 L19-21 | ○ |
| C-03 | hasScheduled.processOutboxで重複防止 | E-01 L11-13 | ○ |
| C-04 | memberWelcomeEmailSendInstantly設定対応 | E-01 L15-16 | ○ |
| C-05 | true時は3秒ごとに実行 | E-01 L23 | ○ |
| C-06 | StartOutboxProcessingEventを発火 | E-02 L24-27 | ○ |
| C-07 | parentPortにイベント送信 | E-02 L24-27 | ○ |
| C-08 | 完了時に'done'送信 | E-02 L28 | ○ |
| C-09 | キャンセル時にメッセージ送信 | E-02 L4-13 | ○ |
| C-10 | ワーカースレッド（worker_threads）使用 | E-02 L1 | ○ |
| C-11 | ジョブ名は'process-outbox' | E-01 L28 | ○ |
| C-12 | outbox-job.jsがジョブファイル | E-01 L27 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから全ての主張が裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] memberWelcomeEmailSendInstantly設定が本番環境で適切に設定されているか確認
- [ ] Outbox処理サービスの実装詳細を確認（イベントハンドラ側）
- [ ] メール送信エラー時のリトライ動作を確認
