---
generated_at: 2026-01-29 21:54:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-mentions-email-report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/mentions-email-report/service.js`
- E-02: `ghost/core/core/server/services/mentions-email-report/mention-email-report-job.js`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 1時間ごとにランダムな分・秒で実行 | E-01 L155-162, E-03 | ○ |
| C-02 | labs.isSet('webmentions')が条件 | E-01 L147-149 | ○ |
| C-03 | initialisedフラグで重複初期化防止 | E-01 L11-14 | ○ |
| C-04 | 前回送信から24時間経過チェック | E-02 L42-44 | ○ |
| C-05 | 24時間未満の場合は0を返す | E-02 L43-44 | ○ |
| C-06 | getMentionReportでレポート取得 | E-02 L46 | ○ |
| C-07 | mentionsデータを正規化 | E-02 L48-59 | ○ |
| C-08 | mentions.length===0で0を返す | E-02 L61-63 | ○ |
| C-09 | getEmailAlertUsers('mention-received')で受信者取得 | E-01 L26 | ○ |
| C-10 | renderSubjectでサブジェクト生成 | E-02 L68 | ○ |
| C-11 | サブジェクトは言及元サイト数で動的生成 | E-01 L42-55 | ○ |
| C-12 | renderHTMLでHTML本文生成 | E-02 L69 | ○ |
| C-13 | renderTextでテキスト本文生成 | E-02 L70 | ○ |
| C-14 | emailService.sendでメール送信 | E-02 L72 | ○ |
| C-15 | setLatestReportDateで送信日時更新 | E-02 L75 | ○ |
| C-16 | Settings.editで設定更新 | E-01 L112-115 | ○ |
| C-17 | 起動時にStartMentionEmailReportJob発火 | E-01 L153 | ○ |
| C-18 | 不正タイムスタンプ時は24時間前をデフォルト | E-01 L103-107 | ○ |
| C-19 | 重複sourceUrlをフィルタリング | E-01 L67-68, L85-86 | ○ |
| C-20 | mentions.lengthを返却 | E-02 L77 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから全ての主張が裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] webmentions labsフラグが適切に設定されているか確認
- [ ] mention-received通知設定のユーザー管理が適切か確認
- [ ] メールテンプレート（mention-report）が存在するか確認
