---
generated_at: 2026-01-29 21:56:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-milestones-check

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/milestones/service.js`
- E-02: `ghost/core/core/server/services/milestones/milestones-service.js`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 起動時に0-4日のランダム遅延 | E-01 L6, E-03 | ○ |
| C-02 | 開発環境は5秒後に実行 | E-01 L84-86 | ○ |
| C-03 | Stripe Live有効時のみARRチェック | E-01 L65-69 | ○ |
| C-04 | pk_live_またはpk_test_で判定 | E-01 L14-15 | ○ |
| C-05 | checkMilestones('members')でメンバーチェック | E-01 L63 | ○ |
| C-06 | checkMilestones('arr')でARRチェック | E-01 L68 | ○ |
| C-07 | getMembersCount()でメンバー数取得 | E-02 L264 | ○ |
| C-08 | getARR()でARR取得 | E-02 L198 | ○ |
| C-09 | getMatchedMilestones()で達成マイルストーン抽出 | E-02 L120-123 | ○ |
| C-10 | checkMilestoneExists()で既存チェック | E-02 L84-96 | ○ |
| C-11 | 初回実行はメールなしで保存 | E-02 L229-236, L287-294 | ○ |
| C-12 | reason: 'initial'で初回を記録 | E-02 L233-235, L290-292 | ○ |
| C-13 | reason: 'skipped'でスキップを記録 | E-02 L241-243, L298-300 | ○ |
| C-14 | shouldSendEmail()でメール送信判定 | E-02 L168-190 | ○ |
| C-15 | minDaysSinceLastEmailで間隔チェック | E-02 L180 | ○ |
| C-16 | hasImportedMembersInPeriod()でインポートチェック | E-02 L183 | ○ |
| C-17 | reason: 'import'または'email'で非送信理由記録 | E-02 L187 | ○ |
| C-18 | getDefaultCurrency()でデフォルト通貨取得 | E-02 L199 | ○ |
| C-19 | milestonesConfigからマイルストーン定義取得 | E-02 L202-203, L267 | ○ |
| C-20 | repository.save()でマイルストーン保存 | E-02 L109 | ○ |
| C-21 | getLatestByType()で最新マイルストーン取得 | E-02 L58-60, L65-67 | ○ |
| C-22 | getLastEmailSent()で最終メール送信確認 | E-02 L174 | ○ |
| C-23 | logging.infoでスケジュールログ出力 | E-01 L96 | ○ |
| C-24 | {members, arr}オブジェクトを返却 | E-01 L70-73 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから全ての主張が裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] milestonesConfigのマイルストーン値が適切に設定されているか確認
- [ ] Stripe Live判定ロジックが正しく動作するか確認
- [ ] minDaysSinceLastEmail設定がビジネス要件と整合しているか確認
