---
generated_at: 2026-01-29 10:30:00
metrics:
  claims_total: 197
  claims_with_evidence: 197
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：admin モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：197 / 197、根拠なし：0
- 優先レビュー（高）
  1. **Post関連テスト（65-110）**：最も複雑なモデルで多数のcomputed propertiesを持つ
  2. **User関連テスト（153-185）**：権限管理とパスワード変更のセキュリティ重要
  3. **Email関連テスト（9-17）**：メール送信機能の信頼性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/admin/app/models/action.js`
- E-02: `ghost/admin/app/models/api-key.js`
- E-03: `ghost/admin/app/models/base.js`
- E-04: `ghost/admin/app/models/email.js`
- E-05: `ghost/admin/app/models/integration.js`
- E-06: `ghost/admin/app/models/invite.js`
- E-07: `ghost/admin/app/models/label.js`
- E-08: `ghost/admin/app/models/member-subscription.js`
- E-09: `ghost/admin/app/models/member-tier.js`
- E-10: `ghost/admin/app/models/member.js`
- E-11: `ghost/admin/app/models/mention.js`
- E-12: `ghost/admin/app/models/navigation-item.js`
- E-13: `ghost/admin/app/models/newsletter.js`
- E-14: `ghost/admin/app/models/notification.js`
- E-15: `ghost/admin/app/models/offer.js`
- E-16: `ghost/admin/app/models/page.js`
- E-17: `ghost/admin/app/models/post-revision.js`
- E-18: `ghost/admin/app/models/post.js`
- E-19: `ghost/admin/app/models/role.js`
- E-20: `ghost/admin/app/models/setting.js`
- E-21: `ghost/admin/app/models/snippet.js`
- E-22: `ghost/admin/app/models/tag.js`
- E-23: `ghost/admin/app/models/theme.js`
- E-24: `ghost/admin/app/models/tier-benefit-item.js`
- E-25: `ghost/admin/app/models/tier.js`
- E-26: `ghost/admin/app/models/user.js`
- E-27: `ghost/admin/app/models/webhook.js`
- E-28: `ghost/admin/app/mixins/validation-engine.js`

## 3) Claims と根拠の対応（レビューの主戦場）

### Action モデル (UT-ADM-001 〜 003)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Actionモデルの属性定義 | E-01 (L1-11) | ○ |
| C-02 | context属性のJSON変換 | E-01 (L9) | ○ |
| C-03 | createdAtUTCのmoment-utc変換 | E-01 (L10) | ○ |

### ApiKey モデル (UT-ADM-004 〜 006)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-04 | ApiKeyモデルの属性定義 | E-02 (L1-11) | ○ |
| C-05 | integrationリレーション正常系 | E-02 (L10) | ○ |
| C-06 | integrationリレーション異常系 | E-02 (L10) | ○ |

### Base モデル (UT-ADM-007 〜 008)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | _metaプロパティ取得 | E-03 (L9-11) | ○ |
| C-08 | _meta未設定時の挙動 | E-03 (L9-11) | ○ |

### Email モデル (UT-ADM-009 〜 017)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | Emailモデルの属性定義 | E-04 (L1-47) | ○ |
| C-10 | isSuccess（status=submitted） | E-04 (L31) | ○ |
| C-11 | isSuccess異常系 | E-04 (L31) | ○ |
| C-12 | isFailure（status=failed） | E-04 (L32) | ○ |
| C-13 | openRate計算正常系 | E-04 (L34-41) | ○ |
| C-14 | openRate境界値（emailCount=0） | E-04 (L37-38) | ○ |
| C-15 | openRate境界値（100%） | E-04 (L34-41) | ○ |
| C-16 | retry()メソッド | E-04 (L44-46) | ○ |
| C-17 | postリレーション | E-04 (L29) | ○ |

### Integration モデル (UT-ADM-018 〜 024)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | Integrationモデルの属性定義 | E-05 (L1-32) | ○ |
| C-19 | validationType設定 | E-05 (L6) | ○ |
| C-20 | apiKeysリレーション | E-05 (L16-19) | ○ |
| C-21 | webhooksリレーション | E-05 (L20-23) | ○ |
| C-22 | adminKey計算プロパティ | E-05 (L25-27) | ○ |
| C-23 | adminKey異常系 | E-05 (L25-27) | ○ |
| C-24 | contentKey計算プロパティ | E-05 (L29-31) | ○ |

### Invite モデル (UT-ADM-025 〜 028)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | Inviteモデルの属性定義 | E-06 (L1-33) | ○ |
| C-26 | roleリレーション | E-06 (L12) | ○ |
| C-27 | resend()正常系 | E-06 (L17-31) | ○ |
| C-28 | resend()異常系 | E-06 (L17-31) | ○ |

### Label モデル (UT-ADM-029 〜 030)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | Labelモデルの属性定義 | E-07 (L1-15) | ○ |
| C-30 | validationType設定 | E-07 (L6) | ○ |

### MemberSubscription/MemberTier オブジェクト (UT-ADM-031 〜 032)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | MemberSubscriptionの属性定義 | E-08 (L1-14) | ○ |
| C-32 | MemberTierの属性定義 | E-09 (L1-6) | ○ |

### Member モデル (UT-ADM-033 〜 040)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | Memberモデルの属性定義 | E-10 (L1-58) | ○ |
| C-34 | validationType設定 | E-10 (L7) | ○ |
| C-35 | newslettersリレーション | E-10 (L26) | ○ |
| C-36 | labelsリレーション | E-10 (L29) | ○ |
| C-37 | updateLabels()正常系 | E-10 (L38-44) | ○ |
| C-38 | updateLabels()境界値 | E-10 (L38-44) | ○ |
| C-39 | fetchSigninUrlタスク | E-10 (L46-52) | ○ |
| C-40 | logoutAllDevicesタスク | E-10 (L54-57) | ○ |

### Mention モデル (UT-ADM-041)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | Mentionモデルの属性定義 | E-11 (L1-16) | ○ |

### NavigationItem オブジェクト (UT-ADM-042 〜 048)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | NavigationItemの属性定義 | E-12 (L1-24) | ○ |
| C-43 | isComplete正常系 | E-12 (L13-17) | ○ |
| C-44 | isComplete異常系（label空） | E-12 (L13-17) | ○ |
| C-45 | isComplete異常系（url空） | E-12 (L13-17) | ○ |
| C-46 | isBlank正常系 | E-12 (L19-23) | ○ |
| C-47 | isBlank異常系 | E-12 (L19-23) | ○ |
| C-48 | validationType設定 | E-12 (L11) | ○ |

### Newsletter モデル (UT-ADM-049 〜 054)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | Newsletterモデルの属性定義 | E-13 (L1-55) | ○ |
| C-50 | validationType設定 | E-13 (L5) | ○ |
| C-51 | recipientFilter（visibility=public） | E-13 (L48-54) | ○ |
| C-52 | recipientFilter（visibility=paid） | E-13 (L50-52) | ○ |
| C-53 | senderReplyToデフォルト値 | E-13 (L13) | ○ |
| C-54 | statusデフォルト値 | E-13 (L15) | ○ |

### Notification モデル (UT-ADM-055)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | Notificationモデルの属性定義 | E-14 (L1-10) | ○ |

### Offer モデル (UT-ADM-056 〜 060)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | Offerモデルの属性定義 | E-15 (L1-23) | ○ |
| C-57 | validationType設定 | E-15 (L5) | ○ |
| C-58 | statusデフォルト値 | E-15 (L10) | ○ |
| C-59 | typeデフォルト値 | E-15 (L15) | ○ |
| C-60 | durationデフォルト値 | E-15 (L17) | ○ |

### Page モデル (UT-ADM-061 〜 062)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | PageがPostを継承 | E-16 (L1-5) | ○ |
| C-62 | displayName=page | E-16 (L4) | ○ |

### PostRevision モデル (UT-ADM-063 〜 064)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | PostRevisionモデルの属性定義 | E-17 (L1-14) | ○ |
| C-64 | authorリレーション | E-17 (L12) | ○ |

### Post モデル (UT-ADM-065 〜 110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | Postモデルの属性定義 | E-18 (L1-455) | ○ |
| C-66 | validationType設定 | E-18 (L81) | ○ |
| C-67 | isPublished | E-18 (L161) | ○ |
| C-68 | isDraft | E-18 (L162) | ○ |
| C-69 | isScheduled | E-18 (L164) | ○ |
| C-70 | isSent | E-18 (L165) | ○ |
| C-71 | isPost | E-18 (L167) | ○ |
| C-72 | isPage | E-18 (L168) | ○ |
| C-73 | hasEmail（email存在） | E-18 (L170-172) | ○ |
| C-74 | hasEmail（emailOnly=true） | E-18 (L170-172) | ○ |
| C-75 | willEmail | E-18 (L173-175) | ○ |
| C-76 | hasBeenEmailed | E-18 (L177-181) | ○ |
| C-77 | didEmailFail | E-18 (L183-187) | ○ |
| C-78 | previewUrl正常系 | E-18 (L230-240) | ○ |
| C-79 | previewUrl（uuid無し） | E-18 (L236-237) | ○ |
| C-80 | isPublic（public） | E-18 (L244-246) | ○ |
| C-81 | isPublic（非public） | E-18 (L244-246) | ○ |
| C-82 | visibilitySegment（members） | E-18 (L248-266) | ○ |
| C-83 | visibilitySegment（paid） | E-18 (L255-256) | ○ |
| C-84 | visibilitySegment（tiers） | E-18 (L257-263) | ○ |
| C-85 | fullRecipientFilter正常系 | E-18 (L268-274) | ○ |
| C-86 | fullRecipientFilter（newsletter無し） | E-18 (L269-270) | ○ |
| C-87 | pastScheduledTime（超過） | E-18 (L278-291) | ○ |
| C-88 | pastScheduledTime（未超過） | E-18 (L278-291) | ○ |
| C-89 | pastScheduledTime（非予約） | E-18 (L288-290) | ○ |
| C-90 | clickRate正常系 | E-18 (L304-313) | ○ |
| C-91 | clickRate（email無し） | E-18 (L305-306) | ○ |
| C-92 | clickRate（clicks無し） | E-18 (L307-309) | ○ |
| C-93 | publishedAtBlogTZ正常系 | E-18 (L293-302) | ○ |
| C-94 | publishedAtBlogTZ（未設定） | E-18 (L321-323) | ○ |
| C-95 | _setPublishedAtBlogStrings正常系 | E-18 (L358-369) | ○ |
| C-96 | _setPublishedAtBlogStrings（null） | E-18 (L365-368) | ○ |
| C-97 | updateTags() | E-18 (L375-381) | ○ |
| C-98 | isAuthoredByUser正常系 | E-18 (L383-385) | ○ |
| C-99 | isAuthoredByUser異常系 | E-18 (L383-385) | ○ |
| C-100 | compare（ステータス順） | E-18 (L392-430) | ○ |
| C-101 | compare（公開日時順） | E-18 (L50-67, L414) | ○ |
| C-102 | compare（新規優先） | E-18 (L402-408) | ○ |
| C-103 | beforeSave | E-18 (L437-441) | ○ |
| C-104 | save（公開投稿） | E-18 (L444-454) | ○ |
| C-105 | save（ステータス変更） | E-18 (L445) | ○ |
| C-106 | hasMany(authors) | E-18 (L124) | ○ |
| C-107 | hasMany(tags) | E-18 (L128) | ○ |
| C-108 | primaryAuthor | E-18 (L131) | ○ |
| C-109 | primaryTag | E-18 (L132) | ○ |
| C-110 | internalTags | E-18 (L163) | ○ |

### Role モデル (UT-ADM-111 〜 113)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | Roleモデルの属性定義 | E-19 (L1-13) | ○ |
| C-112 | lowerCaseName正常系 | E-19 (L10-12) | ○ |
| C-113 | lowerCaseName（null） | E-19 (L11) | ○ |

### Setting モデル (UT-ADM-114 〜 119)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-114 | Settingモデルの属性定義 | E-20 (L1-133) | ○ |
| C-115 | validationType設定 | E-20 (L5) | ○ |
| C-116 | timezoneデフォルト値 | E-20 (L14) | ○ |
| C-117 | navigation-settings変換 | E-20 (L20-21) | ○ |
| C-118 | facebook-url-user変換 | E-20 (L17) | ○ |
| C-119 | twitter-url-user変換 | E-20 (L18) | ○ |

### Snippet モデル (UT-ADM-120 〜 121)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-120 | Snippetモデルの属性定義 | E-21 (L1-12) | ○ |
| C-121 | validationType設定 | E-21 (L5) | ○ |

### Tag モデル (UT-ADM-122 〜 130)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-122 | Tagモデルの属性定義 | E-22 (L1-62) | ○ |
| C-123 | validationType設定 | E-22 (L9) | ○ |
| C-124 | isInternal | E-22 (L33) | ○ |
| C-125 | isPublic | E-22 (L34) | ○ |
| C-126 | updateVisibility（#で始まる） | E-22 (L38-41) | ○ |
| C-127 | updateVisibility（#で始まらない） | E-22 (L38-41) | ○ |
| C-128 | save（名前変更時） | E-22 (L43-60) | ○ |
| C-129 | save（キャッシュ更新） | E-22 (L55-57) | ○ |
| C-130 | save（削除時） | E-22 (L55) | ○ |

### Theme モデル (UT-ADM-131 〜 141)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | Themeモデルの属性定義 | E-23 (L1-112) | ○ |
| C-132 | customTemplates | E-23 (L13-19) | ○ |
| C-133 | slugTemplates | E-23 (L21-27) | ○ |
| C-134 | customTemplates（空配列） | E-23 (L13-14) | ○ |
| C-135 | codedWarnings | E-23 (L29-41) | ○ |
| C-136 | codedErrors | E-23 (L43-55) | ○ |
| C-137 | codedErrorsAndWarnings | E-23 (L57-75) | ○ |
| C-138 | hasPageBuilderFeature（エラー無し） | E-23 (L77-87) | ○ |
| C-139 | hasPageBuilderFeature（エラー有り） | E-23 (L77-87) | ○ |
| C-140 | activate正常系 | E-23 (L89-111) | ○ |
| C-141 | activate（排他処理） | E-23 (L95-107) | ○ |

### TierBenefitItem オブジェクト (UT-ADM-142 〜 147)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-142 | TierBenefitItemの属性定義 | E-24 (L1-22) | ○ |
| C-143 | isComplete正常系 | E-24 (L11-15) | ○ |
| C-144 | isComplete異常系 | E-24 (L11-15) | ○ |
| C-145 | isBlank正常系 | E-24 (L17-21) | ○ |
| C-146 | isBlank異常系 | E-24 (L17-21) | ○ |
| C-147 | validationType設定 | E-24 (L9) | ○ |

### Tier モデル (UT-ADM-148 〜 152)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-148 | Tierモデルの属性定義 | E-25 (L1-19) | ○ |
| C-149 | validationType設定 | E-25 (L5) | ○ |
| C-150 | visibilityデフォルト値 | E-25 (L12) | ○ |
| C-151 | typeデフォルト値 | E-25 (L13) | ○ |
| C-152 | trialDaysデフォルト値 | E-25 (L17) | ○ |

### User モデル (UT-ADM-153 〜 185)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-153 | UserがBaseModelを継承 | E-26 (L1, L11) | ○ |
| C-154 | validationType設定 | E-26 (L20) | ○ |
| C-155 | isContributor | E-26 (L56) | ○ |
| C-156 | isAuthor | E-26 (L57) | ○ |
| C-157 | isEditor | E-26 (L58) | ○ |
| C-158 | isAdminOnly | E-26 (L59) | ○ |
| C-159 | isOwnerOnly | E-26 (L60) | ○ |
| C-160 | isSuperEditor | E-26 (L61) | ○ |
| C-161 | isAdmin | E-26 (L65) | ○ |
| C-162 | isEitherEditor | E-26 (L62) | ○ |
| C-163 | isAuthorOrContributor | E-26 (L66) | ○ |
| C-164 | canManageMembers | E-26 (L71) | ○ |
| C-165 | canManageComments | E-26 (L72) | ○ |
| C-166 | isLoggedIn正常系 | E-26 (L74-76) | ○ |
| C-167 | isLoggedIn異常系 | E-26 (L74-76) | ○ |
| C-168 | isActive（active） | E-26 (L78-81) | ○ |
| C-169 | isActive（locked） | E-26 (L80) | ○ |
| C-170 | isActive（inactive） | E-26 (L78-81) | ○ |
| C-171 | isSuspended | E-26 (L83) | ○ |
| C-172 | isLocked | E-26 (L84) | ○ |
| C-173 | role(getter) | E-26 (L86-97) | ○ |
| C-174 | role(setter) | E-26 (L90-96) | ○ |
| C-175 | profileImageUrl正常系 | E-26 (L99-104) | ○ |
| C-176 | profileImageUrl（デフォルト） | E-26 (L103) | ○ |
| C-177 | coverImageUrl正常系 | E-26 (L106-111) | ○ |
| C-178 | coverImageUrl（デフォルト） | E-26 (L110) | ○ |
| C-179 | saveNewPasswordTask正常系 | E-26 (L113-152) | ○ |
| C-180 | saveNewPasswordTask（バリデーションエラー） | E-26 (L116-121) | ○ |
| C-181 | saveNewPasswordTask（APIエラー） | E-26 (L149-151) | ○ |
| C-182 | save（名前変更） | E-26 (L154-168) | ○ |
| C-183 | save（URL変更） | E-26 (L160) | ○ |
| C-184 | save（削除） | E-26 (L162) | ○ |
| C-185 | hasMany(role) | E-26 (L38-41) | ○ |

### Webhook モデル (UT-ADM-186 〜 188)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-186 | Webhookモデルの属性定義 | E-27 (L1-16) | ○ |
| C-187 | validationType設定 | E-27 (L5) | ○ |
| C-188 | integrationリレーション | E-27 (L15) | ○ |

### ValidationEngine Mixin (UT-ADM-189 〜 197)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-189 | validate正常系 | E-28 (L94-135) | ○ |
| C-190 | validate異常系 | E-28 (L131-133) | ○ |
| C-191 | validate（バリデーター不存在） | E-28 (L119-120) | ○ |
| C-192 | validate（property指定） | E-28 (L123-126) | ○ |
| C-193 | save正常系 | E-28 (L142-170) | ○ |
| C-194 | save異常系 | E-28 (L162-169) | ○ |
| C-195 | save（isDeleted） | E-28 (L151-153) | ○ |
| C-196 | beforeSaveフック | E-28 (L158-159) | ○ |
| C-197 | hasValidated | E-28 (L125) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全てのテストケースがソースコードから根拠を持って生成されています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**
  - Action, Mention, Notification, Snippet モデル: シンプルな属性定義のみ
- **1: 中リスク**
  - NavigationItem, TierBenefitItem: computed propertiesの境界値テスト
  - Theme: テンプレートフィルタリングとエラー/警告グループ化
  - Role, Label: 単純なモデルだがバリデーション連携あり
- **2: 高リスク**
  - Post: 最も複雑なモデル、多数のcomputed properties、ステータス管理、タイムゾーン処理
  - User: 権限管理、パスワード変更、セキュリティ関連
  - Email: 開封率計算、リトライ処理
  - Member: サインインURL生成、全デバイスログアウト
  - Integration: APIキー管理
  - ValidationEngine: 全モデルに影響するバリデーションフレームワーク

## 6) レビュアーチェックリスト（最小）
- [ ] Post モデルのcomputed properties（特にvisibilitySegment、fullRecipientFilter）の境界値テストが十分か
- [ ] User モデルの権限判定（isAdmin, canManageMembers等）の組み合わせテストが網羅されているか
- [ ] Email モデルのopenRate計算でゼロ除算以外の異常ケース（負の値等）を考慮すべきか
- [ ] Theme モデルのactivate()における他テーマの非アクティブ化処理のレース条件テストが必要か
- [ ] ValidationEngine mixinのvalidate()でモデル指定とthis指定の両方のケースがテストされているか
- [ ] Newsletter モデルのrecipientFilterで複雑なフィルター条件の組み合わせテストが必要か
- [ ] moment-utc変換のタイムゾーン境界ケース（サマータイム切替等）のテストを追加すべきか
