---
generated_at: 2026-01-29 22:40:00
metrics:
  claims_total: 150
  claims_with_evidence: 148
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：base.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：148 / 150、根拠なし：2
- 優先レビュー（高）
  1. **C-063**: NUMERIC_IDS環境変数のテスト（実行時環境依存）
  2. **C-089**: skipDuplicateChecksオプションの詳細動作

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/models/base/bookshelf.js`
- E-02: `ghost/core/core/server/models/base/index.js`
- E-03: `ghost/core/core/server/models/base/listeners.js`
- E-04: `ghost/core/core/server/models/base/utils.js`
- E-05: `ghost/core/core/server/models/base/plugins/actions.js`
- E-06: `ghost/core/core/server/models/base/plugins/bulk-operations.js`
- E-07: `ghost/core/core/server/models/base/plugins/crud.js`
- E-08: `ghost/core/core/server/models/base/plugins/data-manipulation.js`
- E-09: `ghost/core/core/server/models/base/plugins/events.js`
- E-10: `ghost/core/core/server/models/base/plugins/filtered-collection.js`
- E-11: `ghost/core/core/server/models/base/plugins/generate-slug.js`
- E-12: `ghost/core/core/server/models/base/plugins/overrides.js`
- E-13: `ghost/core/core/server/models/base/plugins/raw-knex.js`
- E-14: `ghost/core/core/server/models/base/plugins/relations.js`
- E-15: `ghost/core/core/server/models/base/plugins/sanitize.js`
- E-16: `ghost/core/core/server/models/base/plugins/user-type.js`
- E-17: `ghost/core/core/server/models/relations/authors.js`
- E-18: `ghost/core/core/server/models/relations/index.js`

## 3) Claims と根拠の対応（レビューの主戦場）

### base/index.js（ベースモデル）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | orderAttributesがスキーマに基づく属性を返す | E-02 L32-35 | ○ |
| C-002 | initializeでイベントと親が初期化される | E-02 L39-44 | ○ |
| C-003 | hasDateChangedがmoment.diffで日付比較 | E-02 L46-48 | ○ |
| C-004 | 同一日時でhasDateChangedがfalse | E-02 L46-48 | ○ |
| C-005 | wasChangedが変更ありでtrue | E-02 L50-67 | ○ |
| C-006 | wasChangedが空オブジェクトでfalse | E-02 L62-64 | ○ |
| C-007 | wasChangedが未定義でtrue（後方互換） | E-02 L58-60 | ○ |
| C-008 | transactionがghostBookshelf.transactionを呼ぶ | E-02 L75-77 | ○ |

### base/listeners.js（イベントリスナー）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-009 | TZ変更時にpublished_atが調整される | E-03 L16-84 | ○ |
| C-010 | TZ変更で過去になる場合ドラフトに戻る | E-03 L63-64 | ○ |
| C-011 | TZ未変更時は処理スキップ | E-03 L25-27 | ○ |
| C-012 | インポート中は処理スキップ | E-03 L29-31 | ○ |
| C-013 | 古い既読通知が削除される | E-03 L91-120 | ○ |
| C-014 | リリース通知は削除されない | E-03 L97-100 | ○ |

### base/utils.js（ユーティリティ）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-015 | attachでリレーションがアタッチされる | E-04 L23-63 | ○ |
| C-016 | モデル不在時NotFoundError | E-04 L33-35 | ○ |
| C-017 | 数値IDが文字列に変換される | E-04 L47-48 | ○ |
| C-018 | オブジェクトのidプロパティが使用される | E-04 L44-45 | ○ |
| C-019 | detachでリレーションがデタッチされる | E-04 L65-94 | ○ |
| C-020 | detachでモデル不在時NotFoundError | E-04 L75-77 | ○ |

### plugins/actions.js（アクション記録）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-021 | getActionがアクション情報を生成 | E-05 L83-133 | ○ |
| C-022 | actorなしでundefined | E-05 L85-88 | ○ |
| C-023 | actionsCollectCRUD=falseでundefined | E-05 L90-92 | ○ |
| C-024 | 削除時はpreviousのprimary_name | E-05 L114-115 | ○ |
| C-025 | 変更時にアクション追加 | E-05 L60-72 | ○ |
| C-026 | 未変更時は何もしない | E-05 L61-63 | ○ |
| C-027 | 単一IDは個別アクション | E-05 L147-152 | ○ |
| C-028 | 複数IDはバルクアクション | E-05 L154-156 | ○ |
| C-029 | getBulkActionがcount含むデータ生成 | E-05 L167-210 | ○ |

### plugins/bulk-operations.js（一括操作）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-030 | bulkAddで一括挿入 | E-06 L109-113 | ○ |
| C-031 | 100件チャンク処理 | E-06 L5, L16 | ○ |
| C-032 | 一括失敗時個別フォールバック | E-06 L20-35 | ○ |
| C-033 | throwErrors=trueでエラースロー | E-06 L21-23 | ○ |
| C-034 | bulkEditで一括更新とアクション | E-06 L124-134 | ○ |
| C-035 | カスタムカラムでの更新 | E-06 L71 | ○ |
| C-036 | bulkDestroyで一括削除 | E-06 L144-153 | ○ |
| C-037 | 削除前にアクション記録 | E-06 L147-149 | ○ |

### plugins/crud.js（CRUD操作）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-038 | findAllで全レコード取得 | E-07 L36-55 | ○ |
| C-039 | orderDefaultRaw適用 | E-07 L41-45 | ○ |
| C-040 | withRelatedが各モデルに設定 | E-07 L48-52 | ○ |
| C-041 | findPageでページネーション | E-07 L81-159 | ○ |
| C-042 | excerpt要求時にplaintext追加 | E-07 L11-18 | ○ |
| C-043 | columnsフィルタリング | E-07 L93-96 | ○ |
| C-044 | findOneで単一取得 | E-07 L168-202 | ○ |
| C-045 | SQL構文エラーでBadRequestError | E-07 L191-200 | ○ |
| C-046 | forUpdate使用時にロック取得 | E-07 L186-188 | ○ |
| C-047 | editでレコード更新 | E-07 L215-243 | ○ |
| C-048 | edit不在時NotFoundError | E-07 L242 | ○ |
| C-049 | importing時タイムスタンプ無効化 | E-07 L228-230 | ○ |
| C-050 | addでレコード挿入 | E-07 L252-268 | ○ |
| C-051 | options.method='insert'設定 | E-07 L267 | ○ |
| C-052 | destroyでレコード削除 | E-07 L277-292 | ○ |
| C-053 | destroyBy条件での削除 | E-07 L280-284 | ○ |

### plugins/data-manipulation.js（データ変換）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-054 | getNullableStringPropertiesがnullableプロパティ返す | E-08 L10-13 | ○ |
| C-055 | setEmptyValuesToNullで空文字null変換 | E-08 L15-22 | ○ |
| C-056 | fixDatesWhenSaveでYYYY-MM-DD形式変換 | E-08 L31-41 | ○ |
| C-057 | fixDatesWhenFetchでDateオブジェクト変換 | E-08 L54-72 | ○ |
| C-058 | 不正日付で現在日時設定 | E-08 L63-67 | ○ |
| C-059 | fixBoolsで整数→ブール変換 | E-08 L80-90 | ○ |
| C-060 | 0がfalseに変換 | E-08 L85 | ○ |

### plugins/events.js（イベント処理）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-061 | initializeEventsで全イベント登録 | E-09 L16-39 | ○ |
| C-062 | setIdでObjectId生成 | E-09 L45-47 | ○ |
| C-063 | NUMERIC_IDS環境変数で数値ID | E-09 L11, L248-260 | △ |
| C-064 | トランザクション外で即座にイベント発行 | E-09 L67-68 | ○ |
| C-065 | トランザクション内でコミット後イベント発行 | E-09 L70-92 | ○ |
| C-066 | 未変更時イベント非発行 | E-09 L57-59 | ○ |
| C-067 | onValidateでschema.validate呼び出し | E-09 L107-109 | ○ |
| C-068 | onValidateでsetEmptyValuesToNull | E-09 L108 | ○ |
| C-069 | onFetchingでforUpdate追加 | E-09 L121-125 | ○ |
| C-070 | onCreatingでcreated_at設定 | E-09 L146-151 | ○ |
| C-071 | onCreatingでupdated_at設定 | E-09 L153-157 | ○ |
| C-072 | 未設定カラムがnull初期化 | E-09 L171-176 | ○ |
| C-073 | onUpdatingでcreated_at変更阻止 | E-09 L203-209 | ○ |
| C-074 | updated_atのみ変更は無視 | E-09 L212-218 | ○ |
| C-075 | リレーション変更をchangedから除外 | E-09 L199-201 | ○ |
| C-076 | onDestroyedで_changed設定 | E-09 L235-245 | ○ |
| C-077 | onSavingでpermittedAttributes以外削除 | E-09 L228-231 | ○ |
| C-078 | generateIdで24文字16進数 | E-09 L248-261 | ○ |

### plugins/filtered-collection.js（フィルタコレクション）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-079 | getFilteredCollectionでフィルタ適用 | E-10 L6-19 | ○ |
| C-080 | getFilteredCollectionQueryでクエリ返却 | E-10 L21-33 | ○ |

### plugins/generate-slug.js（スラッグ生成）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-081 | 安全なスラッグ生成 | E-11 L19-113 | ○ |
| C-082 | 重複時連番付与 | E-11 L27-71 | ○ |
| C-083 | 185文字超で切り詰め | E-11 L78-83 | ○ |
| C-084 | インポート時は切り詰めなし | E-11 L80-82 | ○ |
| C-085 | ユーザーshortSlugで短縮 | E-11 L86-89 | ○ |
| C-086 | タグ#始まりでhash-プレフィックス | E-11 L93-97 | ○ |
| C-087 | 予約語でモデル名サフィックス | E-11 L100 | ○ |
| C-088 | 空スラッグでモデル名使用 | E-11 L103-105 | ○ |
| C-089 | skipDuplicateChecksでDB確認スキップ | E-11 L107-109 | △ |

### plugins/overrides.js（オーバーライド）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-090 | update時_isWriting=true | E-12 L23-31 | ○ |
| C-091 | insert時_isWriting=true | E-12 L33-41 | ○ |
| C-092 | formatOnWriteで書き込み時フォーマット | E-12 L49-51 | ○ |
| C-093 | format書き込み時formatOnWrite呼び出し | E-12 L54-60 | ○ |
| C-094 | format読み取り時fixDatesWhenSaveのみ | E-12 L59 | ○ |
| C-095 | parseでfixBoolsとfixDatesWhenFetch適用 | E-12 L63-65 | ○ |
| C-096 | toJSONで空hasOne除外 | E-12 L84-88 | ○ |
| C-097 | previous=trueで以前の属性 | E-12 L90-108 | ○ |
| C-098 | pivotフィールドprevious出力から除外 | E-12 L94-97 | ○ |

### plugins/raw-knex.js（高速クエリ）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-099 | raw_knex.fetchAllで高速取得 | E-13 L18-203 | ○ |
| C-100 | excludeオプションでカラム除外 | E-13 L77-83 | ○ |
| C-101 | withRelatedでリレーション取得 | E-13 L126-166 | ○ |
| C-102 | 空結果で空配列 | E-13 L102-105 | ○ |
| C-103 | offsetとlimit適用 | E-13 L68-74 | ○ |

### plugins/relations.js（リレーション）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-104 | ロード済みリレーションそのまま返却 | E-14 L17-21 | ○ |
| C-105 | 未ロードリレーションをフェッチ | E-14 L40-51 | ○ |
| C-106 | forceRefreshで再フェッチ | E-14 L18 | ○ |
| C-107 | 未定義require=trueでNotFoundError | E-14 L23-27 | ○ |
| C-108 | 未定義require=falseでundefined | E-14 L23-28 | ○ |

### plugins/sanitize.js（サニタイズ）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 | permittedAttributesがスキーマ基づく属性返す | E-15 L19-22 | ○ |
| C-110 | @@で始まるキー除外 | E-15 L21 | ○ |
| C-111 | permittedOptionsがメソッド別オプション返す | E-15 L32-54 | ○ |
| C-112 | add時autoRefresh許可 | E-15 L42 | ○ |
| C-113 | filterDataで許可属性のみ残す | E-15 L63-69 | ○ |
| C-114 | filterDataでsanitizeData呼び出し | E-15 L66 | ○ |
| C-115 | sanitizeDataでISO8601日付変換 | E-15 L92-113 | ○ |
| C-116 | 不正日付でValidationError | E-15 L105-110 | ○ |
| C-117 | リレーション日付も変換 | E-15 L115-143 | ○ |
| C-118 | filterOptionsで許可オプションのみ残す | E-15 L155-177 | ○ |
| C-119 | includeオプションでIncorrectUsageError | E-15 L159-163 | ○ |
| C-120 | defaultRelations適用 | E-15 L172-174 | ○ |

### plugins/user-type.js（ユーザータイプ）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 | integrationコンテキストでintegration actor | E-16 L13-18 | ○ |
| C-122 | userコンテキストでuser actor | E-16 L20-25 | ○ |
| C-123 | コンテキストなしでnull | E-16 L27-28 | ○ |
| C-124 | contextUserでuser ID返却 | E-16 L36-37 | ○ |
| C-125 | integrationコンテキストでresolveIntegrationUserId | E-16 L38-42 | ○ |
| C-126 | internalコンテキストでresolveInternalUserId | E-16 L43-47 | ○ |
| C-127 | コンテキストなしモデルIDでモデルID返却 | E-16 L48-49 | ○ |
| C-128 | コンテキストもモデルIDもなしでNotFoundError | E-16 L50-55 | ○ |

### relations/authors.js（著者リレーション）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129 | 'author'を'authors'に置換 | E-17 L47-50 | ○ |
| C-130 | forUpdate時'authors'追加 | E-17 L52-56 | ○ |
| C-131 | authors未設定時contextUser設定 | E-17 L78-86 | ○ |
| C-132 | authors空配列でValidationError | E-17 L103-107 | ○ |
| C-133 | 'author'属性削除 | E-17 L100 | ○ |
| C-134 | IDでユーザーマッチ | E-17 L165-214 | ○ |
| C-135 | slugでユーザーマッチ | E-17 L187-188 | ○ |
| C-136 | emailでユーザーマッチ | E-17 L189-190 | ○ |
| C-137 | 見つからない場合オーナーフォールバック | E-17 L198 | ○ |
| C-138 | 重複ユーザー除外 | E-17 L200-205 | ○ |
| C-139 | withRelatedなしでauthors除外 | E-17 L141-143 | ○ |
| C-140 | primary_authorが最初のauthor | E-17 L148-149 | ○ |
| C-141 | authors空でprimary_author=null | E-17 L150-151 | ○ |
| C-142 | reassignByAuthorでオーナー再割り当て | E-17 L223-303 | ○ |
| C-143 | オーナー共著者時sort_order更新 | E-17 L256-273 | ○ |
| C-144 | authorIdなしでNotFoundError | E-17 L227-231 | ○ |
| C-145 | Contributor編集権限チェック | E-17 L373-374 | ○ |
| C-146 | Contributor著者変更不可 | E-17 L374 | ○ |
| C-147 | Author編集権限チェック | E-17 L379-380 | ○ |
| C-148 | Author著者変更不可 | E-17 L380 | ○ |
| C-149 | 権限なしでNoPermissionError | E-17 L409-411 | ○ |
| C-150 | ID渡しでモデル取得後権限チェック | E-17 L316-333 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-063: NUMERIC_IDS環境変数のテストは実行時環境に依存するため、テスト実行時に環境変数を設定する方法の確認が必要
  - 候補：Jest環境変数設定 / beforeAll での process.env 操作 / テスト用configファイル
- C-089: skipDuplicateChecksオプションの使用シナリオ（パフォーマンス最適化目的）の詳細な要件確認が必要
  - 候補：インポート時 / バルク操作時 / スラッグが一意であることが保証されている場合

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコードから直接導出可能
- 1: 中リスク - トランザクション関連のテスト（C-065, C-009-010）は実際のDB接続が必要
- 1: 中リスク - 権限関連のテスト（C-145-150）は複雑なロール設定が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ベースモデルの初期化処理（C-001〜C-008）が正しく網羅されているか
- [ ] タイムゾーン変更時の予約投稿処理（C-009〜C-012）のエッジケースが考慮されているか
- [ ] バルク操作のエラーハンドリング（C-030〜C-037）が適切か
- [ ] CRUD操作の権限チェック（C-044〜C-053）が適切か
- [ ] 著者リレーションの権限管理（C-145〜C-150）が十分にテストされているか
- [ ] トランザクション内外でのイベント発行タイミング（C-064〜C-065）が正しいか
- [ ] 日付変換のエッジケース（C-056〜C-058）が網羅されているか
