---
generated_at: 2026-01-29 22:30:00
metrics:
  claims_total: 72
  claims_with_evidence: 72
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：comments モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：72 / 72、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/models/comment.js` (行1-317)
- E-02: `ghost/core/core/server/models/comment-like.js` (行1-35)
- E-03: `ghost/core/core/server/models/comment-report.js` (行1-35)

## 3) Claims と根拠の対応（レビューの主戦場）

### Comment モデル

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | defaults()でstatus: 'published'が返却される | E-01 (行27-31) | ○ |
| C-02 | post()がbelongsTo('Post', 'post_id')を返す | E-01 (行33-35) | ○ |
| C-03 | member()がbelongsTo('Member', 'member_id')を返す | E-01 (行37-39) | ○ |
| C-04 | parent()がbelongsTo('Comment', 'parent_id')を返す | E-01 (行41-43) | ○ |
| C-05 | inReplyTo()がbelongsTo('Comment', 'in_reply_to_id')を返す | E-01 (行45-47) | ○ |
| C-06 | likes()がhasMany('CommentLike', 'comment_id')を返す | E-01 (行49-51) | ○ |
| C-07 | replies()がhasMany('Comment', 'parent_id', 'id')を返しcreated_at昇順でソート | E-01 (行53-58) | ○ |
| C-08 | applyCustomQuery()で公開時hidden/deleted除外 | E-01 (行62-63) | ○ |
| C-09 | applyCustomQuery()で管理者時deleted除外 | E-01 (行62) | ○ |
| C-10 | applyCustomQuery()でbrowseAllオプション処理 | E-01 (行65-68) | ○ |
| C-11 | applyCustomQuery()でスレッド構造保持ロジック | E-01 (行69-79) | ○ |
| C-12 | applyCustomQuery()でreportCountフィルタ | E-01 (行82-85) | ○ |
| C-13 | emitChange()でイベント発行 | E-01 (行89-92) | ○ |
| C-14 | onSaving()でHTMLサニタイズ | E-01 (行94-124) | ○ |
| C-15 | onSaving()で許可タグ(p, br, a, blockquote)のみ残す | E-01 (行102-103) | ○ |
| C-16 | onSaving()でリンクにtarget/rel属性追加 | E-01 (行107-113) | ○ |
| C-17 | onSaving()でtrimParagraphs実行 | E-01 (行100-101) | ○ |
| C-18 | onSaving()で空コメント時ValidationError | E-01 (行117-121) | ○ |
| C-19 | orderAttributes()でcount__likes, count__reports追加 | E-01 (行126-131) | ○ |
| C-20 | onCreated()でaddedイベント発行 | E-01 (行133-137) | ○ |
| C-21 | enforcedFilters()でparentIdフィルタ生成 | E-01 (行139-149) | ○ |
| C-22 | destroy()でソフト削除(status: 'deleted') | E-01 (行152-167) | ○ |
| C-23 | destroy()でトランザクション処理 | E-01 (行159-164) | ○ |
| C-24 | applyRepliesWithRelatedOption()で返信フィルタ | E-01 (行169-185) | ○ |
| C-25 | defaultRelations()でデフォルトリレーション設定 | E-01 (行192-229) | ○ |
| C-26 | defaultRelations()でparentId時の返信除外 | E-01 (行198-208) | ○ |
| C-27 | defaultRelations()で管理者時count.reports追加 | E-01 (行206-208, 218-221) | ○ |
| C-28 | findPage()でページネーション | E-01 (行231-249) | ○ |
| C-29 | findPage()で返信の個別ロード | E-01 (行234-247) | ○ |
| C-30 | countRelations.replies()で返信カウント | E-01 (行253-262) | ○ |
| C-31 | countRelations.replies()でステータスフィルタ | E-01 (行254, 260) | ○ |
| C-32 | countRelations.likes()でいいねカウント | E-01 (行264-270) | ○ |
| C-33 | countRelations.liked()でログインユーザーいいね判定 | E-01 (行272-285) | ○ |
| C-34 | countRelations.liked()で未ログイン時0 | E-01 (行283-284) | ○ |
| C-35 | countRelations.reports()で通報カウント | E-01 (行287-294) | ○ |
| C-36 | permittedOptions()でカスタムオプション追加 | E-01 (行303-311) | ○ |

### trimParagraphs ヘルパー関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | 先頭の空段落削除 | E-01 (行14-22) | ○ |
| C-38 | 末尾の空段落削除 | E-01 (行14-22) | ○ |
| C-39 | 連続空段落を1つにまとめる | E-01 (行20-21) | ○ |

### CommentLike モデル

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | defaults()が空オブジェクトを返す | E-02 (行5-8) | ○ |
| C-41 | comment()がbelongsTo('Comment', 'comment_id')を返す | E-02 (行10-12) | ○ |
| C-42 | member()がbelongsTo('Member', 'member_id')を返す | E-02 (行14-16) | ○ |
| C-43 | emitChange()で'comment_like.{event}'イベント発行 | E-02 (行18-21) | ○ |
| C-44 | onCreated()でaddedイベント発行 | E-02 (行23-27) | ○ |

### CommentReport モデル

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | defaults()が空オブジェクトを返す | E-03 (行5-8) | ○ |
| C-46 | comment()がbelongsTo('Comment', 'comment_id')を返す | E-03 (行10-12) | ○ |
| C-47 | member()がbelongsTo('Member', 'member_id')を返す | E-03 (行14-16) | ○ |
| C-48 | emitChange()で'comment_report.{event}'イベント発行 | E-03 (行18-21) | ○ |
| C-49 | onCreated()でaddedイベント発行 | E-03 (行23-27) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全てのテストケースはソースコードから直接導出

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコード根拠あり

### 注意事項
- Bookshelf.js ORMの特性上、リレーションの動作はORMの実装に依存
- sanitize-htmlライブラリの詳細な挙動はライブラリのテストで検証済みと想定
- ValidationErrorのメッセージ内容は`@tryghost/tpl`の実装に依存

## 6) レビュアーチェックリスト（最小）
- [ ] Comment.onSaving()のHTMLサニタイズが想定通りのタグを許可/拒否しているか
- [ ] Comment.applyCustomQuery()のステータスフィルタリングが公開/管理者で正しく動作するか
- [ ] Comment.destroy()のソフト削除がトランザクション内で正しく動作するか
- [ ] countRelations.liked()がログイン/未ログイン状態で正しく動作するか
- [ ] 各モデルのリレーションが正しいテーブル・カラムを参照しているか
