---
generated_at: 2026-01-29 10:30:00
metrics:
  claims_total: 155
  claims_with_evidence: 152
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：content.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：152 / 155、根拠なし：3
- 優先レビュー（高）
  1. **UT-CNT-083〜089（permissible）**：権限チェックロジックは複雑で実際の動作確認が必要
  2. **UT-CNT-028〜031（onSaving バリデーション）**：エラーメッセージの正確性を確認
  3. **UT-CNT-090〜094（countRelations）**：SQLクエリの実行結果は実際のDBでの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/models/post.js` (行1-1535)
- E-02: `ghost/core/core/server/models/posts-meta.js` (行1-43)
- E-03: `ghost/core/core/server/models/post-revision.js` (行1-48)
- E-04: `ghost/core/core/server/models/mobiledoc-revision.js` (行1-35)
- E-05: `ghost/core/core/server/models/tag.js` (行1-219)
- E-06: `ghost/core/core/server/models/tag-public.js` (行1-19)
- E-07: `ghost/core/core/server/models/author.js` (行1-19)
- E-08: `ghost/core/core/server/models/snippet.js` (行1-74)
- E-09: `ghost/core/core/server/models/custom-theme-setting.js` (行1-65)
- E-10: `ghost/core/core/server/models/collection.js` (行1-118)
- E-11: `ghost/core/core/server/models/collection-post.js` (行1-10)
- E-12: `ghost/core/core/server/models/base/index.js` (Bookshelf基底クラス)
- E-13: `docs/code-to-docs/単体テストケース一覧/plan.md` (モジュール定義)

## 3) Claims と根拠の対応（レビューの主戦場）

### Post Model (UT-CNT-001〜094)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Post.defaultsがデフォルト値を設定する | E-01 (行72-100) | ○ |
| C-02 | Post.defaultsがtiers配列を設定する | E-01 (行77-88) | ○ |
| C-03 | Post.defaultsがvisibility=paidを設定する | E-01 (行85-87) | ○ |
| C-04 | Post.parseがURL変換を行う | E-01 (行151-174) | ○ |
| C-05 | Post.parseがnull値を処理する | E-01 (行168-170) | ○ |
| C-06 | Post.formatOnWriteがmobiledocを変換する | E-01 (行177-238) | ○ |
| C-07 | Post.formatOnWriteがlexicalを変換する | E-01 (行186-191) | ○ |
| C-08 | Post.formatOnWriteがvisibility=status:-freeをpaidに変換する | E-01 (行225-228) | ○ |
| C-09 | Post.formatOnWriteがvisibility=membersに変換する | E-01 (行229-234) | ○ |
| C-10 | Post.permittedAttributesがrelationshipsを含む | E-01 (行245-253) | ○ |
| C-11 | Post.orderAttributesがposts_metaキーを含む | E-01 (行255-262) | ○ |
| C-12 | Post.orderRawQueryがsentimentソートを返す | E-01 (行264-275) | ○ |
| C-13 | Post.orderRawQueryがemail.open_rateソートを返す | E-01 (行276-289) | ○ |
| C-14 | Post.filterExpansionsがprimary_tagを展開する | E-01 (行294-298) | ○ |
| C-15 | Post.filterExpansionsがprimary_authorを展開する | E-01 (行299-302) | ○ |
| C-16 | Post.filterRelationsがtagsリレーションを定義する | E-01 (行326-334) | ○ |
| C-17 | Post.filterRelationsがauthorsリレーションを定義する | E-01 (行335-343) | ○ |
| C-18 | Post.emitChangeがイベントを発火する | E-01 (行356-367) | ○ |
| C-19 | Post.emitChangeがpage.eventを発火する | E-01 (行358-364) | ○ |
| C-20 | Post.onSavedがaddedイベントを発火する | E-01 (行378-392) | ○ |
| C-21 | Post.onSavedがpublished状態でpublishedイベントを発火する | E-01 (行389-391) | ○ |
| C-22 | Post.onUpdatedがステータス変更時にイベントを発火する | E-01 (行394-464) | ○ |
| C-23 | Post.onUpdatedがリソースタイプ変更時にdeleted/addedを発火する | E-01 (行406-426) | ○ |
| C-24 | Post.onUpdatedが編集時にeditedイベントを発火する | E-01 (行447-458) | ○ |
| C-25 | Post.onUpdatedがリスケジュール時にrescheduledを発火する | E-01 (行452-454) | ○ |
| C-26 | Post.onDestroyedがdeletedイベントを発火する | E-01 (行466-474) | ○ |
| C-27 | Post.onDestroyedが公開済み削除時にunpublishedを発火する | E-01 (行469-471) | ○ |
| C-28 | Post.onSavingがpublished->scheduledを拒否する | E-01 (行565-571) | ○ |
| C-29 | Post.onSavingがscheduled時にpublished_at必須をチェックする | E-01 (行580-589) | ○ |
| C-30 | Post.onSavingがpublished_atの有効性をチェックする | E-01 (行585-589) | ○ |
| C-31 | Post.onSavingが最小スケジュール時間をチェックする | E-01 (行590-602) | ○ |
| C-32 | Post.onSavingがタグの重複を除去する | E-01 (行627-651) | ○ |
| C-33 | Post.onSavingがposts_metaにidを付与する | E-01 (行657-667) | ○ |
| C-34 | Post.onSavingがlexicalをデフォルト設定する | E-01 (行682-684) | ○ |
| C-35 | Post.onSavingがmobiledocからhtmlを生成する | E-01 (行695-711) | ○ |
| C-36 | Post.onSavingが不正なmobiledocでエラーをスローする | E-01 (行705-710) | ○ |
| C-37 | Post.onSavingがlexicalからhtmlを生成する | E-01 (行716-734) | ○ |
| C-38 | Post.onSavingが不正なlexicalでエラーをスローする | E-01 (行726-733) | ○ |
| C-39 | Post.onSavingがhtmlからplaintextを生成する | E-01 (行736-751) | ○ |
| C-40 | Post.onSavingが空タイトルに(Untitled)を設定する | E-01 (行754-757) | ○ |
| C-41 | Post.onSavingがpublished時にpublished_atを設定する | E-01 (行761-763) | ○ |
| C-42 | Post.onSavingがpublished_byを設定する | E-01 (行766-777) | ○ |
| C-43 | Post.onSavingがnewsletterパラメータでnewsletter_idを設定する | E-01 (行779-803) | ○ |
| C-44 | Post.onSavingが存在しないnewsletterでエラーをスローする | E-01 (行787-790) | ○ |
| C-45 | Post.onSavingがemail_onlyフラグでstatusをsentに変更する | E-01 (行819-825) | ○ |
| C-46 | Post.onSavingがタイトル変更時にslugを更新する | E-01 (行828-860) | ○ |
| C-47 | Post.onSavingがmobiledoc変更時にリビジョンを作成する | E-01 (行862-905) | ○ |
| C-48 | Post.onSavingがconvert_to_lexicalオプションで変換する | E-01 (行953-963) | ○ |
| C-49 | Post.tiersリレーションがProductsを返す | E-01 (行140-149) | ○ |
| C-50 | Post.authorsリレーションがUsersを返す | E-01 (行984-988) | ○ |
| C-51 | Post.tagsリレーションがTagsを返す | E-01 (行990-994) | ○ |
| C-52 | Post.mobiledoc_revisionsリレーションが機能する | E-01 (行996-998) | ○ |
| C-53 | Post.post_revisionsリレーションが機能する | E-01 (行1000-1002) | ○ |
| C-54 | Post.posts_metaリレーションが機能する | E-01 (行1004-1006) | ○ |
| C-55 | Post.emailリレーションが機能する | E-01 (行1008-1010) | ○ |
| C-56 | Post.newsletterリレーションが機能する | E-01 (行1012-1014) | ○ |
| C-57 | Post.defaultColumnsToFetchが[id, published_at, slug]を返す | E-01 (行1045-1047) | ○ |
| C-58 | Post.formatsToJSONが指定フォーマット以外を削除する | E-01 (行1055-1067) | ○ |
| C-59 | Post.toJSONがmobiledoc_revisionsを削除する | E-01 (行1069-1087) | ○ |
| C-60 | Post.toJSONがprimary_tagを計算する | E-01 (行1077-1084) | ○ |
| C-61 | Post.toJSONが公開タグがない場合primary_tagをnullにする | E-01 (行1081-1083) | ○ |
| C-62 | Post.wasChangedが変更検知を行う | E-01 (行1090-1102) | ○ |
| C-63 | Post.wasChangedがposts_meta変更も検知する | E-01 (行1095-1097) | ○ |
| C-64 | Post.wasChangedが変更なしでfalseを返す | E-01 (行1097-1099) | ○ |
| C-65 | Post.enforcedFiltersがpublicでstatus:publishedを返す | E-01 (行1104-1106) | ○ |
| C-66 | Post.enforcedFiltersが非publicでnullを返す | E-01 (行1104-1106) | ○ |
| C-67 | Post.defaultFiltersがpublicでtype:postを返す | E-01 (行1108-1114) | ○ |
| C-68 | Post.defaultFiltersがinternalでnullを返す | E-01 (行1109-1111) | ○ |
| C-69 | Post.extraFiltersがstatusオプションを変換する | E-01 (行1120-1146) | ○ |
| C-70 | Post.extraFiltersがstatus=allで全ステータスを返す | E-01 (行1136-1142) | ○ |
| C-71 | Post.orderDefaultOptionsがデフォルトソートを返す | E-01 (行1160-1167) | ○ |
| C-72 | Post.orderDefaultRawがRAWソートを返す | E-01 (行1169-1189) | ○ |
| C-73 | Post.orderDefaultRawがtagsフィルタ時にカウントソートを追加する | E-01 (行1179-1181) | ○ |
| C-74 | Post.permittedOptionsがeditの許可オプションを返す | E-01 (行1196-1218) | ○ |
| C-75 | Post.defaultRelationsがedit時にリレーションを含む | E-01 (行1228-1244) | ○ |
| C-76 | Post.filterDataがrelationshipsを含む | E-01 (行1252-1258) | ○ |
| C-77 | Post.findOneがpublicでstatus:publishedをデフォルトにする | E-01 (行1267-1280) | ○ |
| C-78 | Post.findOneがstatus=allでステータス条件を削除する | E-01 (行1275-1277) | ○ |
| C-79 | Post.editがトランザクション内で更新する | E-01 (行1287-1325) | ○ |
| C-80 | Post.editが_previousAttributesを保持する | E-01 (行1302-1303) | ○ |
| C-81 | Post.addがトランザクション内で追加する | E-01 (行1340-1362) | ○ |
| C-82 | Post.destroyがトランザクション内で削除する | E-01 (行1364-1379) | ○ |
| C-83 | Post.permissibleがContributorドラフト編集を許可する | E-01 (行1386-1448) | ○ |
| C-84 | Post.permissibleがContributorステータス変更を拒否する | E-01 (行1418-1420) | ○ |
| C-85 | Post.permissibleがContributor公開Post編集を拒否する | E-01 (行1418-1420) | ○ |
| C-86 | Post.permissibleがContributorドラフト追加を許可する | E-01 (行1421-1423) | ○ |
| C-87 | Post.permissibleがContributor公開Post追加を拒否する | E-01 (行1421-1423) | ○ |
| C-88 | Post.permissibleがAdminのvisibility変更を許可する | E-01 (行1427-1428) | ○ |
| C-89 | Post.permissibleが一般ユーザーのvisibility変更を拒否する | E-01 (行1427-1429) | ○ |
| C-90 | Post.countRelations.signupsがカウントを取得する | E-01 (行1452-1459) | ○ |
| C-91 | Post.countRelations.paid_conversionsがカウントを取得する | E-01 (行1460-1467) | ○ |
| C-92 | Post.countRelations.conversionsがカウントを取得する | E-01 (行1471-1487) | ○ |
| C-93 | Post.countRelations.clicksがカウントを取得する | E-01 (行1488-1496) | ○ |
| C-94 | Post.countRelations.sentimentがスコアを取得する | E-01 (行1497-1504) | ○ |

### PostsMeta Model (UT-CNT-095〜099)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | PostsMeta.defaultsがemail_only=falseを返す | E-02 (行7-11) | ○ |
| C-96 | PostsMeta.formatOnWriteがog_imageを変換する | E-02 (行13-21) | ○ |
| C-97 | PostsMeta.formatOnWriteがtwitter_imageを変換する | E-02 (行13-21) | ○ |
| C-98 | PostsMeta.parseがog_imageを絶対URLに変換する | E-02 (行23-33) | ○ |
| C-99 | PostsMeta.parseがtwitter_imageを絶対URLに変換する | E-02 (行23-33) | ○ |

### PostRevision Model (UT-CNT-100〜104)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | PostRevision.authorリレーションがUserを返す | E-03 (行7-9) | ○ |
| C-101 | PostRevision.permittedOptionsがfilter、columnsを含む | E-03 (行11-22) | ○ |
| C-102 | PostRevision.defaultRelationsがauthorを含む | E-03 (行24-30) | ○ |
| C-103 | PostRevision.orderDefaultRawがcreated_at_ts DESCを返す | E-03 (行32-34) | ○ |
| C-104 | PostRevision.toJSONがauthor_idを削除する | E-03 (行36-42) | ○ |

### MobiledocRevision Model (UT-CNT-105〜107)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | MobiledocRevision.permittedOptionsがfilter、columnsを含む | E-04 (行6-17) | ○ |
| C-106 | MobiledocRevision.orderDefaultRawがcreated_at_ts DESCを返す | E-04 (行19-21) | ○ |
| C-107 | MobiledocRevision.toJSONがcreated_at_tsを削除する | E-04 (行23-29) | ○ |

### Tag Model (UT-CNT-108〜128)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | Tag.defaultsがvisibility=publicを返す | E-05 (行20-24) | ○ |
| C-109 | Tag.formatOnWriteがfeature_imageを変換する | E-05 (行26-56) | ○ |
| C-110 | Tag.formatOnWriteがog_imageを変換する | E-05 (行26-56) | ○ |
| C-111 | Tag.formatOnWriteがcanonical_urlを変換する | E-05 (行26-56) | ○ |
| C-112 | Tag.formatOnWriteがcodeinjection_headを変換する | E-05 (行26-56) | ○ |
| C-113 | Tag.parseがfeature_imageを絶対URLに変換する | E-05 (行58-76) | ○ |
| C-114 | Tag.emitChangeがイベントを発火する | E-05 (行78-81) | ○ |
| C-115 | Tag.onCreatedがaddedイベントを発火する | E-05 (行83-87) | ○ |
| C-116 | Tag.onUpdatedがeditedイベントを発火する | E-05 (行89-93) | ○ |
| C-117 | Tag.onDestroyedがdeletedイベントを発火する | E-05 (行95-99) | ○ |
| C-118 | Tag.onSavingがslugからnameを設定する | E-05 (行101-127) | ○ |
| C-119 | Tag.onSavingが#で始まるnameでvisibility=internalを設定する | E-05 (行115-117) | ○ |
| C-120 | Tag.onSavingがslugを自動生成する | E-05 (行119-126) | ○ |
| C-121 | Tag.postsリレーションがPostsを返す | E-05 (行129-131) | ○ |
| C-122 | Tag.toJSONがparent_idをparentに変換する | E-05 (行133-141) | ○ |
| C-123 | Tag.defaultColumnsToFetchが[id]を返す | E-05 (行143-145) | ○ |
| C-124 | Tag.permittedOptionsがfindOneでcolumns、visibilityを含む | E-05 (行151-167) | ○ |
| C-125 | Tag.countRelations.postsがカウントを取得する | E-05 (行169-186) | ○ |
| C-126 | Tag.countRelations.postsがpublicで公開Postのみカウントする | E-05 (行179-183) | ○ |
| C-127 | Tag.destroyが関連Postをデタッチして削除する | E-05 (行189-208) | ○ |
| C-128 | Tag.destroyが存在しないTagでエラーをスローする | E-05 (行196-199) | ○ |

### TagPublic Model (UT-CNT-129)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129 | TagPublic.shouldHavePostsが正しく設定される | E-06 (行4-9) | ○ |

### Author Model (UT-CNT-130)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-130 | Author.shouldHavePostsが正しく設定される | E-07 (行4-9) | ○ |

### Snippet Model (UT-CNT-131〜137)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | Snippet.formatOnWriteがmobiledocを変換する | E-08 (行13-26) | ○ |
| C-132 | Snippet.formatOnWriteがlexicalを変換する | E-08 (行13-26) | ○ |
| C-133 | Snippet.parseがmobiledocを絶対URLに変換する | E-08 (行28-40) | ○ |
| C-134 | Snippet.parseがlexicalを絶対URLに変換する | E-08 (行28-40) | ○ |
| C-135 | Snippet.formatsToJSONが指定フォーマット以外を削除する | E-08 (行42-54) | ○ |
| C-136 | Snippet.formatsToJSONがデフォルトでmobiledocのみ残す | E-08 (行43-44) | ○ |
| C-137 | Snippet.toJSONがformatsToJSONを適用する | E-08 (行55-61) | ○ |

### CustomThemeSetting Model (UT-CNT-138〜145)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-138 | CustomThemeSetting.parseがboolean型で'0'をfalseに変換する | E-09 (行8-28) | ○ |
| C-139 | CustomThemeSetting.parseがboolean型で'1'をtrueに変換する | E-09 (行13-15) | ○ |
| C-140 | CustomThemeSetting.parseがboolean型で'false'をfalseに変換する | E-09 (行17-19) | ○ |
| C-141 | CustomThemeSetting.parseがboolean型で'true'をtrueに変換する | E-09 (行17-19) | ○ |
| C-142 | CustomThemeSetting.parseがimage型でURLを絶対URLに変換する | E-09 (行22-25) | ○ |
| C-143 | CustomThemeSetting.formatがboolean型で'0'をfalseに変換する | E-09 (行30-51) | ○ |
| C-144 | CustomThemeSetting.formatがboolean型でtrueを'true'文字列に変換する | E-09 (行45-47) | ○ |
| C-145 | CustomThemeSetting.formatOnWriteがimage型でURLを変換する | E-09 (行53-59) | ○ |

### Collection Model (UT-CNT-146〜154)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-146 | Collection.hooks.belongsToMany.afterがsort_orderを更新する | E-10 (行7-38) | ○ |
| C-147 | Collection.hooks.belongsToMany.afterがautomatic型でスキップする | E-10 (行16-18) | ○ |
| C-148 | Collection.formatOnWriteがfeature_imageを変換する | E-10 (行40-45) | ○ |
| C-149 | Collection.parseがfeature_imageを絶対URLに変換する | E-10 (行47-55) | ○ |
| C-150 | Collection.permittedAttributesがpostsを含む | E-10 (行87-95) | ○ |
| C-151 | Collection.filterExpansionsがposts -> posts.idに展開する | E-10 (行68-73) | ○ |
| C-152 | Collection.filterRelationsがpostsリレーションを定義する | E-10 (行75-85) | ○ |
| C-153 | Collection.postsリレーションがPostsを返す | E-10 (行97-106) | ○ |
| C-154 | Collection.collectionPostsリレーションがCollectionPostsを返す | E-10 (行108-112) | ○ |

### CollectionPost Model (UT-CNT-155)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-155 | CollectionPost.tableNameがcollections_postsである | E-11 (行3-5) | ○ |

## 4) 不足情報（Unknown / Missing）

以下の項目は、ソースコードから直接確認できるものの、実際の動作検証が必要な項目です：

1. **メンバー制限チェック（UT-CNT-083〜089）**
   - `limitService.isLimited('members')` と `limitService.errorIfIsOverLimit('members')` の実際の動作
   - 候補: `ghost/core/core/server/services/limits/` / 統合テスト / E2Eテスト

2. **Newsletter検証（UT-CNT-043〜044）**
   - Newsletter.findOneの実際のデータベース検索結果
   - 候補: `ghost/core/core/server/models/newsletter.js` / 統合テスト

3. **countRelationsのSQL実行結果（UT-CNT-090〜094）**
   - サブクエリやCTEを含む複雑なSQLの実行結果
   - 候補: 実際のデータベースでの統合テスト

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 2（高リスク） | 権限チェック（permissible） | セキュリティに直結する機能。実際の権限設定との組み合わせテストが必要 |
| 2（高リスク） | ステータス遷移（onSaving） | ビジネスロジックの中核。不正な遷移が許可されるとデータ整合性が崩れる |
| 1（中リスク） | URL変換（parse/formatOnWrite） | データの可搬性に影響。変換漏れや二重変換のリスク |
| 1（中リスク） | イベント発火（emitChange） | 外部連携に影響。イベントの発火漏れや二重発火のリスク |
| 0（低リスク） | デフォルト値設定 | 影響範囲が限定的。新規作成時のみ影響 |

## 6) レビュアーチェックリスト（最小）

- [ ] 高優先度テストケース（UT-CNT-028〜031、UT-CNT-083〜089）のロジックがソースコードと一致していることを確認
- [ ] permissibleメソッドの権限チェックが実際のロール定義と整合しているか確認
- [ ] ステータス遷移のバリデーションエラーメッセージが適切か確認
- [ ] URL変換ロジックで対象となる全属性が網羅されているか確認
- [ ] countRelationsのSQLが実際のスキーマと整合しているか確認
- [ ] Newsletter検証でactive newsletterのみがチェックされているか確認
- [ ] イベント発火のタイミングと条件が仕様と一致しているか確認
