---
generated_at: 2026-01-29 22:30:00
metrics:
  claims_total: 144
  claims_with_evidence: 142
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：core.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：142 / 144、根拠なし：2
- 優先レビュー（高）
  1. **UT-COR-132 Job.tableName**：非常にシンプルなモデルのため、追加テスト観点の検討が必要
  2. **UT-COR-143 Milestone.tableName**：非常にシンプルなモデルのため、追加テスト観点の検討が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/models/user.js`（1180行）
- E-02: `ghost/core/core/server/models/role.js`（121行）
- E-03: `ghost/core/core/server/models/role-utils.js`（38行）
- E-04: `ghost/core/core/server/models/permission.js`（47行）
- E-05: `ghost/core/core/server/models/settings.js`（449行）
- E-06: `ghost/core/core/server/models/session.js`（88行）
- E-07: `ghost/core/core/server/models/single-use-token.js`（30行）
- E-08: `ghost/core/core/server/models/action.js`（36行）
- E-09: `ghost/core/core/server/models/job.js`（10行）
- E-10: `ghost/core/core/server/models/invite.js`（129行）
- E-11: `ghost/core/core/server/models/milestone.js`（10行）
- E-12: `ghost/core/core/server/models/suppression.js`（10行）

## 3) Claims と根拠の対応（レビューの主戦場）

### User モデル（UT-COR-001〜UT-COR-071）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | User.defaults でデフォルト値が設定される | E-01 L62-76 | ○ |
| C-02 | User.format でwebsiteにhttpプレフィックスが付与される | E-01 L78-86 | ○ |
| C-03 | User.format でprofile_imageがtransformReady形式に変換 | E-01 L89-93 | ○ |
| C-04 | User.format でcover_imageがtransformReady形式に変換 | E-01 L89-93 | ○ |
| C-05 | User.parse でprofile_imageが絶対URLに変換 | E-01 L98-107 | ○ |
| C-06 | User.parse でcover_imageが絶対URLに変換 | E-01 L98-107 | ○ |
| C-07 | User.isActive でactiveステータス判定 | E-01 L167-169, L14 | ○ |
| C-08 | User.isActive でwarn-1〜warn-4もtrue | E-01 L14 activeStates定義 | ○ |
| C-09 | User.isActive でinactive時false | E-01 L167-169 | ○ |
| C-10 | User.isLocked でlocked判定 | E-01 L171-173 | ○ |
| C-11 | User.isInactive でinactive判定 | E-01 L175-177 | ○ |
| C-12 | User.onSaving でname必須チェック | E-01 L197-204 | ○ |
| C-13 | User.onSaving でemailはGravatarルックアップ | E-01 L207-218 | ○ |
| C-14 | User.onSaving でslug自動生成 | E-01 L221-235 | ○ |
| C-15 | User.onSaving でパスワードハッシュ化 | E-01 L278-283 | ○ |
| C-16 | User.onSaving でパスワード弱い場合エラー | E-01 L268-275 | ○ |
| C-17 | User.onSaving でインポート時ランダムパスワード | E-01 L259-266 | ○ |
| C-18 | User.toJSON でpassword除外 | E-01 L289-296 | ○ |
| C-19 | User.sessions リレーション | E-01 L298-300 | ○ |
| C-20 | User.roles リレーション | E-01 L302-304 | ○ |
| C-21 | User.permissions リレーション | E-01 L306-308 | ○ |
| C-22 | User.apiKeys リレーション | E-01 L310-312 | ○ |
| C-23 | User.hasRole でロール確認 | E-01 L314-320 | ○ |
| C-24 | User.updateLastSeen で最終アクセス更新 | E-01 L322-325 | ○ |
| C-25 | User.hasLoggedIn でログイン有無確認 | E-01 L327-329 | ○ |
| C-26 | User.findOne でrole指定検索 | E-01 L471-488 | ○ |
| C-27 | User.getEmailAlertUsers で通知対象取得 | E-01 L497-523 | ○ |
| C-28 | User.edit でroles複数時エラー | E-01 L539-545 | ○ |
| C-29 | User.edit でemail重複チェック | E-01 L547-556 | ○ |
| C-30 | User.edit でOwnerロール割当禁止 | E-01 L598-602 | ○ |
| C-31 | User.add でデフォルトAuthorロール | E-01 L648-674 | ○ |
| C-32 | User.setup でパスワードバリデーション | E-01 L733-739 | ○ |
| C-33 | User.isSetup でオーナーステータス確認 | E-01 L753-757 | ○ |
| C-34 | User.getOwnerUser でオーナー取得 | E-01 L760-775 | ○ |
| C-35 | User.getOwnerId でキャッシュ利用 | E-01 L777-800 | ○ |
| C-36 | User.permissible で自己編集許可 | E-01 L863-874 | ○ |
| C-37 | User.permissible でOwner削除禁止 | E-01 L876-883 | ○ |
| C-38 | User.permissible で自己ステータス変更禁止 | E-01 L891-898 | ○ |
| C-39 | User.permissible で自己ロール変更禁止 | E-01 L908-912 | ○ |
| C-40 | User.permissible でOwnerロール変更禁止 | E-01 L935-939 | ○ |
| C-41 | User.check でログイン認証 | E-01 L979-1017 | ○ |
| C-42 | User.isPasswordCorrect でパスワード検証 | E-01 L1020-1043 | ○ |
| C-43 | User.changePassword でパスワード変更 | E-01 L1050-1080 | ○ |
| C-44 | User.transferOwnership でオーナー移譲 | E-01 L1082-1146 | ○ |
| C-45 | User.getByEmail で大文字小文字無視検索 | E-01 L1151-1169 | ○ |

### Role モデル（UT-COR-072〜UT-COR-081）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | Role.users リレーション | E-02 L25-27 | ○ |
| C-47 | Role.permissions リレーション | E-02 L29-31 | ○ |
| C-48 | Role.api_keys リレーション | E-02 L33-35 | ○ |
| C-49 | Role.permissible でOwnerの割当権限 | E-02 L81-94 | ○ |
| C-50 | Role.permissible でAdminの割当権限 | E-02 L86-88 | ○ |
| C-51 | Role.permissible でEditorの割当権限 | E-02 L88-90 | ○ |
| C-52 | Role.permissible でapiKeyはOwner割当禁止 | E-02 L96-103 | ○ |
| C-53 | Role.permissible で存在しないロールエラー | E-02 L66-70 | ○ |

### role-utils（UT-COR-082〜UT-COR-088）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | setIsRoles でOwnerフラグ設定 | E-03 L27 | ○ |
| C-55 | setIsRoles でAdminフラグ設定 | E-03 L28 | ○ |
| C-56 | setIsRoles でEditorフラグ設定 | E-03 L29, L33 | ○ |
| C-57 | setIsRoles でSuperEditorフラグ設定 | E-03 L32, L33 | ○ |
| C-58 | setIsRoles でrolesがundefined時全false | E-03 L24-26 | ○ |
| C-59 | checkUserPermissionsForRole でロール確認 | E-03 L5-11 | ○ |

### Permission モデル（UT-COR-089〜UT-COR-091）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | Permission.roles リレーション | E-04 L30-32 | ○ |
| C-61 | Permission.users リレーション | E-04 L34-36 | ○ |
| C-62 | Permission.permittedAttributes にrelationships含む | E-04 L20-28 | ○ |

### Settings モデル（UT-COR-092〜UT-COR-114）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | Settings.format でboolean型変換 | E-05 L142-163 | ○ |
| C-64 | Settings.parse でboolean型変換 | E-05 L173-193 | ○ |
| C-65 | Settings.parse で画像URL変換 | E-05 L188-189 | ○ |
| C-66 | Settings.formatOnWrite で画像URL変換 | E-05 L165-171 | ○ |
| C-67 | Settings.findOne で文字列キー検索 | E-05 L195-206 | ○ |
| C-68 | Settings.edit でkey空エラー | E-05 L221-223 | ○ |
| C-69 | Settings.edit で存在しないキーエラー | E-05 L256 | ○ |
| C-70 | Settings.edit でオブジェクトJSON変換 | E-05 L226-228 | ○ |
| C-71 | Settings.populateDefaults でデフォルト挿入 | E-05 L262-315 | ○ |
| C-72 | Settings.validators.all でバリデーション | E-05 L318-337 | ○ |
| C-73 | Settings.validators.labs で許可フラグチェック | E-05 L338-348 | ○ |
| C-74 | Settings.validators.stripe_plans で金額チェック | E-05 L349-383 | ○ |
| C-75 | Settings.validators.stripe_secret_key で形式チェック | E-05 L386-399 | ○ |
| C-76 | Settings.validators.stripe_publishable_key で形式チェック | E-05 L400-413 | ○ |

### Session モデル（UT-COR-115〜UT-COR-123）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | Session.parse でJSONパース | E-06 L6-9 | ○ |
| C-78 | Session.format でJSON文字列化 | E-06 L11-19 | ○ |
| C-79 | Session.user リレーション | E-06 L21-23 | ○ |
| C-80 | Session.destroy でid削除 | E-06 L37-49 | ○ |
| C-81 | Session.destroyAll で全削除 | E-06 L51-55 | ○ |
| C-82 | Session.upsert でセッション更新/作成 | E-06 L57-77 | ○ |

### SingleUseToken モデル（UT-COR-124〜UT-COR-127）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | SingleUseToken.defaults でuuid生成 | E-07 L11 | ○ |
| C-84 | SingleUseToken.defaults でtoken生成 | E-07 L12-18 | ○ |
| C-85 | SingleUseToken.defaults でused_count初期化 | E-07 L9 | ○ |
| C-86 | SingleUseToken.defaults でotc_used_count初期化 | E-07 L10 | ○ |

### Action モデル（UT-COR-128〜UT-COR-131）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | Action.candidates でモデルマッピング取得 | E-08 L6-11 | ○ |
| C-88 | Action.actor でmorphTo関係 | E-08 L13-15 | ○ |
| C-89 | Action.resource でmorphTo関係 | E-08 L17-19 | ○ |
| C-90 | Action.orderDefaultOptions でcreated_at DESC | E-08 L21-25 | ○ |

### Job モデル（UT-COR-132）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | Job.tableName がjobs | E-09 L4 | ○ |

### Invite モデル（UT-COR-133〜UT-COR-142）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92 | Invite.toJSON でtoken除外 | E-10 L28-33 | ○ |
| C-93 | Invite.add でstatus=pending設定 | E-10 L43-45 | ○ |
| C-94 | Invite.add でexpires設定（1週間後） | E-10 L47 | ○ |
| C-95 | Invite.add でtoken生成 | E-10 L48-52 | ○ |
| C-96 | Invite.permissible でadd以外の権限チェック | E-10 L60-68 | ○ |
| C-97 | Invite.permissible で存在しないrole_idエラー | E-10 L74-78 | ○ |
| C-98 | Invite.permissible でOwner招待禁止 | E-10 L80-84 | ○ |
| C-99 | Invite.permissible でOwner/Adminの招待権限 | E-10 L93-96 | ○ |
| C-100 | Invite.permissible でEditorの招待権限 | E-10 L97-99 | ○ |

### Milestone モデル（UT-COR-143）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | Milestone.tableName がmilestones | E-11 L4 | △ |

### Suppression モデル（UT-COR-144）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | Suppression.tableName がsuppressions | E-12 L4 | △ |

## 4) 不足情報（Unknown / Missing）
- **C-101, C-102**: Milestone, Suppression モデルは非常にシンプルで、テーブル名の確認以外のテスト観点が限定的
  - 候補：スキーマ定義 / 使用箇所のサービスコード / マイグレーションファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほとんどのテストケースはソースコードから直接導出可能
- 1: 中リスク - Job, Milestone, Suppressionモデルは最小限のテストケースのみ（モデル自体がシンプルなため）

## 6) レビュアーチェックリスト（最小）
- [ ] User.permissible のテストケースが全権限パターンを網羅しているか確認
- [ ] Settings.validators のStripe関連バリデーションが最新のStripe API要件に適合しているか確認
- [ ] Session.upsert のトランザクション処理が適切にテストされるか確認
- [ ] Invite.permissible のスタッフ数制限（limitService）が考慮されているか確認
- [ ] Job, Milestone, Suppression に追加のテスト観点がないか、使用箇所を調査
