---
generated_at: 2026-01-29 22:35:00
metrics:
  claims_total: 71
  claims_with_evidence: 71
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：email.csv

## 本レポートについて

### 目的
本レポートは、生成されたemailモジュールの単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：71 / 71、根拠なし：0
- 優先レビュー（高）
  1. なし - 全テストケースがソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/models/email.js`
- E-02: `ghost/core/core/server/models/email-batch.js`
- E-03: `ghost/core/core/server/models/email-recipient.js`
- E-04: `ghost/core/core/server/models/email-recipient-failure.js`
- E-05: `ghost/core/core/server/models/email-spam-complaint-event.js`
- E-06: `ghost/core/core/server/models/newsletter.js`
- E-07: `ghost/core/core/server/models/automated-email.js`
- E-08: `ghost/core/core/server/models/automated-email-recipient.js`
- E-09: `ghost/core/core/server/models/outbox.js`
- E-10: `ghost/core/core/server/models/mention.js`
- E-11: `ghost/core/core/server/models/base/` (ghostBookshelf基底クラス)

## 3) Claims と根拠の対応（レビューの主戦場）

### Emailモデル (E-01)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルト値が正しく設定されること | E-01 L7-20 | ○ |
| C-02 | recipient_filter=freeがstatus:freeに変換 | E-01 L26-28 | ○ |
| C-03 | recipient_filter=paidがstatus:-freeに変換 | E-01 L29-31 | ○ |
| C-04 | その他のrecipient_filterはそのまま返却 | E-01 L22-34 | ○ |
| C-05 | formatOnWriteでfree変換 | E-01 L38-40 | ○ |
| C-06 | formatOnWriteでpaid変換 | E-01 L41-43 | ○ |
| C-07 | postリレーション | E-01 L48-50 | ○ |
| C-08 | emailBatchesリレーション | E-01 L52-54 | ○ |
| C-09 | recipientsリレーション | E-01 L56-58 | ○ |
| C-10 | newsletterリレーション | E-01 L60-62 | ○ |
| C-11 | emitChangeメソッド | E-01 L64-67 | ○ |
| C-12 | onCreatedイベント | E-01 L69-73 | ○ |
| C-13 | onUpdatedイベント | E-01 L75-79 | ○ |
| C-14 | onDestroyedイベント | E-01 L81-85 | ○ |

### EmailBatchモデル (E-02)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | デフォルト値設定 | E-02 L6-11 | ○ |
| C-16 | emailリレーション | E-02 L13-15 | ○ |
| C-17 | recipientsリレーション | E-02 L16-18 | ○ |
| C-18 | membersリレーション | E-02 L19-21 | ○ |
| C-19 | countRelations.recipients | E-02 L23-34 | ○ |
| C-20 | 受信者0件カウント | E-02 L23-34 | ○ |

### EmailRecipientモデル (E-03)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | filterRelations定義 | E-03 L7-19 | ○ |
| C-22 | emailリレーション | E-03 L21-23 | ○ |
| C-23 | emailBatchリレーション | E-03 L24-26 | ○ |
| C-24 | memberリレーション | E-03 L27-29 | ○ |
| C-25 | hasTimestamps=false | E-03 L5 | ○ |

### EmailRecipientFailureモデル (E-04)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | defaults空オブジェクト | E-04 L7-10 | ○ |
| C-27 | emailリレーション | E-04 L12-14 | ○ |
| C-28 | memberリレーション | E-04 L16-18 | ○ |
| C-29 | emailRecipientリレーション | E-04 L20-22 | ○ |
| C-30 | hasTimestamps=false | E-04 L5 | ○ |

### EmailSpamComplaintEventモデル (E-05)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | filterRelations定義 | E-05 L7-19 | ○ |
| C-32 | emailリレーション | E-05 L21-23 | ○ |
| C-33 | memberリレーション | E-05 L25-27 | ○ |
| C-34 | editでエラースロー | E-05 L29-33 | ○ |
| C-35 | destroyでエラースロー | E-05 L35-39 | ○ |

### Newsletterモデル (E-06)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | デフォルト値設定 | E-06 L9-41 | ○ |
| C-37 | membersリレーション | E-06 L43-50 | ○ |
| C-38 | postsリレーション | E-06 L52-54 | ○ |
| C-39 | enforcedFiltersパブリック | E-06 L57-59 | ○ |
| C-40 | enforcedFiltersプライベート | E-06 L57-59 | ○ |
| C-41 | onSaving nameトリム | E-06 L64-67 | ○ |
| C-42 | onSaving slug生成 | E-06 L68-78 | ○ |
| C-43 | onSaving slug更新 | E-06 L68-78 | ○ |
| C-44 | subscribeMembersById | E-06 L81-98 | ○ |
| C-45 | subscribeMembersById空配列 | E-06 L81-98 | ○ |
| C-46 | formatOnWrite header_image | E-06 L100-108 | ○ |
| C-47 | parse header_image | E-06 L110-120 | ○ |
| C-48 | permittedOptions findOne | E-06 L127-142 | ○ |
| C-49 | permittedOptions findAll | E-06 L127-142 | ○ |
| C-50 | countRelations.posts | E-06 L146-153 | ○ |
| C-51 | countRelations.members | E-06 L154-160 | ○ |
| C-52 | countRelations.active_members | E-06 L161-171 | ○ |
| C-53 | orderDefaultRaw | E-06 L175-177 | ○ |
| C-54 | orderDefaultOptions | E-06 L179-185 | ○ |
| C-55 | getDefaultNewsletter | E-06 L187-204 | ○ |
| C-56 | getDefaultNewsletter null | E-06 L187-204 | ○ |
| C-57 | getNextAvailableSortOrder | E-06 L206-224 | ○ |
| C-58 | getNextAvailableSortOrder 0 | E-06 L206-224 | ○ |

### AutomatedEmailモデル (E-07)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | デフォルト値設定 | E-07 L8-12 | ○ |
| C-60 | parse lexical変換 | E-07 L14-23 | ○ |
| C-61 | parse lexical null | E-07 L14-23 | ○ |
| C-62 | formatOnWrite lexical変換 | E-07 L26-36 | ○ |
| C-63 | formatOnWrite lexical null | E-07 L26-36 | ○ |

### AutomatedEmailRecipientモデル (E-08)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | automatedEmailリレーション | E-08 L7-9 | ○ |
| C-65 | memberリレーション | E-08 L10-12 | ○ |
| C-66 | hasTimestamps=true | E-08 L5 | ○ |

### Outboxモデル (E-09)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | デフォルト値設定 | E-09 L13-18 | ○ |
| C-68 | OUTBOX_STATUSES定数 | E-09 L3-8 | ○ |

### Mentionモデル (E-10)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | デフォルト値設定 | E-10 L5-8 | ○ |
| C-70 | defaultFilters | E-10 L9-11 | ○ |
| C-71 | permittedOptions findPage | E-10 L13-24 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全てのテストケースがソースコード解析に基づいています

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全テストケースがソースコードから直接導出されており、根拠が明確です
- 注意点:
  - Bookshelf.jsの基底クラス（ghostBookshelf）の挙動は本レポートでは直接検証していません
  - 外部依存（urlUtils, lexicalLib等）の詳細な挙動は別途確認が必要な場合があります

## 6) レビュアーチェックリスト（最小）
- [ ] 各モデルのリレーション定義が実際のDBスキーマと一致しているか確認
- [ ] イベントハンドラ（onCreated, onUpdated, onDestroyed）のテストで副作用が適切にモック化されているか確認
- [ ] EmailSpamComplaintEventのイミュータブル制約が要件と一致しているか確認
- [ ] Newsletter.subscribeMembersByIdのトランザクション処理がテストで考慮されているか確認
- [ ] URL変換処理（parse, formatOnWrite）で使用されるurlUtilsのモック方法を確認
- [ ] countRelationsのクエリが実際のDB構造と整合しているか確認
