---
generated_at: 2026-01-29 22:35:00
metrics:
  claims_total: 83
  claims_with_evidence: 83
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：integrations モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：83 / 83、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/models/integration.js` - Integrationモデル定義
- E-02: `ghost/core/core/server/models/api-key.js` - ApiKeyモデル定義
- E-03: `ghost/core/core/server/models/webhook.js` - Webhookモデル定義
- E-04: `ghost/core/core/server/models/redirect.js` - Redirectモデル定義
- E-05: `ghost/core/core/server/services/integrations/integrations-service.js` - IntegrationsServiceクラス
- E-06: `ghost/core/core/server/services/webhooks/webhooks-service.js` - WebhooksServiceクラス
- E-07: `ghost/core/core/server/services/webhooks/webhook-trigger.js` - WebhookTriggerクラス
- E-08: `ghost/core/core/server/services/webhooks/payload.js` - Webhookペイロード生成
- E-09: `ghost/core/core/server/services/webhooks/serialize.js` - Webhook用シリアライズ
- E-10: `ghost/core/core/server/api/endpoints/integrations.js` - Integrations API エンドポイント
- E-11: `ghost/core/core/server/api/endpoints/webhooks.js` - Webhooks API エンドポイント
- E-12: `ghost/core/core/server/data/schema/schema.js` - データベーススキーマ定義

## 3) Claims と根拠の対応（レビューの主戦場）

### Integration モデル (UT-INT-001 〜 UT-INT-021)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | defaults()でtype='custom'が設定される | E-01 (L27-31) | ○ |
| C-02 | onSavingでslugが自動生成される | E-01 (L38-48) | ○ |
| C-03 | slug重複時に連番が付与される | E-01 (L43-44: generateSlug呼び出し) | ○ |
| C-04 | 空のnameでのslug生成 | E-01 (L43) | ○ |
| C-05 | onCreatedでイベント発行 | E-01 (L51-55) | ○ |
| C-06 | emitChangeでイベント名フォーマット | E-01 (L33-36) | ○ |
| C-07 | api_keysリレーション (hasMany) | E-01 (L61-63) | ○ |
| C-08 | api_keys空コレクション | E-01 (L61-63) | ○ |
| C-09 | webhooksリレーション (hasMany) | E-01 (L65-67) | ○ |
| C-10 | webhooks空コレクション | E-01 (L65-67) | ○ |
| C-11 | permittedAttributesにrelationships含む | E-01 (L57-59) | ○ |
| C-12 | permittedOptionsでfindOneにfilter追加 | E-01 (L69-77) | ○ |
| C-13 | defaultRelationsでedit時api_keys追加 | E-01 (L79-85) | ○ |
| C-14 | defaultRelationsでadd時api_keys追加 | E-01 (L79-85) | ○ |
| C-15 | defaultRelationsでdestroy時api_keys追加 | E-01 (L79-85) | ○ |
| C-16 | permissible正常系 | E-01 (L87-99) | ○ |
| C-17 | permissibleユーザー権限なしエラー | E-01 (L96-98) | ○ |
| C-18 | permissible APIキー権限なしエラー | E-01 (L96-98) | ○ |
| C-19 | permissible カスタム統合制限エラー | E-01 (L90-94) | ○ |
| C-20 | getInternalFrontendKey正常系 | E-01 (L101-107) | ○ |
| C-21 | getInternalFrontendKey存在しない場合 | E-01 (L101-107) | ○ |

### ApiKey モデル (UT-INT-022 〜 UT-INT-034)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | defaults()でsecret自動生成 | E-02 (L12-18) | ○ |
| C-23 | content typeでsecret生成 | E-02 (L13) | ○ |
| C-24 | roleリレーション (belongsTo) | E-02 (L20-22) | ○ |
| C-25 | integrationリレーション (belongsTo) | E-02 (L24-26) | ○ |
| C-26 | userリレーション (belongsTo) | E-02 (L28-30) | ○ |
| C-27 | format()でrole除外 | E-02 (L32-34) | ○ |
| C-28 | onSavingでadmin typeにAdmin Integrationロール設定 | E-02 (L36-54) | ○ |
| C-29 | onSavingでcontent typeにrole_id=null | E-02 (L50-52) | ○ |
| C-30 | type変更時のみロール設定 | E-02 (L42) | ○ |
| C-31 | onUpdatedでsecret変更時refreshedアクション | E-02 (L55-59) | ○ |
| C-32 | onUpdatedでsecret未変更時アクションなし | E-02 (L56) | ○ |
| C-33 | refreshSecretでadmin secret更新 | E-02 (L61-64) | ○ |
| C-34 | refreshSecretでcontent secret更新 | E-02 (L61-64) | ○ |

### Webhook モデル (UT-INT-035 〜 UT-INT-045)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | defaults()でapi_version, status設定 | E-03 (L12-17) | ○ |
| C-36 | integrationリレーション (belongsTo) | E-03 (L19-21) | ○ |
| C-37 | emitChangeでイベント名フォーマット | E-03 (L23-26) | ○ |
| C-38 | onCreatedでaddedイベント発行 | E-03 (L28-32) | ○ |
| C-39 | onUpdatedでeditedイベント発行 | E-03 (L34-38) | ○ |
| C-40 | onDestroyedでdeletedイベント発行 | E-03 (L40-44) | ○ |
| C-41 | findAllByEventでイベント検索 | E-03 (L46-53) | ○ |
| C-42 | findAllByEventで空結果 | E-03 (L46-53) | ○ |
| C-43 | getByEventAndTargetで複合条件検索 | E-03 (L55-75) | ○ |
| C-44 | getByEventAndTargetでケース非依存 | E-03 (L61-62: toLowerCase()) | ○ |
| C-45 | getByEventAndTargetでNotFound処理 | E-03 (L68-74) | ○ |

### Redirect モデル (UT-INT-046 〜 UT-INT-058)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | postリレーション (belongsTo) | E-04 (L7-9) | ○ |
| C-47 | post_id nullableリレーション | E-04 (L7-9), E-12 (redirects.post_id) | ○ |
| C-48 | formatOnWriteでURL変換 | E-04 (L11-17) | ○ |
| C-49 | formatOnWriteでto未設定時 | E-04 (L12-14) | ○ |
| C-50 | parseでURL変換 | E-04 (L19-27) | ○ |
| C-51 | parseでto未設定時 | E-04 (L22-24) | ○ |
| C-52 | orderDefaultRawでcount.clicks含む場合 | E-04 (L29-34) | ○ |
| C-53 | orderDefaultRawでcount.clicks含まない場合 | E-04 (L33) | ○ |
| C-54 | permittedOptionsでfindAll | E-04 (L36-48) | ○ |
| C-55 | permittedOptionsでedit | E-04 (L36-48) | ○ |
| C-56 | countRelations.clicksでカウント | E-04 (L50-62) | ○ |
| C-57 | countRelations.clicksでupdated_at以降フィルタ | E-04 (L57) | ○ |
| C-58 | countRelations.clicksで0件 | E-04 (L50-62) | ○ |

### IntegrationsService (UT-INT-059 〜 UT-INT-064)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | constructor DI | E-05 (L8-12) | ○ |
| C-60 | edit keyidあり時refreshSecret | E-05 (L14-36) | ○ |
| C-61 | edit ApiKey NotFound | E-05 (L18-24) | ○ |
| C-62 | edit refreshSecret内部エラー | E-05 (L31-35) | ○ |
| C-63 | edit keyidなし時通常編集 | E-05 (L38-50) | ○ |
| C-64 | edit Integration NotFound | E-05 (L40-48) | ○ |

### WebhooksService (UT-INT-065 〜 UT-INT-068)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | constructor DI | E-06 (L13-16) | ○ |
| C-66 | add 新規Webhook作成 | E-06 (L18-49) | ○ |
| C-67 | add 重複チェック | E-06 (L25-29) | ○ |
| C-68 | add 外部キー制約エラー | E-06 (L34-45) | ○ |

### WebhookTrigger (UT-INT-069 〜 UT-INT-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | constructor DI | E-07 (L15-21) | ○ |
| C-70 | getAllでWebhook取得 | E-07 (L23-49) | ○ |
| C-71 | getAll制限時内部Webhookのみ | E-07 (L24-43) | ○ |
| C-72 | updateでトリガー情報更新 | E-07 (L51-62) | ○ |
| C-73 | updateでエラー情報記録 | E-07 (L57) | ○ |
| C-74 | destroyでWebhook削除 | E-07 (L64-71) | ○ |
| C-75 | destroy失敗時ログのみ | E-07 (L68-70) | ○ |
| C-76 | onSuccessでupdate呼び出し | E-07 (L73-79) | ○ |
| C-77 | onErrorで410時destroy | E-07 (L81-96) | ○ |
| C-78 | onErrorで410以外時update | E-07 (L89-92) | ○ |
| C-79 | triggerで全Webhookにリクエスト | E-07 (L98-143) | ○ |
| C-80 | trigger secret時X-Ghost-Signature設定 | E-07 (L122-124) | ○ |
| C-81 | trigger secretなし時ヘッダーなし | E-07 (L122) | ○ |
| C-82 | trigger Content-Versionヘッダー | E-07 (L119) | ○ |
| C-83 | trigger 0件Webhook | E-07 (L106, 108) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースに対応するソースコードが確認できました。

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全テストケースがソースコードに基づいており、根拠が明確です。

### 留意点
1. **セキュリティ関連テスト（高優先度）**
   - UT-INT-016〜019：権限チェックのテストは実装漏れがあると重大な脆弱性につながる
   - UT-INT-022〜023：シークレット生成のランダム性・長さ確認
   - UT-INT-080：HMAC署名の正確性確認

2. **プラン制限関連テスト（高優先度）**
   - UT-INT-019, UT-INT-071：カスタム統合制限の境界条件確認

3. **外部キー制約テスト（中優先度）**
   - UT-INT-068：SQLite/MySQLで異なるエラーコードの処理確認

## 6) レビュアーチェックリスト（最小）
- [ ] Integration.permissibleの権限チェックロジックが正しいか確認
- [ ] ApiKey.defaults()でのシークレット生成がセキュアか確認
- [ ] WebhookTrigger.trigger()でのHMAC署名が正しく実装されているか確認
- [ ] WebhooksService.add()での外部キー制約エラーハンドリングが全DBで動作するか確認
- [ ] Redirect.countRelations.clicks()のSQLクエリが意図通りか確認
