---
generated_at: 2026-01-29 22:30:00
metrics:
  claims_total: 75
  claims_with_evidence: 75
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：stripe.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：75 / 75、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべてのテストケースにソースコードの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/models/stripe-customer-subscription.js`
- E-02: `ghost/core/core/server/models/stripe-price.js`
- E-03: `ghost/core/core/server/models/stripe-product.js`
- E-04: `ghost/core/core/server/models/subscription-created-event.js`
- E-05: `ghost/core/core/server/models/offer.js`
- E-06: `ghost/core/core/server/models/offer-redemption.js`
- E-07: `ghost/core/core/server/models/product.js`
- E-08: `ghost/core/core/server/models/benefit.js`
- E-09: `ghost/core/core/server/models/donation-payment-event.js`
- E-10: `ghost/core/core/server/models/base/index.js`（Bookshelf基底モデル）

## 3) Claims と根拠の対応（レビューの主戦場）

### StripeCustomerSubscription（E-01）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | customer()リレーションがbelongsTo('MemberStripeCustomer')で定義 | E-01 L11-13 | ○ |
| C-02 | stripePrice()リレーションがhasOne('StripePrice')で定義 | E-01 L15-17 | ○ |
| C-03 | serialize()がsubscription_idをidとして返却 | E-01 L22 | ○ |
| C-04 | serialize()がcustomerオブジェクトを構築 | E-01 L24-29 | ○ |
| C-05 | serialize()がplanオブジェクトを構築 | E-01 L30-36 | ○ |
| C-06 | serialize()でplan_currencyが大文字変換される | E-01 L35 | ○ |
| C-07 | serialize()でstripePriceが存在する場合priceオブジェクトが追加 | E-01 L49-68 | ○ |
| C-08 | serialize()でstripeProductが存在する場合productが追加 | E-01 L60-67 | ○ |
| C-09 | defaults.mrrが0 | E-01 L7-9 | ○ |
| C-10 | upsert()で既存レコードがあればedit、なければadd | E-01 L74-83 | ○ |

### StripePrice（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | stripeProduct()リレーションがbelongsTo('StripeProduct')で定義 | E-02 L6-8 | ○ |
| C-12 | tableName='stripe_prices' | E-02 L4 | ○ |

### StripeProduct（E-03）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | product()リレーションがbelongsTo('Product')で定義 | E-03 L6-8 | ○ |
| C-14 | stripePrices()リレーションがhasMany('StripePrice')で定義 | E-03 L10-12 | ○ |
| C-15 | upsert()で既存レコードがあればedit、なければadd | E-03 L15-24 | ○ |
| C-16 | add()でトランザクションがない場合自動開始 | E-03 L26-33 | ○ |
| C-17 | edit()でトランザクションがない場合自動開始 | E-03 L35-42 | ○ |
| C-18 | destroy()でトランザクションがない場合自動開始 | E-03 L44-51 | ○ |

### SubscriptionCreatedEvent（E-04）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | member()リレーションがbelongsTo('Member')で定義 | E-04 L7-9 | ○ |
| C-20 | memberCreatedEvent()リレーションがbelongsTo('MemberCreatedEvent')で定義 | E-04 L14-16 | ○ |
| C-21 | subscription()リレーションがbelongsTo('StripeCustomerSubscription')で定義 | E-04 L18-20 | ○ |
| C-22 | postAttribution()リレーションがbelongsTo('Post')で定義 | E-04 L22-24 | ○ |
| C-23 | userAttribution()リレーションがbelongsTo('User')で定義 | E-04 L26-28 | ○ |
| C-24 | tagAttribution()リレーションがbelongsTo('Tag')で定義 | E-04 L30-32 | ○ |
| C-25 | edit()でIncorrectUsageErrorがスローされる | E-04 L34-36 | ○ |
| C-26 | destroy()でIncorrectUsageErrorがスローされる | E-04 L38-40 | ○ |

### Offer（E-05）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | product()リレーションがbelongsTo('Product')で定義 | E-05 L13-15 | ○ |
| C-28 | defaults.redemption_type='signup' | E-05 L9-11 | ○ |
| C-29 | actionsCollectCRUD=true | E-05 L6 | ○ |
| C-30 | actionsResourceType='offer' | E-05 L7 | ○ |

### OfferRedemption（E-06）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | tableName='offer_redemptions' | E-06 L4 | ○ |

### Product（E-07）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | defaults.active=true | E-07 L10 | ○ |
| C-33 | defaults.visibility='none' | E-07 L11 | ○ |
| C-34 | defaults.trial_days=0 | E-07 L12 | ○ |
| C-35 | relationships配列に'benefits'が含まれる | E-07 L16 | ○ |
| C-36 | benefits()リレーションがbelongsToMany('Benefit')で定義 | E-07 L107-116 | ○ |
| C-37 | benefits()がsort_orderでソートされる | E-07 L110 | ○ |
| C-38 | monthlyPrice()リレーションがbelongsTo('StripePrice')で定義 | E-07 L118-120 | ○ |
| C-39 | yearlyPrice()リレーションがbelongsTo('StripePrice')で定義 | E-07 L122-124 | ○ |
| C-40 | stripeProducts()リレーションがhasMany('StripeProduct')で定義 | E-07 L126-128 | ○ |
| C-41 | stripePrices()リレーションがbelongsToManyで定義 | E-07 L130-139 | ○ |
| C-42 | members()リレーションがbelongsToMany('Member')で定義 | E-07 L141-143 | ○ |
| C-43 | onSaving()でnameがトリムされる | E-07 L36-38 | ○ |
| C-44 | onSaving()でslugが自動生成される | E-07 L40-50 | ○ |
| C-45 | onSaving()でbenefitsの重複が除外される | E-07 L64-73 | ○ |
| C-46 | onSaving()で既存Benefitが紐付けられる | E-07 L76-87 | ○ |
| C-47 | permittedAttributes()がrelationshipsを含む | E-07 L97-105 | ○ |
| C-48 | applyCustomQuery()でstripe_pricesがJOINされる | E-07 L27-31 | ○ |
| C-49 | orderDefaultRaw()が'monthly_price ASC'を返す | E-07 L145-147 | ○ |
| C-50 | actionsCollectCRUD=true | E-07 L7 | ○ |
| C-51 | actionsResourceType='product' | E-07 L8 | ○ |

### Benefit（E-08）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | onSaving()でnameがトリムされる | E-08 L9-11 | ○ |
| C-53 | onSaving()でslugが自動生成される | E-08 L12-20 | ○ |
| C-54 | orderDefaultOptions()が{name:'ASC', created_at:'DESC'}を返す | E-08 L23-28 | ○ |

### DonationPaymentEvent（E-09）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | member()リレーションがbelongsTo('Member')で定義 | E-09 L7-9 | ○ |
| C-56 | postAttribution()リレーションがbelongsTo('Post')で定義 | E-09 L11-13 | ○ |
| C-57 | userAttribution()リレーションがbelongsTo('User')で定義 | E-09 L15-17 | ○ |
| C-58 | tagAttribution()リレーションがbelongsTo('Tag')で定義 | E-09 L19-21 | ○ |
| C-59 | edit()でIncorrectUsageErrorがスローされる | E-09 L23-25 | ○ |
| C-60 | destroy()でIncorrectUsageErrorがスローされる | E-09 L27-29 | ○ |

## 4) 不足情報（Unknown / Missing）
- **なし**：すべてのテストケースがソースコードから直接抽出された根拠に基づいている

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：すべてのテストケースがソースコードの実装に基づいて生成されている
- 注意点：
  - serialize()メソッドの複雑なネスト構造は手動テストで確認が推奨される
  - トランザクション関連のテストは実際のDB環境での確認が必要
  - イミュータブルイベント（edit/destroy禁止）のテストは例外メッセージの正確性確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] StripeCustomerSubscription.serialize()の出力構造がAPI仕様と一致するか確認
- [ ] StripeProduct.upsert()のトランザクション処理が適切か確認
- [ ] SubscriptionCreatedEvent/DonationPaymentEventのイミュータブル性が要件と一致するか確認
- [ ] Product.onSaving()のbenefits重複排除ロジックが期待通りか確認
- [ ] 各リレーションの外部キー設定が正しいか確認
