---
generated_at: 2026-01-29 20:45:00
metrics:
  claims_total: 68
  claims_with_evidence: 68
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：68 / 68、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全てのテストケースにE2Eテストファイルが根拠として存在

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `e2e/tests/public/member-signup.test.ts` - メンバー登録フローのE2Eテスト
- E-02: `e2e/tests/admin/members/members.test.ts` - メンバー管理のE2Eテスト
- E-03: `e2e/tests/admin/members/impersonation.test.ts` - メンバーなりすましのE2Eテスト
- E-04: `e2e/tests/admin/members/export.test.ts` - メンバーエクスポートのE2Eテスト
- E-05: `e2e/tests/admin/members/filter-actions.test.ts` - メンバーフィルターアクションのE2Eテスト
- E-06: `e2e/tests/admin/members/member-activity-events.test.ts` - メンバー活動イベントのE2Eテスト
- E-07: `e2e/tests/public/member-signup-types.test.ts` - メンバー登録タイプのE2Eテスト
- E-08: `e2e/tests/admin/posts/posts.test.ts` - 投稿一覧のE2Eテスト
- E-09: `e2e/tests/admin/posts/post-settings.test.ts` - 投稿設定のE2Eテスト
- E-10: `e2e/tests/admin/posts/post-preview.test.ts` - 投稿プレビューのE2Eテスト
- E-11: `e2e/tests/admin/posts/custom-views.test.ts` - カスタムビューのE2Eテスト
- E-12: `e2e/tests/admin/tags/editor.test.ts` - タグエディタのE2Eテスト
- E-13: `e2e/tests/admin/tags/list.test.ts` - タグ一覧のE2Eテスト
- E-14: `e2e/tests/public/comments-permissions.test.ts` - コメント権限のE2Eテスト
- E-15: `e2e/tests/public/comments.test.ts` - コメントソート・ページネーションのE2Eテスト
- E-16: `e2e/tests/public/comment-replies.test.ts` - コメント返信のE2Eテスト
- E-17: `e2e/tests/public/comments-manage.test.ts` - コメント管理のE2Eテスト
- E-18: `e2e/tests/admin/comments/comment-moderation.test.ts` - コメントモデレーションのE2Eテスト
- E-19: `e2e/tests/admin/comments/disable-commenting.test.ts` - コメント無効化のE2Eテスト
- E-20: `e2e/tests/admin/sidebar/navigation.test.ts` - サイドバーナビゲーションのE2Eテスト
- E-21: `e2e/tests/admin/two-factor-auth.test.ts` - 2要素認証のE2Eテスト
- E-22: `e2e/tests/admin/reset-password.test.ts` - パスワードリセットのE2Eテスト
- E-23: `e2e/tests/admin/settings/integrations.test.ts` - インテグレーションのE2Eテスト
- E-24: `e2e/tests/admin/settings/settings-search.test.ts` - 設定検索のE2Eテスト
- E-25: `e2e/tests/admin/settings/publication-language.test.ts` - 言語設定のE2Eテスト
- E-26: `e2e/tests/admin/settings/member-welcome-emails.test.ts` - ウェルカムメールのE2Eテスト
- E-27: `e2e/tests/admin/analytics/overview.test.ts` - アナリティクス概要のE2Eテスト
- E-28: `e2e/tests/admin/analytics/web-traffic.test.ts` - ウェブトラフィックのE2Eテスト
- E-29: `e2e/tests/admin/analytics/growth.test.ts` - 成長分析のE2Eテスト
- E-30: `e2e/tests/admin/analytics/newsletters.test.ts` - ニュースレター分析のE2Eテスト
- E-31: `e2e/tests/public/portal-loading.test.ts` - Portal読み込みのE2Eテスト
- E-32: `e2e/tests/public/homepage.test.ts` - ホームページのE2Eテスト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Portalからのメンバー登録とマジックリンク認証 | E-01 | ○ |
| C-02 | ウェルカムメールの受信確認 | E-01 | ○ |
| C-03 | 新規メンバーの作成 | E-02 | ○ |
| C-04 | 不正なメールアドレスでのメンバー作成拒否 | E-02 | ○ |
| C-05 | 既存メンバーの編集 | E-02 | ○ |
| C-06 | メンバーの削除 | E-02 | ○ |
| C-07 | メンバーのなりすまし（Impersonation） | E-03 | ○ |
| C-08 | 全メンバーのCSVエクスポート | E-04 | ○ |
| C-09 | フィルタリングしたメンバーのCSVエクスポート | E-04 | ○ |
| C-10 | フィルタリングしたメンバーへのラベル一括追加 | E-05 | ○ |
| C-11 | 投稿ページからの直接登録とソース追跡 | E-07 | ○ |
| C-12 | リファラー経由での登録とソース追跡 | E-07 | ○ |
| C-13 | UTMソース経由での登録とソース追跡 | E-07 | ○ |
| C-14 | 投稿一覧の表示 | E-08 | ○ |
| C-15 | 投稿設定の日付形式確認 | E-09 | ○ |
| C-16 | プレビューモーダルのESCキーでの閉じ | E-10 | ○ |
| C-17 | プレビューモーダルの閉じるボタンでの閉じ | E-10 | ○ |
| C-18 | フィルター保存によるカスタムビュー作成 | E-11 | ○ |
| C-19 | 重複名でのカスタムビュー作成拒否 | E-11 | ○ |
| C-20 | カスタムビューの編集 | E-11 | ○ |
| C-21 | カスタムビューの削除 | E-11 | ○ |
| C-22 | 新規タグの追加 | E-12 | ○ |
| C-23 | 既存タグの編集 | E-12 | ○ |
| C-24 | 投稿のないタグの削除 | E-12 | ○ |
| C-25 | 投稿があるタグの削除 | E-12 | ○ |
| C-26 | 公開タグと内部タグの分離表示 | E-13 | ○ |
| C-27 | タグのスクロールページネーション | E-13 | ○ |
| C-28 | 匿名ユーザーのコメント投稿不可 | E-14 | ○ |
| C-29 | 無料メンバーのコメント投稿（全員許可時） | E-14 | ○ |
| C-30 | 有料メンバーのコメント投稿 | E-14 | ○ |
| C-31 | 無料メンバーのコメント投稿不可（有料のみ許可時） | E-14 | ○ |
| C-32 | コメント機能無効時の非表示 | E-14 | ○ |
| C-33 | コメントのソートと追加読み込み | E-15 | ○ |
| C-34 | コメントへの返信 | E-16 | ○ |
| C-35 | 返信への返信 | E-16 | ○ |
| C-36 | 返信の追加読み込み | E-16 | ○ |
| C-37 | 自分のコメントの編集 | E-17 | ○ |
| C-38 | 自分のコメントの削除 | E-17 | ○ |
| C-39 | 他人のコメントの編集・削除不可 | E-17 | ○ |
| C-40 | コメントから投稿への遷移 | E-18 | ○ |
| C-41 | コメントへのディープリンク | E-18 | ○ |
| C-42 | メンバーのコメント機能無効化 | E-19 | ○ |
| C-43 | メインナビゲーション項目のクリック | E-20 | ○ |
| C-44 | 投稿サブメニューの展開 | E-20 | ○ |
| C-45 | ユーザードロップダウンメニュー | E-20 | ○ |
| C-46 | Night shiftモードの切り替え | E-20 | ○ |
| C-47 | ネットワーク通知バッジの表示 | E-20 | ○ |
| C-48 | 2要素認証でのログイン | E-21 | ○ |
| C-49 | 2要素認証コードの再送信 | E-21 | ○ |
| C-50 | パスワードリセットフロー | E-22 | ○ |
| C-51 | 2FA有効時のパスワードリセット | E-22 | ○ |
| C-52 | Unsplashインテグレーションの有効化 | E-23 | ○ |
| C-53 | Unsplashインテグレーションの無効化 | E-23 | ○ |
| C-54 | Pinturaインテグレーションの有効化/無効化 | E-23 | ○ |
| C-55 | 設定検索機能 | E-24 | ○ |
| C-56 | サイト言語の変更とニュースレター翻訳 | E-25 | ○ |
| C-57 | 無料メンバー向けウェルカムメールの有効化 | E-26 | ○ |
| C-58 | ウェルカムメールの件名編集 | E-26 | ○ |
| C-59 | 訪問者の記録 | E-27 | ○ |
| C-60 | 最新投稿の統計表示 | E-27 | ○ |
| C-61 | トップ投稿の統計表示 | E-27 | ○ |
| C-62 | ウェブトラフィック概要の表示 | E-28 | ○ |
| C-63 | 成長分析のコンテンツ切り替え | E-29 | ○ |
| C-64 | ニュースレター購読者の変化率表示 | E-30 | ○ |
| C-65 | Subscribeボタンからのポータル表示 | E-31 | ○ |
| C-66 | Sign inリンクからのポータル表示 | E-31 | ○ |
| C-67 | サインアップとサインインモードの切り替え | E-31 | ○ |
| C-68 | ホームページの正常表示 | E-32 | ○ |

## 4) 不足情報（Unknown / Missing）
- **該当なし**：全てのテストケースはE2Eテストファイルに基づいて生成されています。

補足事項：
- 本受入テストケース一覧は、`e2e/tests/`ディレクトリ内のE2Eテストファイルを解析して生成しました
- 各テストケースの根拠となるテストファイルは「備考」列に記載しています
- 実際のテスト実行時のデータや環境設定の詳細は、各テストファイル内のセットアップ処理を参照してください

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースにE2Eテストコードが存在し、テスト手順と期待結果が明確に定義されています
- **注意点**：
  - 一部のテストはラボ機能（labs flag）が有効な場合のみ動作します（例：welcomeEmails、commentModeration）
  - Stripe連携が必要なテスト（有料メンバー関連）は適切な環境設定が必要です
  - 2FA関連テストはメール送信機能（Mailpit）が必要です

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースIDの連番に欠落がないか確認
- [ ] 各シナリオの前提条件が現実的に準備可能か確認
- [ ] テスト手順の粒度が適切か確認（詳細すぎず、抽象的すぎず）
- [ ] 期待結果が検証可能な形で記述されているか確認
- [ ] 優先度の設定が妥当か確認（高：認証・コア機能、中：一般機能、低：UI詳細）
- [ ] ラボ機能が必要なテストケースが明記されているか確認
- [ ] ユーザーロール別のテストケースが網羅されているか確認（管理者、メンバー、匿名ユーザー）
