---
generated_at: 2026-01-29 16:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認できました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/api/endpoints/members.js` - exportCSV エンドポイント定義（370-400行目）
- E-02: `ghost/core/core/server/api/endpoints/utils/serializers/output/members.js` - CSV出力処理とヘッダー定義（30-42行目、CSV_HEADERS配列）
- E-03: `ghost/core/core/server/services/members/exporter/query.js` - 会員エクスポートのストリーム処理
- E-04: `ghost/core/core/server/api/endpoints/posts.js` - exportCSV エンドポイント定義（84-112行目）
- E-05: `ghost/core/core/server/services/posts/posts-exporter.js` - 投稿エクスポートのデータ構造定義（82-104行目）
- E-06: `ghost/core/core/server/api/endpoints/db.js` - exportContent エンドポイント定義（39-77行目）
- E-07: `ghost/core/core/server/data/exporter/exporter.js` - JSON エクスポート処理
- E-08: `ghost/core/core/server/data/exporter/export-filename.js` - エクスポートファイル名生成ロジック
- E-09: `ghost/core/core/server/services/mentions-email-report/mention-email-report-job.js` - メンションレポートジョブ定義
- E-10: `ghost/core/core/server/services/staff/email-templates/mention-report.hbs` - メンションレポートHTMLテンプレート
- E-11: `ghost/core/core/server/services/comments/email-templates/report.hbs` - コメント報告HTMLテンプレート
- E-12: `ghost/core/core/server/services/stats/mrr-stats-service.js` - MRR統計サービス
- E-13: `ghost/core/core/server/services/stats/members-stats-service.js` - 会員数統計サービス
- E-14: `ghost/core/core/server/services/stats/stats-service.js` - 統計サービス集約クラス（各種統計メソッド定義）
- E-15: `ghost/core/core/server/web/api/endpoints/admin/routes.js` - APIルート定義
- E-16: `apps/admin-x-settings/src/components/settings/advanced/migration-tools/migration-tools-export.tsx` - 管理画面エクスポートUI

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 会員一覧CSV：会員データをCSV形式でエクスポート | E-01, E-02, E-03 | ○ |
| C-02 | 会員一覧CSV：ファイル名 members.{YYYY-MM-DD}.csv | E-01（379-381行目） | ○ |
| C-03 | 投稿分析CSV：投稿データをCSV形式でエクスポート | E-04, E-05 | ○ |
| C-04 | 投稿分析CSV：ファイル名 post-analytics.{YYYY-MM-DD}.csv | E-04（94-95行目） | ○ |
| C-05 | コンテンツ&設定JSON：Ghost全体をJSON形式でエクスポート | E-06, E-07 | ○ |
| C-06 | コンテンツ&設定JSON：ファイル名フォーマット | E-08（27行目） | ○ |
| C-07 | メンションレポート：外部言及時にスタッフに通知 | E-09, E-10 | ○ |
| C-08 | メンションレポート：24時間ごとに集計 | E-09（42行目：24 * 60 * 60 * 1000） | ○ |
| C-09 | コメント報告レポート：会員がコメント報告時に通知 | E-11 | ○ |
| C-10 | MRR履歴レポート：通貨別MRR推移を日次集計 | E-12（getHistory, getCurrentMrr メソッド） | ○ |
| C-11 | 会員数履歴レポート：会員種別ごとの日次推移 | E-13（getCountHistory, getCount メソッド） | ○ |
| C-12 | 購読履歴レポート：サブスクリプション履歴データ | E-14（getSubscriptionCountHistory メソッド） | ○ |
| C-13 | リファラー履歴レポート：参照元の履歴データ | E-14（getReferrersHistory メソッド） | ○ |
| C-14 | トップ投稿レポート：成果上位投稿の統計 | E-14（getTopPosts メソッド） | ○ |
| C-15 | ニュースレター統計/トップコンテンツ/トップソース | E-14（getNewsletterStats, getTopContent, getTopSourcesWithRange メソッド） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての帳票について、ソースコード内に明確な実装根拠が確認できました。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべての帳票がソースコードで確認済み
- 統計系レポート（C-10〜C-15）はAPIレスポンスとして返却されるため、フロントエンドでの表示形式は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 会員一覧CSVのカラム項目がE-02のCSV_HEADERSと一致しているか確認
- [ ] 投稿分析CSVの項目がE-05のmappedオブジェクトと一致しているか確認
- [ ] 統計系レポートのAPIエンドポイントが実際に存在するか確認
- [ ] メールテンプレートの日本語翻訳対応状況を確認（ghost/i18n参照）
- [ ] エクスポート機能のアクセス権限設定を確認
