# 帳票設計書 3-コンテンツ設定JSON

## 概要

Ghost全体のコンテンツとデータをJSON形式でエクスポートする帳票設計書。Ghost CMSの全データをバックアップまたは移行目的でJSON形式で出力する機能を定義する。

### 本帳票の処理概要

本帳票は、Ghost CMSに登録されている全コンテンツ（投稿、ページ、タグ、ユーザー等）と設定情報をJSON形式でエクスポートする機能を提供する。このエクスポートファイルは、別のGhostインスタンスへのインポートに使用できる標準形式となっている。

**業務上の目的・背景**：サイト管理者がデータのバックアップを取得したり、開発環境から本番環境へのコンテンツ移行、または別のGhostサイトへのデータ移行を行う際に利用される。災害復旧やサイト移設の際にも重要な役割を果たす。

**帳票の利用シーン**：管理画面のSettings > Labsセクションから「Export」ボタンをクリックして利用する。定期的なバックアップ取得、サイト移行前のデータエクスポート、開発環境へのデータコピーなどのシーンで使用される。

**主要な出力内容**：
1. 投稿・ページデータ（posts、posts_authors、posts_meta、posts_tags）
2. タグデータ（tags）
3. ユーザーデータ（users、roles、roles_users）
4. 設定データ（settings、custom_theme_settings）
5. 製品・価格データ（products、stripe_products、stripe_prices）
6. ニュースレターデータ（newsletters）
7. その他（snippets、offers、benefits等）

**帳票の出力タイミング**：管理者がLabs設定画面で「Export」操作を実行した時点でリアルタイムに生成される。バックアップ機能を使用する場合は追加のテーブルも含めることができる。

**帳票の利用者**：サイト管理者、システム管理者、開発者。バックアップ、移行、開発環境構築に活用される。

## 帳票種別

データエクスポート（JSONエクスポート）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Labs設定画面 | /ghost/#/settings/labs | Exportボタン |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | {サイト名}.ghost.{YYYY-MM-DD-HH-mm-ss}.json |
| 出力方法 | ダウンロード |
| 文字コード | UTF-8 |

### JSON固有設定

| 項目 | 内容 |
|-----|------|
| フォーマット | 整形済みJSON |
| ルート構造 | { db: [{ meta: {...}, data: {...} }] } |

## 帳票レイアウト

### レイアウト概要

JSONファイルはGhost固有のスキーマに従った構造を持つ。

```json
{
  "db": [
    {
      "meta": {
        "exported_on": "タイムスタンプ",
        "version": "Ghostバージョン"
      },
      "data": {
        "posts": [...],
        "tags": [...],
        "users": [...],
        ...
      }
    }
  ]
}
```

### 標準エクスポートテーブル（TABLES_ALLOWLIST）

| No | テーブル名 | 説明 |
|----|-----------|------|
| 1 | posts | 投稿・ページデータ |
| 2 | posts_authors | 投稿と著者の関連 |
| 3 | posts_meta | 投稿のメタデータ |
| 4 | posts_tags | 投稿とタグの関連 |
| 5 | roles | ユーザーロール |
| 6 | roles_users | ユーザーとロールの関連 |
| 7 | settings | サイト設定 |
| 8 | custom_theme_settings | カスタムテーマ設定 |
| 9 | tags | タグ |
| 10 | users | ユーザー |
| 11 | products | 製品（Tier） |
| 12 | stripe_products | Stripe製品 |
| 13 | stripe_prices | Stripe価格 |
| 14 | posts_products | 投稿と製品の関連 |
| 15 | newsletters | ニュースレター |
| 16 | benefits | 特典 |
| 17 | products_benefits | 製品と特典の関連 |
| 18 | offers | オファー |
| 19 | offer_redemptions | オファー利用履歴 |
| 20 | snippets | スニペット |

### バックアップ追加テーブル（BACKUP_TABLES）

| No | テーブル名 | 説明 |
|----|-----------|------|
| 1 | actions | アクションログ |
| 2 | api_keys | APIキー |
| 3 | members | 会員 |
| 4 | members_labels | 会員ラベル関連 |
| 5 | members_products | 会員製品関連 |
| 6 | members_stripe_customers | Stripe顧客 |
| 7 | emails | 送信メール |
| 8 | email_batches | メールバッチ |
| 9 | comments | コメント |
| 10 | mentions | メンション |
| 11 | ... | その他多数 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| include | 追加で含めるテーブル（BACKUP_TABLES） | No |
| filename | 既存バックアップファイル名（読み込み用） | No |

### 除外設定（SETTING_KEYS_BLOCKLIST）

以下の設定キーはセキュリティ上エクスポートから除外される：

| キー | 説明 |
|-----|------|
| stripe_connect_publishable_key | Stripe公開キー |
| stripe_connect_secret_key | Stripeシークレットキー |
| stripe_connect_account_id | Stripeアカウント |
| stripe_secret_key | Stripeシークレット |
| stripe_publishable_key | Stripe公開キー |
| members_stripe_webhook_id | Webhook ID |
| members_stripe_webhook_secret | Webhookシークレット |
| email_verification_required | メール確認フラグ |
| indexnow_api_key | IndexNow APIキー |

## データベース参照仕様

### 参照テーブル一覧

標準エクスポートでは TABLES_ALLOWLIST に定義された20テーブル、バックアップエクスポートではさらに BACKUP_TABLES に定義された約60テーブルを参照する。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[エクスポート要求] --> B{filenameパラメータ?}
    B -->|Yes| C[既存バックアップ読み込み]
    B -->|No| D[新規エクスポート生成]
    C --> E[ファイル返却]
    D --> F[テーブルリスト決定]
    F --> G[各テーブルからデータ取得]
    G --> H[除外設定適用]
    H --> I[メタ情報付加]
    I --> J[JSON生成]
    J --> E
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 認証エラー | 認証なしでアクセス | 401 Unauthorized | ログイン必要 |
| 権限エラー | 権限がない | 403 Forbidden | 権限付与必要 |
| ファイル未検出 | 指定バックアップなし | 404 Not Found | 正しいファイル名指定 |
| 内部エラー | エクスポート処理失敗 | 500 Internal Server Error | ログ確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | テーブルによる（数件〜数万件） |
| 目標出力時間 | 数秒〜数十秒 |
| 同時出力数上限 | 特に制限なし |

## セキュリティ考慮事項

- 管理者認証が必要（authAdminApi）
- Stripe関連シークレット情報は自動除外
- パスワードハッシュは含まれるが、平文パスワードは含まれない
- バックアップファイルには個人情報（会員メールアドレス等）が含まれる可能性があるため、取り扱い注意

## 備考

- インポート時は同じJSON形式が使用される
- バージョン互換性：エクスポート時のGhostバージョンがメタ情報に記録される
- 大量データの場合はメモリ使用量に注意

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、エクスポート対象のテーブルリストと除外設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | table-lists.js | `ghost/core/core/server/data/exporter/table-lists.js` | BACKUP_TABLES、TABLES_ALLOWLIST、SETTING_KEYS_BLOCKLIST |

**読解のコツ**: TABLES_ALLOWLISTが標準エクスポート対象、BACKUP_TABLESがincludeオプション指定時の追加対象。

#### Step 2: エントリーポイントを理解する

処理の起点となるAPIエンドポイントを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | db.js | `ghost/core/core/server/api/endpoints/db.js` | exportContentアクション（39-77行目） |
| 2-2 | routes.js | `ghost/core/core/server/web/api/endpoints/admin/routes.js` | /dbルートの定義（237行目） |

**主要処理フロー**:
1. **39-56行目**: オプション定義とヘッダー設定
2. **60-76行目**: filenameパラメータで既存バックアップ読み込みまたは新規エクスポート

#### Step 3: エクスポーターの詳細を理解する

データエクスポートの詳細ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | exporter/index.js | `ghost/core/core/server/data/exporter/` | doExport関数とfileNameヘルパー |

**主要処理フロー**:
- テーブルリストに基づくデータ取得
- 除外設定キーの適用
- メタ情報（version、exported_on）の付加
- JSON形式での出力

### プログラム呼び出し階層図

```
GET /ghost/api/admin/db
    │
    ├─ api/endpoints/db.js#exportContent
    │      │
    │      ├─ [filename指定時]
    │      │      └─ dbBackup.readBackup(filename)
    │      │
    │      └─ [新規エクスポート]
    │             └─ exporter.doExport({include: ...})
    │                    │
    │                    ├─ TABLES_ALLOWLIST からデータ取得
    │                    │
    │                    └─ [include指定時]
    │                           └─ BACKUP_TABLES からも取得
```

### データフロー図

```
[入力]                    [処理]                         [出力]

リクエスト ───▶ エンドポイント ───▶ エクスポーター
(include?)      (db.js)           (exporter/)
                                       │
                                       ▼
                            ┌─────────────────┐
                            │ テーブルリスト   │
                            │ (ALLOWLIST/     │
                            │  BACKUP_TABLES) │
                            └─────────────────┘
                                       │
                                       ▼
                            ┌─────────────────┐
                            │ 除外設定適用    │
                            │ (BLOCKLIST)     │
                            └─────────────────┘
                                       │
                                       ▼
                            ┌─────────────────┐
                            │ JSONファイル    │
                            │ ({site}.ghost.  │
                            │  YYYY-MM-DD...  │
                            │  .json)         │
                            └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| db.js | `ghost/core/core/server/api/endpoints/db.js` | ソース | APIエンドポイント定義 |
| table-lists.js | `ghost/core/core/server/data/exporter/table-lists.js` | ソース | テーブルリスト定義 |
| index.js | `ghost/core/core/server/data/exporter/index.js` | ソース | エクスポートロジック |
| routes.js | `ghost/core/core/server/web/api/endpoints/admin/routes.js` | ソース | ルーティング定義 |
