# 帳票設計書 4-メンションレポート

## 概要

サイトが外部から言及（Webmention）された際に、スタッフに送信されるメール通知レポートの設計書。Ghost CMSのWebmention機能において、外部サイトからの言及を24時間ごとに集計してスタッフにメール通知する機能を定義する。

### 本帳票の処理概要

本帳票は、Ghost CMSサイトが外部サイトから言及（Webmention）された際に、その情報をスタッフユーザーにメール形式で通知するレポートを提供する。定期的なジョブにより24時間以内の新規メンションを集計し、メンション受信通知を有効にしているスタッフに送信される。

**業務上の目的・背景**：サイト運営者が外部サイトからどのように言及されているかを把握し、サイトの露出状況やリンクバックの機会を認識するために利用される。SEO対策やコミュニティ形成の観点から、他サイトからの言及を追跡することは重要な活動となる。

**帳票の利用シーン**：スタッフユーザーが「mention-received」通知を有効にしている場合に自動送信される。1日1回、前回レポート以降の新規メンションが集計されてメールで配信される。Ghost Adminの/mentionsセクションで詳細確認が可能。

**主要な出力内容**：
1. 言及元URL（sourceUrl）
2. 言及元ページタイトル（sourceTitle）
3. 言及内容の抜粋（sourceExcerpt）
4. 言及元サイト名（sourceSiteTitle）
5. 言及元サイトのファビコン（sourceFavicon）
6. 言及元著者（sourceAuthor）
7. アイキャッチ画像（sourceFeaturedImage）

**帳票の出力タイミング**：cronジョブにより毎時実行され、前回レポートから24時間以上経過している場合に送信される。メンションがない場合は送信されない。

**帳票の利用者**：サイト管理者、編集者（mention-received通知を有効にしているスタッフ）

## 帳票種別

メール通知（HTMLメール）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Mentions一覧画面 | /ghost/#/mentions | 自動（cronジョブ） |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTMLメール + テキストメール |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（メール送信） |
| 出力方法 | メール送付 |
| 文字コード | UTF-8 |

### メール固有設定

| 項目 | 内容 |
|-----|------|
| 件名形式 | "{サイト名} mentioned you" / "{サイト名} & X others mentioned you" |
| HTMLテンプレート | mention-report.hbs |
| テキストテンプレート | mention-report.txt.js |
| 送信者 | サイトのデフォルトメールアドレス |

## 帳票レイアウト

### レイアウト概要

HTMLメールは挨拶文、メンション一覧（最大5件）、アクションボタンで構成される。

```
┌─────────────────────────────────────┐
│          ヘッダー（挨拶文）          │
├─────────────────────────────────────┤
│          メンション1                 │
│          メンション2                 │
│          ...（最大5件）             │
├─────────────────────────────────────┤
│          アクションボタン            │
│          （View all mentions）      │
├─────────────────────────────────────┤
│          フッター                   │
└─────────────────────────────────────┘
```

### メンション表示項目

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | sourceUrl | 言及元URL | mention.source | リンク |
| 2 | sourceTitle | ページタイトル | mention.sourceTitle | テキスト |
| 3 | sourceExcerpt | 抜粋 | mention.sourceExcerpt | テキスト |
| 4 | sourceSiteTitle | サイト名 | mention.sourceSiteTitle | テキスト |
| 5 | sourceFavicon | ファビコン | mention.sourceFavicon | 画像（22x22） |
| 6 | sourceFeaturedImage | アイキャッチ | mention.sourceFeaturedImage | 背景画像 |

### メール件名の決定ロジック

| 条件 | 件名形式 |
|-----|---------|
| 1サイトからのメンション | "{サイト名} mentioned you" |
| 2サイトからのメンション | "{サイト名} & 1 other mentioned you" |
| 3サイト以上からのメンション | "{サイト名} & {N-1} others mentioned you" |

## 出力条件

### 送信条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 24時間経過 | 前回レポートから24時間以上経過 | Yes |
| メンション存在 | 期間内に新規メンションあり | Yes |
| 通知設定 | スタッフがmention-received通知有効 | Yes |
| labs設定 | webmentionsラボ機能が有効 | Yes |

### 受信者決定ロジック

- `models.User.getEmailAlertUsers('mention-received')`で取得
- 通知設定がオンのスタッフユーザーのみ

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| mentions | メンションデータ | 主テーブル |
| users | 通知受信者 | getEmailAlertUsers |
| settings | last_mentions_report_email_timestamp | キー指定 |

### テーブル別参照項目詳細

#### mentions

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| source | sourceUrl | 期間内 | URL形式 |
| source_title | sourceTitle | - | - |
| source_excerpt | sourceExcerpt | - | - |
| source_site_title | sourceSiteTitle | - | - |
| source_favicon | sourceFavicon | - | 画像URL |
| source_author | sourceAuthor | - | - |
| source_featured_image | sourceFeaturedImage | - | 画像URL |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[cronジョブ起動] --> B{24時間経過?}
    B -->|No| C[終了]
    B -->|Yes| D[メンションレポート取得]
    D --> E{メンションあり?}
    E -->|No| C
    E -->|Yes| F[受信者リスト取得]
    F --> G[各受信者にメール送信]
    G --> H[送信日時更新]
    H --> C
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| メール送信失敗 | SMTP設定不正 | ログ出力 | SMTP設定確認 |
| DB接続エラー | DB接続不可 | ログ出力 | DB確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数十件/日 |
| 目標出力時間 | 数秒以内 |
| 同時出力数上限 | 受信者数分 |

## セキュリティ考慮事項

- スタッフユーザーのみが受信対象
- 外部URLは信頼できない可能性があるため、クリック時は注意が必要
- メンション内容（抜粋等）はサニタイズ済み

## 備考

- 重複ソースURL（同一ページからの複数メンション）は1件として表示
- 表示は最大5件まで、それ以上ある場合はhasMoreMentionsフラグで表示
- cronジョブはランダムな分・秒で毎時実行（サーバー負荷分散）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、メンションデータの構造と、レポートで使用されるプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mention-email-report-job.js | `ghost/core/core/server/services/mentions-email-report/mention-email-report-job.js` | MentionReportの型定義（81-118行目） |

**読解のコツ**: `sendLatestReport`メソッド（38-78行目）でレポート生成からメール送信までのフローを確認する。

#### Step 2: サービス初期化を理解する

ジョブのセットアップと依存関係の注入を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | service.js | `ghost/core/core/server/services/mentions-email-report/service.js` | 初期化処理と各コンポーネントの設定 |

**主要処理フロー**:
1. **17-21行目**: mentionReportGenerator（メンションデータ取得）
2. **23-34行目**: mentionReportRecipientRepository（受信者取得）
3. **36-94行目**: mentionReportEmailView（メール本文生成）
4. **96-117行目**: mentionReportHistoryService（履歴管理）
5. **155-163行目**: cronジョブスケジュール設定

#### Step 3: メールテンプレートを理解する

HTMLメールのレイアウトと動的コンテンツを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | mention-report.hbs | `ghost/core/core/server/services/staff/email-templates/mention-report.hbs` | HTMLテンプレート構造 |

**主要処理フロー**:
- **6行目**: 件名生成（mentions.length による分岐）
- **27行目**: 導入文（メンション数表示）
- **29-85行目**: メンション一覧（limit 5件）
- **87-101行目**: アクションボタン
- **107-119行目**: フッター

### プログラム呼び出し階層図

```
cronジョブ（毎時）
    │
    ├─ DomainEvents.dispatch(StartMentionEmailReportJob)
    │      │
    │      └─ MentionEmailReportJob.sendLatestReport()
    │             │
    │             ├─ mentionReportHistoryService.getLatestReportDate()
    │             │
    │             ├─ mentionReportGenerator.getMentionReport()
    │             │      └─ mentions.api.getMentionReport()
    │             │
    │             ├─ mentionReportRecipientRepository.getMentionReportRecipients()
    │             │      └─ models.User.getEmailAlertUsers('mention-received')
    │             │
    │             └─ [各受信者に対して]
    │                    ├─ mentionReportEmailView.renderSubject()
    │                    ├─ mentionReportEmailView.renderHTML()
    │                    │      └─ staffService.api.emails.renderHTML('mention-report', {...})
    │                    ├─ mentionReportEmailView.renderText()
    │                    └─ emailService.send()
    │
    └─ mentionReportHistoryService.setLatestReportDate()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

cronトリガー ───▶ 履歴確認 ───▶ メンション取得
                 (24h経過?)      (期間内)
                                     │
                                     ▼
                          ┌─────────────────┐
                          │ 重複URL除去     │
                          │ (最大5件表示)   │
                          └─────────────────┘
                                     │
                                     ▼
                          ┌─────────────────┐
                          │ 受信者リスト取得 │
                          │ (mention-       │
                          │  received)      │
                          └─────────────────┘
                                     │
                                     ▼
                          ┌─────────────────┐
                          │ HTMLメール生成  │
                          │ (mention-       │
                          │  report.hbs)    │
                          └─────────────────┘
                                     │
                                     ▼
                          ┌─────────────────┐
                          │ メール送信      │
                          │ (各受信者へ)    │
                          └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mention-email-report-job.js | `ghost/core/core/server/services/mentions-email-report/mention-email-report-job.js` | ソース | メインジョブロジック |
| service.js | `ghost/core/core/server/services/mentions-email-report/service.js` | ソース | サービス初期化 |
| mention-report.hbs | `ghost/core/core/server/services/staff/email-templates/mention-report.hbs` | テンプレート | HTMLメールテンプレート |
| mention-report.txt.js | `ghost/core/core/server/services/staff/email-templates/mention-report.txt.js` | テンプレート | テキストメールテンプレート |
| job.js | `ghost/core/core/server/services/mentions-email-report/job.js` | ソース | cronジョブエントリ |
