# 帳票設計書 5-コメント報告レポート

## 概要

会員がコメントを報告した際に、スタッフに送信されるメール通知レポートの設計書。Ghost CMSのコメント機能において、不適切なコメントが報告された際にサイトオーナーに通知するメール機能を定義する。

### 本帳票の処理概要

本帳票は、Ghost CMSサイトの投稿に対するコメントが会員によって報告された際に、その情報をサイトオーナーにメール形式で即時通知するレポートを提供する。報告者情報、コメント内容、投稿情報などが含まれ、コメントモデレーション機能と連携する。

**業務上の目的・背景**：コミュニティ運営において不適切なコメント（スパム、誹謗中傷、規約違反等）を迅速に把握し、適切な対応を取るために利用される。ユーザー報告ベースのモデレーションにより、コミュニティの健全性を維持する重要な役割を果たす。

**帳票の利用シーン**：会員がコメントの「Report」機能を使用した時点で自動送信される。サイトオーナーはメール内のリンクからコメントを確認し、必要に応じて削除等の対応を行う。

**主要な出力内容**：
1. 報告者情報（名前、メールアドレス）
2. 報告されたコメント内容（HTML形式）
3. コメント投稿者情報（名前、イニシャル、expertise）
4. コメント投稿日時
5. 投稿タイトルとURL
6. モデレーション/確認用リンク

**帳票の出力タイミング**：会員がコメントを報告した時点で即時送信される。

**帳票の利用者**：サイトオーナー（Owner権限ユーザー）

## 帳票種別

メール通知（HTMLメール）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | 投稿ページ（コメント欄） | /{post-slug}/ | コメントReportボタン |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTMLメール + テキストメール |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（メール送信） |
| 出力方法 | メール送付 |
| 文字コード | UTF-8 |

### メール固有設定

| 項目 | 内容 |
|-----|------|
| 件名 | "A comment has been reported on your post" |
| HTMLテンプレート | report.hbs |
| 送信者 | サイトのメンバーサポートアドレス |
| 受信者 | サイトオーナー |

## 帳票レイアウト

### レイアウト概要

HTMLメールは挨拶文、報告メッセージ、コメント表示、アクションボタンで構成される。

```
┌─────────────────────────────────────┐
│          ヘッダー（挨拶文）          │
├─────────────────────────────────────┤
│          報告メッセージ              │
│          （誰が何を報告したか）       │
├─────────────────────────────────────┤
│          報告されたコメント          │
│          ┌────────────────────┐    │
│          │ [イニシャル] 投稿者名│    │
│          │ expertise・日時    │    │
│          │ コメント本文        │    │
│          └────────────────────┘    │
├─────────────────────────────────────┤
│          アクションボタン            │
│          （Review/View comment）    │
├─────────────────────────────────────┤
│          フッター                   │
└─────────────────────────────────────┘
```

### 表示項目詳細

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | reporterName | 報告者名 | reporter.name | テキスト |
| 2 | reporterEmail | 報告者メール | reporter.email | テキスト |
| 3 | reporter | 報告者表示名 | 組み合わせ | "Name (email)" or "email" |
| 4 | memberName | コメント投稿者名 | member.name | テキスト |
| 5 | memberInitials | イニシャル | extractInitials() | 1-2文字 |
| 6 | memberExpertise | 専門分野 | member.expertise | テキスト |
| 7 | commentDate | コメント日時 | comment.created_at | "D MMM YYYY" |
| 8 | commentHtml | コメント本文 | comment.html | HTML |
| 9 | postTitle | 投稿タイトル | post.title | テキスト |
| 10 | postUrl | 投稿URL | urlService | 絶対URL |

## 出力条件

### 送信条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| コメント報告 | 会員がコメントを報告 | Yes |

### 受信者決定ロジック

- `models.User.getOwnerUser()`でサイトオーナーを取得
- オーナーのメールアドレスに送信

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| comments | コメントデータ | id指定 |
| members | コメント投稿者 | comment.member_id |
| posts | 投稿データ | comment.post_id |
| posts_authors | 著者情報 | post_id |
| users | オーナー情報 | getOwnerUser() |

### テーブル別参照項目詳細

#### comments

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| html | commentHtml | - | サニタイズ済み |
| created_at | commentDate | - | moment形式変換 |
| member_id | - | 投稿者取得用 | - |
| post_id | - | 投稿取得用 | - |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| reporter | reporter.name ? `${name} (${email})` : email | - | 名前がない場合はメールのみ |
| memberInitials | extractInitials(name) | - | 姓名の頭文字 |
| postUrl | getPostUrl(post_id, comment_id) | - | コメントパーマリンク付き |
| moderationUrl | admin/#/comments/?id=is:{comment_id} | - | モデレーション有効時 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[コメント報告] --> B[notifyReport呼び出し]
    B --> C[投稿・メンバー・オーナー取得]
    C --> D[テンプレートデータ準備]
    D --> E{モデレーション有効?}
    E -->|Yes| F[moderationUrl設定]
    E -->|No| G[postUrl設定]
    F --> H[メールレンダリング]
    G --> H
    H --> I[メール送信]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| メール送信失敗 | SMTP設定不正 | ログ出力 | SMTP設定確認 |
| データ取得失敗 | コメント/投稿削除済み | ログ出力 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1件/リクエスト |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | 特に制限なし |

## セキュリティ考慮事項

- サイトオーナーのみが受信対象
- コメント内容はHTMLサニタイズ済み
- 報告者情報（メールアドレス）が含まれるため取り扱い注意

## 備考

- commentModeration labs機能有効時はReview commentボタン表示
- 無効時はView commentボタンで投稿ページへ直接リンク
- コメントパーマリンク機能（commentPermalinks）有効時は#ghost-comments-{id}アンカー付き

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、報告処理で使用されるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | comments-service-emails.js | `ghost/core/core/server/services/comments/comments-service-emails.js` | notifyReport関数（146-193行目） |

**読解のコツ**: templateDataオブジェクト（159-183行目）で全ての表示項目を確認する。

#### Step 2: メールテンプレートを理解する

HTMLメールのレイアウトと動的コンテンツを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | report.hbs | `ghost/core/core/server/services/comments/email-templates/report.hbs` | HTMLテンプレート構造 |

**主要処理フロー**:
- **6行目**: メールタイトル
- **109行目**: preheader（報告者情報）
- **119行目**: 報告メッセージ本文
- **121-146行目**: コメント表示ボックス
- **148-166行目**: アクションボタン（モデレーション有無で分岐）

#### Step 3: ユーティリティを理解する

共通ユーティリティ関数を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | comments-service-emails.js | `ghost/core/core/server/services/comments/comments-service-emails.js` | extractInitials、getPostUrl |

**主要処理フロー**:
- **27-33行目**: getPostUrl（コメントパーマリンク生成）
- **208-211行目**: extractInitials（イニシャル抽出）

### プログラム呼び出し階層図

```
コメント報告
    │
    └─ CommentsServiceEmails.notifyReport(comment, reporter)
           │
           ├─ models.Post.findOne({id: comment.post_id})
           ├─ models.Member.findOne({id: comment.member_id})
           ├─ models.User.getOwnerUser()
           │
           ├─ getPostUrl(post_id, comment_id)
           ├─ extractInitials(memberName)
           │
           ├─ renderEmailTemplate('report', templateData)
           │
           └─ sendMail({to, subject, html, text})
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コメント報告 ───▶ notifyReport ───▶ データ取得
(comment, reporter)                (post, member, owner)
                                        │
                                        ▼
                             ┌─────────────────┐
                             │ テンプレートデータ│
                             │ 構築            │
                             └─────────────────┘
                                        │
                                        ▼
                             ┌─────────────────┐
                             │ HTMLメール生成  │
                             │ (report.hbs)   │
                             └─────────────────┘
                                        │
                                        ▼
                             ┌─────────────────┐
                             │ メール送信      │
                             │ (オーナーへ)    │
                             └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| comments-service-emails.js | `ghost/core/core/server/services/comments/comments-service-emails.js` | ソース | メール送信ロジック |
| report.hbs | `ghost/core/core/server/services/comments/email-templates/report.hbs` | テンプレート | HTMLメールテンプレート |
| comments-service.js | `ghost/core/core/server/services/comments/comments-service.js` | ソース | コメントサービス本体 |
