# 帳票設計書 6-MRR履歴レポート

## 概要

月間経常収益（Monthly Recurring Revenue）の履歴データを提供する統計レポートの設計書。Ghost CMSの有料会員機能において、通貨別のMRR推移を日次で集計して提供するAPIレスポンスを定義する。

### 本帳票の処理概要

本帳票は、Ghost CMSの有料会員サブスクリプションから生成されるMRR（月間経常収益）の履歴データをJSON形式で提供する。日次のMRR変動（delta）から逆算して過去のMRR推移を計算し、通貨別に集計されたデータを返却する。

**業務上の目的・背景**：サイト運営者が収益の推移を把握し、ビジネスの健全性を評価するために利用される。MRRはサブスクリプションビジネスの最重要KPIであり、成長率の分析やトレンド把握に不可欠なデータとなる。

**帳票の利用シーン**：管理画面のDashboardやStats画面でMRRグラフを表示する際にAPIから取得される。外部BIツールとの連携やレポート作成にも活用できる。

**主要な出力内容**：
1. 日別MRR履歴（date、mrr、currency）
2. 現在のMRR合計（通貨別）

**帳票の出力タイミング**：APIエンドポイントへのリクエスト時にリアルタイムで生成される。

**帳票の利用者**：サイト管理者、ビジネスオーナー。ダッシュボードの収益グラフ表示や外部連携に使用。

## 帳票種別

統計レポート（JSON API）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Dashboard | /ghost/#/dashboard | 自動取得 |
| - | Stats | /ghost/#/stats | 自動取得 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（APIレスポンス） |
| 出力方法 | API経由 |
| 文字コード | UTF-8 |

### APIエンドポイント

| 項目 | 内容 |
|-----|------|
| HTTPメソッド | GET |
| パス | /ghost/api/admin/stats/mrr |
| 認証 | authAdminApi必須 |

## 帳票レイアウト

### レスポンス構造

```json
{
  "data": [
    {
      "date": "YYYY-MM-DD",
      "mrr": 12345,
      "currency": "usd"
    }
  ],
  "meta": {
    "totals": [
      {
        "currency": "usd",
        "mrr": 12345
      }
    ]
  }
}
```

### 出力項目詳細

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | date | 日付 | 計算結果 | YYYY-MM-DD |
| 2 | mrr | MRR金額 | 計算結果 | 整数（セント単位） |
| 3 | currency | 通貨コード | members_stripe_customers_subscriptions.plan_currency | 小文字3文字 |

### メタデータ

| 項目名 | 説明 |
|-------|------|
| totals | 現在のMRR合計（通貨別配列） |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| dateFrom | 開始日（デフォルト: 90日前） | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | date | 昇順 |
| 2 | currency | 昇順（アルファベット順） |

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| members_stripe_customers_subscriptions | 現在のMRR合計 | plan_currency集計 |
| members_paid_subscription_events | MRR変動履歴 | currency, date集計 |

### テーブル別参照項目詳細

#### members_stripe_customers_subscriptions

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| plan_currency | currency | GROUP BY | 小文字変換済み |
| mrr | mrr | SUM | 現在のMRR合計 |

#### members_paid_subscription_events

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| currency | currency | GROUP BY | - |
| mrr_delta | delta | SUM | 日次変動値 |
| created_at | date | DATE() | 日付変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| mrr（過去日） | currentMrr - SUM(future_deltas) | Math.max(0, x) | 負値は0に |

### 計算ロジック

1. 現在のMRR合計を通貨別に取得
2. 過去90日間（または指定期間）のMRR変動（delta）を日次で取得
3. 現在値から逆算して各日のMRR値を計算
4. 結果を日付昇順・通貨昇順でソート

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[API要求] --> B[現在MRR取得]
    B --> C[デルタ履歴取得]
    C --> D[日付・通貨ソート]
    D --> E[逆算でMRR計算]
    E --> F[結果配列生成]
    F --> G[JSONレスポンス]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 認証エラー | 認証なし | 401 Unauthorized | ログイン必要 |
| データなし | 有料会員なし | 空配列 + USDプレースホルダ | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 〜90日 x 通貨数 |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | 特に制限なし |

## セキュリティ考慮事項

- 管理者認証が必要
- 収益データのため適切なアクセス制御が必要

## 備考

- MRRは0未満にならないようMath.max(0, x)で保護
- 有料会員がいない場合はUSDで0のプレースホルダを返却
- 未来日のデータはスキップ

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、MRR計算のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mrr-stats-service.js | `ghost/core/core/server/services/stats/mrr-stats-service.js` | 型定義（139-166行目） |

**読解のコツ**: MrrByCurrency、MrrDelta、MrrRecordの型定義で戻り値構造を把握する。

#### Step 2: 計算ロジックを理解する

MRR履歴の計算ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mrr-stats-service.js | `ghost/core/core/server/services/stats/mrr-stats-service.js` | getHistory関数（63-134行目） |

**主要処理フロー**:
- **16-33行目**: getCurrentMrr（現在のMRR取得）
- **40-54行目**: fetchAllDeltas（変動履歴取得）
- **63-134行目**: getHistory（履歴計算本体）

#### Step 3: APIエンドポイントを理解する

ルーティングとエンドポイントの定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | routes.js | `ghost/core/core/server/web/api/endpoints/admin/routes.js` | /stats/mrrルート（159行目） |
| 3-2 | stats-service.js | `ghost/core/core/server/services/stats/stats-service.js` | getMRRHistory呼び出し（26-28行目） |

### プログラム呼び出し階層図

```
GET /ghost/api/admin/stats/mrr
    │
    ├─ api/endpoints/stats.js#mrr
    │      │
    │      └─ StatsService.getMRRHistory(options)
    │             │
    │             └─ MrrStatsService.getHistory(options)
    │                    │
    │                    ├─ getCurrentMrr()
    │                    │      └─ SELECT plan_currency, SUM(mrr)
    │                    │         FROM members_stripe_customers_subscriptions
    │                    │
    │                    └─ fetchAllDeltas(dateFrom)
    │                           └─ SELECT currency, DATE(created_at), SUM(mrr_delta)
    │                              FROM members_paid_subscription_events
```

### データフロー図

```
[入力]                    [処理]                         [出力]

APIリクエスト ───▶ StatsService ───▶ MrrStatsService
(dateFrom?)                              │
                                         ▼
                              ┌─────────────────┐
                              │ 現在MRR取得     │
                              │ (通貨別)        │
                              └─────────────────┘
                                         │
                                         ▼
                              ┌─────────────────┐
                              │ デルタ履歴取得  │
                              │ (90日 or指定)   │
                              └─────────────────┘
                                         │
                                         ▼
                              ┌─────────────────┐
                              │ 逆算でMRR計算   │
                              │ (現在→過去)     │
                              └─────────────────┘
                                         │
                                         ▼
                              ┌─────────────────┐
                              │ JSONレスポンス  │
                              │ {data, meta}    │
                              └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mrr-stats-service.js | `ghost/core/core/server/services/stats/mrr-stats-service.js` | ソース | MRR計算ロジック |
| stats-service.js | `ghost/core/core/server/services/stats/stats-service.js` | ソース | 統計サービス集約 |
| routes.js | `ghost/core/core/server/web/api/endpoints/admin/routes.js` | ソース | ルーティング定義 |
