---
generated_at: 2026-01-29 21:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-会員一覧CSV

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目が根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/api/endpoints/members.js` - exportCSVアクション定義（370-400行目）
- E-02: `ghost/core/core/server/services/members/exporter/query.js` - エクスポートクエリロジック
- E-03: `ghost/core/core/server/services/members/service.js` - サービス層export関数（203行目）
- E-04: `ghost/core/core/server/web/api/endpoints/admin/routes.js` - ルーティング定義（134行目）
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ファイル名はmembers.{YYYY-MM-DD}.csv形式 | E-01 (379-382行目: disposition設定) | ○ |
| C-02 | Content-Typeはtext/csv | E-01 (384行目: contentType設定) | ○ |
| C-03 | ストリーミング形式でレスポンス | E-01 (387-390行目: response.stream=true) | ○ |
| C-04 | browse権限で認可 | E-01 (391-393行目: permissions.method='browse') | ○ |
| C-05 | filter, search, limitオプションが使用可能 | E-01 (371-375行目: options配列) | ○ |
| C-06 | バッチサイズは1000件 | E-02 (144行目: batchSize = 1000) | ○ |
| C-07 | products/labelsテーブルを事前に全取得 | E-02 (72-80行目: allProducts, allLabels取得) | ○ |
| C-08 | 会員ごとにtiers, labels, subscribed, stripe_customer_idを付与 | E-02 (18-43行目: processMembersData関数) | ○ |
| C-09 | members_products, members_labels, members_stripe_customers, members_newslettersをバッチごとに結合 | E-02 (93-112行目: Promise.all内のクエリ) | ○ |
| C-10 | created_atはISO8601形式に変換 | E-02 (40行目: moment().toISOString()) | ○ |
| C-11 | compedステータスの判定 | E-02 (37行目: row.comped = row.status === 'comped') | ○ |
| C-12 | complimentary_planステータスの判定 | E-02 (38行目: row.complimentary_plan = row.status === 'complimentary') | ○ |
| C-13 | subscribedはmembers_newslettersの存在で判定 | E-02 (36行目: subscribedSet.has(row.id)) | ○ |
| C-14 | GET /members/uploadエンドポイント | E-04 (134行目: router.get('/members/upload')) | ○ |
| C-15 | authAdminApiミドルウェアで認証 | E-04 (134行目: mw.authAdminApi) | ○ |
| C-16 | サービス層でexport関数を公開 | E-03 (203行目: export: require('./exporter/query')) | ○ |
| C-17 | フィルター条件がある場合はIDを先に取得 | E-02 (51-67行目: hasFilter判定とID取得) | ○ |
| C-18 | 帳票カテゴリは「エクスポート」 | E-05 (No.1行) | ○ |

## 4) 不足情報（Unknown / Missing）

特になし。全ての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] ファイル名形式（members.{YYYY-MM-DD}.csv）が実際の出力と一致するか
- [ ] CSVカラムの順序が実際の出力と一致するか
- [ ] ストリーミング処理が大量データ（10万件以上）で正常に動作するか
