---
generated_at: 2026-01-29 22:04:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-トップ投稿レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全項目が根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/stats/posts-stats-service.js` - トップ投稿統計ロジック
- E-02: `ghost/core/core/server/services/stats/stats-service.js` - 統計サービス集約
- E-03: `ghost/core/core/server/web/api/endpoints/admin/routes.js` - ルーティング定義
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getTopPostsでメイン処理 | E-01 (99-208行目: getTopPosts関数) | ○ |
| C-02 | _buildFreeMembersSubqueryでfree_members集計 | E-01 (450-503行目: _buildFreeMembersSubquery関数) | ○ |
| C-03 | _buildPaidMembersSubqueryでpaid_members集計 | E-01 (513-548行目: _buildPaidMembersSubquery関数) | ○ |
| C-04 | _buildMrrSubqueryでmrr集計 | E-01 (558-597行目: _buildMrrSubquery関数) | ○ |
| C-05 | free_membersは同投稿で有料転換していない会員 | E-01 (460-477行目: LEFT JOIN + whereNull) | ○ |
| C-06 | paid_membersは有料転換会員のCOUNT DISTINCT | E-01 (519-522行目: countDistinct) | ○ |
| C-07 | mrrはmrr_deltaのSUM | E-01 (565-570行目: sum) | ○ |
| C-08 | orderパラメータでソート | E-01 (101-116行目: order検証) | ○ |
| C-09 | limitパラメータで件数制限（デフォルト20） | E-01 (102-103行目: limit設定) | ○ |
| C-10 | post_typeフィルタでpost/page絞り込み | E-01 (186-198行目: post_typeフィルタ) | ○ |
| C-11 | _enrichWithTitlesでタイトル補完 | E-01 (210-250行目: _enrichWithTitles関数) | ○ |
| C-12 | _generateTitleFromPathでパスからタイトル生成 | E-01 (252-280行目: _generateTitleFromPath関数) | ○ |
| C-13 | urlServiceでURL存在確認 | E-01 (222-234行目: urlService.getResource) | ○ |
| C-14 | 帳票カテゴリは「統計」 | E-04 (No.10行) | ○ |

## 4) 不足情報（Unknown / Missing）

特になし。全ての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] free_membersの定義（同投稿で有料転換していない）が業務要件と一致しているか確認
- [ ] attribution_urlベースの集計が期待通りか確認
- [ ] post_typeフィルタの挙動（page=ページ以外も含む）が適切か確認
- [ ] date_from/date_toパラメータの境界値テスト
