---
generated_at: 2026-01-29 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：11-ニュースレター統計レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/api/endpoints/stats.js` 行196-289（newsletterStats, newsletterBasicStats, newsletterClickStatsコントローラー）
- E-02: `ghost/core/core/server/services/stats/stats-service.js` 行119-223（サービス層メソッド）
- E-03: `ghost/core/core/server/services/stats/posts-stats-service.js` 行693-925（クエリ実装）
- E-04: `ghost/core/core/server/web/api/endpoints/admin/routes.js` 行166-169（ルート定義）
- E-05: `ghost/core/core/server/data/schema/schema.js` 行826-1018（emails, redirects, members_click_eventsテーブル）
- E-06: `ghost/core/core/server/data/schema/schema.js` 行61-104（postsテーブル）
- E-07: `ghost/core/core/server/data/schema/schema.js` 行12-60（newslettersテーブル）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントは `GET /ghost/api/admin/stats/newsletter-stats` | E-04 | ○ |
| C-02 | newsletter_idが必須パラメータ | E-01, E-02 | ○ |
| C-03 | 出力項目にpost_id, post_title, send_date, sent_to, total_opens, open_rate, total_clicks, click_rateが含まれる | E-03 (行739-746) | ○ |
| C-04 | emailsテーブルからemail_count, opened_countを取得 | E-03 (行741-745), E-05 | ○ |
| C-05 | クリック数はmembers_click_eventsからCOUNT DISTINCT member_idで集計 | E-03 (行726-733) | ○ |
| C-06 | 開封率はopened_count / email_countで計算 | E-03 (行743) | ○ |
| C-07 | クリック率はclick_count / email_countで計算 | E-03 (行745) | ○ |
| C-08 | デフォルトのソート順はsend_date降順 | E-03 (行695, 781) | ○ |
| C-09 | デフォルトのlimitは20 | E-03 (行696-697, 782-783) | ○ |
| C-10 | 3つのエンドポイントに分割（newsletter-stats, newsletter-basic-stats, newsletter-click-stats） | E-04 | ○ |
| C-11 | postsテーブルのstatus条件は'sent'または'published' | E-03 (行751) | ○ |
| C-12 | Admin API認証が必須 | E-04 | ○ |
| C-13 | 不正なorder値でBadRequestError発生 | E-03 (行712-721, 798-809) | ○ |
| C-14 | newsletter_id未指定時は空配列を返却 | E-02 (行124-126, 148-149, 195-197, 216-218) | ○ |
| C-15 | redirectsテーブルとmembers_click_eventsテーブルをJOINしてクリック数を取得 | E-03 (行726-733) | ○ |
| C-16 | posts.published_atをsend_dateとして使用 | E-03 (行740) | ○ |
| C-17 | クエリ結果のキャッシュ機能あり | E-01 (行212, 246, 276) | ○ |
| C-18 | 日付フィルタ（date_from, date_to）がサポートされている | E-01 (行202-205, 234-240), E-03 (行756, 846, 866) | ○ |

## 4) 不足情報（Unknown / Missing）

- 該当なし（全ての主要主張に対してソースコードによる根拠が確認された）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] APIエンドポイントのルート定義が正しいことを確認（routes.js 行166-169）
- [ ] 出力項目のカラム名がソースコードと一致していることを確認（posts-stats-service.js 行739-746）
- [ ] 計算式（open_rate, click_rate）が正しいことを確認（posts-stats-service.js 行743, 745）
- [ ] エラー処理の条件が正しいことを確認（posts-stats-service.js 行712-721）
