---
generated_at: 2026-01-29 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-ニュースレター購読者統計

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/api/endpoints/stats.js` 行290-317（subscriberCountコントローラー）
- E-02: `ghost/core/core/server/services/stats/stats-service.js` 行143-154（getNewsletterSubscriberStatsメソッド）
- E-03: `ghost/core/core/server/services/stats/posts-stats-service.js` 行937-1109（getNewsletterSubscriberStats, _getNewsletterSubscriberDeltas, _fillMissingDates）
- E-04: `ghost/core/core/server/web/api/endpoints/admin/routes.js` 行169（ルート定義）
- E-05: `ghost/core/core/server/data/schema/schema.js` 行965-972（members_newslettersテーブル）
- E-06: `ghost/core/core/server/data/schema/schema.js` 行417-444（membersテーブル、email_disabledカラム）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントは `GET /ghost/api/admin/stats/subscriber-count` | E-04 | ○ |
| C-02 | newsletter_idが必須パラメータ | E-01, E-02 | ○ |
| C-03 | 出力項目にtotalとvalues配列が含まれる | E-03 (行1005-1009) | ○ |
| C-04 | valuesにはdateとvalueが含まれる | E-03 (行1100-1103) | ○ |
| C-05 | 総購読者数はmembers_newslettersからCOUNT DISTINCTで取得 | E-03 (行945-953) | ○ |
| C-06 | email_disabled=trueの会員は除外される | E-03 (行947-952, 1041-1046) | ○ |
| C-07 | 日次増減はSUM(CASE WHEN subscribed = 1 THEN 1 ELSE -1 END)で計算 | E-03 (行1038-1039) | ○ |
| C-08 | 日付はmoment-timezoneで処理される | E-03 (行1067, 1075-1076) | ○ |
| C-09 | 欠落日付は前日の値で補完される | E-03 (行1089-1103) | ○ |
| C-10 | 累積値は現在total - 期間内増減で開始値を逆算 | E-03 (行982-984) | ○ |
| C-11 | newsletter_id未指定時は{total: 0, values: []}を返却 | E-02 (行148-149) | ○ |
| C-12 | クエリは並列実行される（Promise.all） | E-03 (行943-957) | ○ |
| C-13 | 日次増減クエリはmembers_subscribe_eventsテーブルを参照 | E-03 (行1035-1048) | ○ |
| C-14 | 結果はdate昇順でソートされる | E-03 (行1048) | ○ |
| C-15 | エラー時は{total: 0, values: []}を返却 | E-03 (行1012-1018) | ○ |
| C-16 | APIキャッシュ機能あり（statsService.cache） | E-01 (行302) | ○ |

## 4) 不足情報（Unknown / Missing）

- 該当なし（全ての主要主張に対してソースコードによる根拠が確認された）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] 総購読者数クエリがemail_disabledを正しく除外していることを確認（posts-stats-service.js 行947-952）
- [ ] 日次増減計算式が正しいことを確認（posts-stats-service.js 行1038-1039）
- [ ] 累積値計算ロジック（逆算方式）が正しいことを確認（posts-stats-service.js 行982-984）
- [ ] 日付補完ロジックが正しいことを確認（posts-stats-service.js 行1089-1103）
