---
generated_at: 2026-01-29 10:40:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-投稿別統計レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/api/endpoints/stats.js` 行389-420（postStatsコントローラー）
- E-02: `ghost/core/core/server/services/stats/stats-service.js` 行161-163（getPostStatsメソッド）
- E-03: `ghost/core/core/server/services/stats/posts-stats-service.js` 行1116-1180（getPostStats実装）
- E-04: `ghost/core/core/server/services/stats/posts-stats-service.js` 行1401-1466（_getMemberAttributionCounts）
- E-05: `ghost/core/core/server/web/api/endpoints/admin/routes.js` 行162（ルート定義）
- E-06: `ghost/core/core/server/data/schema/schema.js` 行526-554（members_created_eventsテーブル）
- E-07: `ghost/core/core/server/data/schema/schema.js` 行609-626（members_paid_subscription_eventsテーブル）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントは `GET /ghost/api/admin/stats/posts/:id/stats` | E-05 | ○ |
| C-02 | postIdはパスパラメータで必須 | E-01 (行393-401), E-03 (行1119-1121) | ○ |
| C-03 | 出力項目にid, recipient_count, opened_count, open_rate, member_delta, free_members, paid_members, visitorsが含まれる | E-03 (行1164-1174) | ○ |
| C-04 | recipient_countはemails.email_countから取得 | E-03 (行1125, 1167) | ○ |
| C-05 | opened_countはemails.opened_countから取得 | E-03 (行1125, 1168) | ○ |
| C-06 | open_rateは(opened_count / email_count) * 100で計算 | E-03 (行1145-1146) | ○ |
| C-07 | member_deltaはfree_members + paid_membersの合計 | E-03 (行1141-1142, 1170) | ○ |
| C-08 | free_membersは有料転換していない会員数 | E-04 (行1411-1422) | ○ |
| C-09 | paid_membersは有料転換した会員数 | E-04 (行1429-1434) | ○ |
| C-10 | visitorsはTinybirdから取得（連携時のみ） | E-03 (行1149-1161) | ○ |
| C-11 | Tinybird未連携時はvisitors = 0 | E-03 (行1149, 1173) | ○ |
| C-12 | postIdが空文字の場合は空配列を返却 | E-03 (行1119-1121) | ○ |
| C-13 | 投稿が存在しないorステータスがpublished以外の場合は空配列 | E-03 (行1131-1133) | ○ |
| C-14 | attribution_typeは'post'または'page'でフィルタ | E-04 (行1419, 1433) | ○ |
| C-15 | 会員獲得数クエリは並列実行される（Promise.all） | E-04 (行1440-1443) | ○ |
| C-16 | Tinybirdエラー時はログ出力してvisitors = 0で続行 | E-03 (行1158-1160) | ○ |
| C-17 | APIキャッシュ機能あり（statsService.cache） | E-01 (行407) | ○ |

## 4) 不足情報（Unknown / Missing）

- 該当なし（全ての主要主張に対してソースコードによる根拠が確認された）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] 会員獲得数（free_members, paid_members）の計算ロジックが正しいことを確認（posts-stats-service.js 行1411-1434）
- [ ] 開封率計算式が正しいことを確認（posts-stats-service.js 行1145-1146）
- [ ] Tinybird連携の条件分岐が正しいことを確認（posts-stats-service.js 行1149-1161）
- [ ] 投稿ステータス条件が正しいことを確認（posts-stats-service.js 行1129）
