---
generated_at: 2026-01-29 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-トップコンテンツレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/api/endpoints/stats.js` 行94-129（topContentコントローラー）
- E-02: `ghost/core/core/server/services/stats/stats-service.js` 行65-67（getTopContentメソッド）
- E-03: `ghost/core/core/server/services/stats/content-stats-service.js` 行45-293（ContentStatsService実装）
- E-04: `ghost/core/core/server/web/api/endpoints/admin/routes.js` 行165（ルート定義）
- E-05: `ghost/core/core/server/data/schema/schema.js` 行61-105（postsテーブル）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントは `GET /ghost/api/admin/stats/top-content` | E-04 | ○ |
| C-02 | 出力項目にpathname, visits, post_uuid, post_id, title, post_type, url_existsが含まれる | E-03 (行248-254, 260-266, 271-276) | ○ |
| C-03 | Tinybird連携が必須（未連携時は空配列） | E-03 (行48-50) | ○ |
| C-04 | Tinybirdのapi_top_pagesエンドポイントを使用 | E-03 (行127) | ○ |
| C-05 | フィルタオプションにdate_from, date_to, timezone, member_status等が含まれる | E-01 (行99-114), E-03 (行77-125) | ○ |
| C-06 | post_uuidからpostsテーブルでタイトルを検索 | E-03 (行150-173) | ○ |
| C-07 | UrlServiceでリソースタイトルを解決 | E-03 (行180-210) | ○ |
| C-08 | url_existsはUrlServiceで現在のURL有効性を確認 | E-03 (行232-244) | ○ |
| C-09 | post_typeフィルタは取得後にサーバーサイドで適用 | E-03 (行280-290) | ○ |
| C-10 | パラメータはsnake_caseからcamelCaseに変換 | E-03 (行77-83) | ○ |
| C-11 | タイトルがDBにない場合はpathnameから生成（'/'→'Homepage'） | E-03 (行270-271) | ○ |
| C-12 | UTMパラメータ（utm_source, utm_medium等）がサポートされている | E-01 (行109-113), E-03 (行111-125) | ○ |
| C-13 | deviceフィルタがサポートされている | E-01 (行107), E-03 (行96-98) | ○ |
| C-14 | locationフィルタがサポートされている | E-01 (行108), E-03 (行101-103) | ○ |
| C-15 | sourceフィルタがサポートされている（空文字でDirect） | E-01 (行109), E-03 (行106-108) | ○ |
| C-16 | エラー時はログ出力して空配列を返却 | E-03 (行64-67) | ○ |
| C-17 | UrlServiceエラー時はログ出力してpathnameからタイトル生成 | E-03 (行203-207) | ○ |
| C-18 | APIキャッシュ機能あり（statsService.cache） | E-01 (行119) | ○ |

## 4) 不足情報（Unknown / Missing）

- 該当なし（全ての主要主張に対してソースコードによる根拠が確認された）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] Tinybird連携確認条件が正しいことを確認（content-stats-service.js 行48-50）
- [ ] フィルタパラメータの変換が正しいことを確認（content-stats-service.js 行77-125）
- [ ] タイトル生成ロジック（DB, UrlService, pathname）の優先順位が正しいことを確認（content-stats-service.js 行247-276）
- [ ] post_typeフィルタの適用ロジックが正しいことを確認（content-stats-service.js 行280-290）
