---
generated_at: 2026-01-29 10:50:00
metrics:
  claims_total: 19
  claims_with_evidence: 19
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-トップソースレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：19 / 19、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/api/endpoints/stats.js` 行495-528（topSourcesGrowthコントローラー）
- E-02: `ghost/core/core/server/services/stats/stats-service.js` 行233-235（getTopSourcesWithRangeメソッド）
- E-03: `ghost/core/core/server/services/stats/referrers-stats-service.js` 行7-120（SOURCE_NORMALIZATION_MAP, normalizeSource）
- E-04: `ghost/core/core/server/services/stats/referrers-stats-service.js` 行244-306（fetchMemberCountsBySource）
- E-05: `ghost/core/core/server/services/stats/referrers-stats-service.js` 行319-408（getTopSourcesWithRange実装）
- E-06: `ghost/core/core/server/web/api/endpoints/admin/routes.js` 行172（ルート定義）
- E-07: `ghost/core/core/server/data/schema/schema.js` 行526-626（members_created_events等）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントは `GET /ghost/api/admin/stats/top-sources-growth` | E-06 | ○ |
| C-02 | 出力項目にsource, signups, paid_conversions, mrrが含まれる | E-05 (行337-345, 355-360) | ○ |
| C-03 | デフォルトのorderはsignups desc | E-05 (行320) | ○ |
| C-04 | デフォルトのlimitは50 | E-05 (行320) | ○ |
| C-05 | 会員数とMRRは並列クエリで取得 | E-05 (行323-326) | ○ |
| C-06 | signupsは有料転換していない会員のみをカウント | E-04 (行249-258) | ○ |
| C-07 | paid_conversionsはCOUNT DISTINCT member_idで計算 | E-04 (行265-268) | ○ |
| C-08 | MRRはmrr_delta > 0のみを合計 | E-03 (行225) | ○ |
| C-09 | ソース正規化マップで表示名を統一 | E-03 (行7-105) | ○ |
| C-10 | 空文字/nullは'Direct'に正規化 | E-03 (行113-115) | ○ |
| C-11 | Facebook系ドメインはFacebookに統一 | E-03 (行10-13) | ○ |
| C-12 | Twitter/x.comはTwitterに統一 | E-03 (行14-16) | ○ |
| C-13 | Google系ドメインはGoogleに統一 | E-03 (行58-60) | ○ |
| C-14 | ソートは常に降順（大きい順） | E-05 (行396) | ○ |
| C-15 | date_from, date_to, timezoneフィルタがサポートされている | E-01 (行501-504), E-04 (行246) | ○ |
| C-16 | members_created_eventsテーブルからreferrer_sourceを取得 | E-04 (行250-251) | ○ |
| C-17 | members_subscription_created_eventsとJOINして有料転換を除外 | E-04 (行252-258) | ○ |
| C-18 | 結果をソースごとに集約 | E-05 (行329-364) | ○ |
| C-19 | APIキャッシュ機能あり（statsService.cache） | E-01 (行511) | ○ |

## 4) 不足情報（Unknown / Missing）

- 該当なし（全ての主要主張に対してソースコードによる根拠が確認された）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] signupsの計算（有料転換除外）が正しいことを確認（referrers-stats-service.js 行249-258）
- [ ] ソース正規化マップが最新であることを確認（referrers-stats-service.js 行7-105）
- [ ] 並列クエリ実行が正しく行われていることを確認（referrers-stats-service.js 行323-326）
- [ ] ソート処理が常に降順であることを確認（referrers-stats-service.js 行396）
