---
generated_at: 2026-01-29 21:48:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-投稿分析CSV

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目が根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/posts/posts-exporter.js` - エクスポーターロジック
- E-02: `ghost/core/core/server/web/api/endpoints/admin/routes.js` - ルーティング定義（32行目）
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトフィルターはstatus:published,status:sent | E-01 (37行目: filter ?? 'status:published,status:sent') | ○ |
| C-02 | withRelatedでtiers, tags, authors, count.*, emailを取得 | E-01 (40-50行目: withRelated配列) | ○ |
| C-03 | newsletters, labels, productsを別途全取得 | E-01 (53-55行目: findAll呼び出し) | ○ |
| C-04 | membersEnabled設定でカラム表示を制御 | E-01 (57行目: settingsHelpers.isMembersEnabled()) | ○ |
| C-05 | trackOpens設定でopens列を制御 | E-01 (60行目: settingsCache.get('email_track_opens')) | ○ |
| C-06 | trackClicks設定でclicks列を制御 | E-01 (61行目: settingsCache.get('email_track_clicks')) | ○ |
| C-07 | feedback_enabled設定でフィードバック列を制御 | E-01 (62行目: newsletters.find で feedback_enabled確認) | ○ |
| C-08 | mapPostStatusでステータスを変換 | E-01 (144-164行目: mapPostStatus関数) | ○ |
| C-09 | postAccessToStringでvisibilityを変換 | E-01 (166-190行目: postAccessToString関数) | ○ |
| C-10 | humanReadableEmailRecipientFilterで受信者フィルター変換 | E-01 (199-213行目: humanReadableEmailRecipientFilter関数) | ○ |
| C-11 | 複数著者はカンマ区切りで結合 | E-01 (86行目: authors.map().join(', ')) | ○ |
| C-12 | 複数タグはカンマ区切りで結合 | E-01 (92行目: tags.map().join(', ')) | ○ |
| C-13 | draft/scheduledではメール関連データをクリア | E-01 (73-77行目: email = null設定) | ○ |
| C-14 | 設定に応じて不要カラムを削除 | E-01 (106-138行目: removeableColumns処理) | ○ |
| C-15 | GET /posts/exportエンドポイント | E-02 (32行目: router.get('/posts/export')) | ○ |
| C-16 | 帳票カテゴリは「エクスポート」 | E-03 (No.2行) | ○ |

## 4) 不足情報（Unknown / Missing）

特になし。全ての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] CSVカラムの順序が実際の出力と一致するか
- [ ] 設定によるカラム表示/非表示が正しく動作するか
- [ ] ステータス変換（mapPostStatus）の結果が期待通りか
- [ ] 受信者フィルターの人間可読変換が正確か
