---
generated_at: 2026-01-29 21:50:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-コンテンツ設定JSON

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全項目が根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/api/endpoints/db.js` - DBエンドポイント定義
- E-02: `ghost/core/core/server/data/exporter/table-lists.js` - テーブルリスト定義
- E-03: `ghost/core/core/server/web/api/endpoints/admin/routes.js` - ルーティング定義
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BACKUP_TABLESには約60テーブルが定義されている | E-02 (2-60行目: BACKUP_TABLES配列) | ○ |
| C-02 | TABLES_ALLOWLISTには20テーブルが定義されている | E-02 (65-86行目: TABLES_ALLOWLIST配列) | ○ |
| C-03 | SETTING_KEYS_BLOCKLISTで9キーが除外される | E-02 (89-100行目: SETTING_KEYS_BLOCKLIST配列) | ○ |
| C-04 | stripe関連キーが除外対象に含まれる | E-02 (90-96行目: stripe_connect_*, stripe_*) | ○ |
| C-05 | includeオプションでBACKUP_TABLESを指定可能 | E-01 (45-49行目: validation.options.include.values) | ○ |
| C-06 | filenameパラメータで既存バックアップを読み込み | E-01 (61-68行目: frame.options.filename判定) | ○ |
| C-07 | exporterでfileNameヘルパーを使用 | E-01 (54行目: exporter.fileName()) | ○ |
| C-08 | doExportでエクスポート実行 | E-01 (72行目: exporter.doExport) | ○ |
| C-09 | エラー時はInternalServerError | E-01 (73-75行目: errors.InternalServerError) | ○ |
| C-10 | ファイル未検出時はNotFoundError | E-01 (64-66行目: errors.NotFoundError) | ○ |
| C-11 | GET /dbエンドポイント | E-03 (237行目: router.get('/db')) | ○ |
| C-12 | 帳票カテゴリは「エクスポート」 | E-04 (No.3行) | ○ |

## 4) 不足情報（Unknown / Missing）

特になし。全ての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] SETTING_KEYS_BLOCKLISTの除外キーが最新か確認
- [ ] エクスポートファイル名形式が仕様通りか確認
- [ ] 大量データでのエクスポート時間が許容範囲か確認
