---
generated_at: 2026-01-29 21:52:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-メンションレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全項目が根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/mentions-email-report/mention-email-report-job.js` - メインジョブロジック
- E-02: `ghost/core/core/server/services/mentions-email-report/service.js` - サービス初期化
- E-03: `ghost/core/core/server/services/staff/email-templates/mention-report.hbs` - HTMLテンプレート
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 24時間以上経過でレポート送信 | E-01 (42行目: 24 * 60 * 60 * 1000 判定) | ○ |
| C-02 | メンションを7プロパティにマッピング | E-01 (48-58行目: report.mentions.map) | ○ |
| C-03 | メンションがなければ0を返して終了 | E-01 (61-63行目: !report?.mentions?.length) | ○ |
| C-04 | getEmailAlertUsers('mention-received')で受信者取得 | E-02 (26行目) | ○ |
| C-05 | 重複URL除去（uniqueMentions） | E-02 (67-69行目: filter処理) | ○ |
| C-06 | 最大5件表示、超過時hasMoreMentions | E-02 (74行目: hasMoreMentions判定) | ○ |
| C-07 | 件名は1サイト/2サイト/3サイト以上で分岐 | E-02 (47-55行目: renderSubject) | ○ |
| C-08 | staffService.api.emails.renderHTMLでレンダリング | E-02 (71-75行目) | ○ |
| C-09 | last_mentions_report_email_timestamp設定で履歴管理 | E-02 (99行目: settingsCache.get) | ○ |
| C-10 | cronジョブはランダムな分・秒で毎時実行 | E-02 (155-162行目: at設定) | ○ |
| C-11 | webmentionsラボ機能が有効時のみ実行 | E-02 (147行目: labs.isSet('webmentions')) | ○ |
| C-12 | limit 5でメンション表示 | E-03 (29行目: limit mentions 5) | ○ |
| C-13 | View all mentionsボタンで/ghost/#/mentionsへリンク | E-03 (94行目: siteUrl ghost/#/mentions) | ○ |
| C-14 | 帳票カテゴリは「メール通知」 | E-04 (No.4行) | ○ |

## 4) 不足情報（Unknown / Missing）

特になし。全ての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] mention-received通知設定の有効化手順が明確か
- [ ] 24時間判定ロジックがタイムゾーンに影響されないか確認
- [ ] 重複URL除去ロジックが期待通り動作するか確認
