---
generated_at: 2026-01-29 21:54:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-コメント報告レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全項目が根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/comments/comments-service-emails.js` - メール送信ロジック
- E-02: `ghost/core/core/server/services/comments/email-templates/report.hbs` - HTMLテンプレート
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getOwnerUserでオーナー取得 | E-01 (149行目: models.User.getOwnerUser()) | ○ |
| C-02 | 件名は"A comment has been reported on your post" | E-01 (153行目: subject設定) | ○ |
| C-03 | reporter表示は名前あれば「名前 (メール)」形式 | E-01 (171行目: 三項演算子) | ○ |
| C-04 | commentModerationEnabled判定 | E-01 (157行目: labs.isSet('commentModeration')) | ○ |
| C-05 | moderationUrlはadmin/#/comments/?id=is:{id}形式 | E-01 (182行目: urlUtils.urlJoin) | ○ |
| C-06 | extractInitialsで姓名イニシャル抽出 | E-01 (208-211行目: extractInitials関数) | ○ |
| C-07 | コメント日時はD MMM YYYY形式 | E-01 (167行目: moment().format('D MMM YYYY')) | ○ |
| C-08 | getPostUrlでコメントパーマリンク生成 | E-01 (27-33行目: getPostUrl関数) | ○ |
| C-09 | commentPermalinksラボ機能でアンカー切替 | E-01 (29-32行目: labs.isSet判定) | ○ |
| C-10 | 報告者情報をpreheaderに表示 | E-02 (109行目: preheader span) | ○ |
| C-11 | モデレーション有無でボタン切替 | E-02 (155-159行目: #if commentModerationEnabled) | ○ |
| C-12 | 帳票カテゴリは「メール通知」 | E-03 (No.5行) | ○ |

## 4) 不足情報（Unknown / Missing）

特になし。全ての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] オーナー以外への通知オプションが将来必要か確認
- [ ] コメントパーマリンク機能の有効化状態を確認
- [ ] moderationUrlのアクセス権限が適切か確認
