---
generated_at: 2026-01-29 21:56:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-MRR履歴レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全項目が根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/stats/mrr-stats-service.js` - MRR計算ロジック
- E-02: `ghost/core/core/server/services/stats/stats-service.js` - 統計サービス集約
- E-03: `ghost/core/core/server/web/api/endpoints/admin/routes.js` - ルーティング定義
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 現在MRRはmembers_stripe_customers_subscriptionsから取得 | E-01 (18-23行目: getCurrentMrr) | ○ |
| C-02 | デルタはmembers_paid_subscription_eventsから取得 | E-01 (45-53行目: fetchAllDeltas) | ○ |
| C-03 | デフォルト期間は90日 | E-01 (43-44行目: subtract(90, 'days')) | ○ |
| C-04 | 有料会員なしの場合USDプレースホルダ返却 | E-01 (24-29行目: rows.length === 0) | ○ |
| C-05 | MRRは0未満にならないようMath.max保護 | E-01 (108行目: Math.max(0, currentTotals)) | ○ |
| C-06 | 日付昇順・通貨昇順でソート | E-01 (69-74行目: sort関数) | ○ |
| C-07 | 未来日のデータはスキップ | E-01 (101-104行目: date > today判定) | ○ |
| C-08 | meta.totalsに現在MRR合計 | E-01 (128-133行目: meta設定) | ○ |
| C-09 | GET /stats/mrrエンドポイント | E-03 (159行目) | ○ |
| C-10 | 帳票カテゴリは「統計」 | E-04 (No.6行) | ○ |

## 4) 不足情報（Unknown / Missing）

特になし。全ての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] 逆算ロジックが正確にMRR履歴を再現しているか確認
- [ ] 複数通貨対応が期待通り動作するか確認
- [ ] dateFromパラメータの境界値テスト
