---
generated_at: 2026-01-29 21:58:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-会員数履歴レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全項目が根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/stats/members-stats-service.js` - 会員数計算ロジック
- E-02: `ghost/core/core/server/services/stats/stats-service.js` - 統計サービス集約
- E-03: `ghost/core/core/server/web/api/endpoints/admin/routes.js` - ルーティング定義
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 現在会員数はmembersテーブルからステータス別カウント | E-01 (17-21行目: getCount) | ○ |
| C-02 | デルタはmembers_status_eventsから取得 | E-01 (46-67行目: fetchAllStatusDeltas) | ○ |
| C-03 | デフォルト期間は91日 | E-01 (43行目: subtract(91, 'days')) | ○ |
| C-04 | paid_subscribed/paid_canceledのCASE WHEN計算 | E-01 (48-55行目: SELECT文) | ○ |
| C-05 | startDate指定時は_generateCompleteRange | E-01 (87-88行目: if判定) | ○ |
| C-06 | startDate未指定時は_generateSparseRange | E-01 (92行目: else) | ○ |
| C-07 | forward-fillで欠損日を埋める | E-01 (159-190行目: generateCompleteRange内) | ○ |
| C-08 | 会員数は0未満にならないようMath.max保護 | E-01 (134-137行目, 226-228行目) | ○ |
| C-09 | GET /stats/member_countエンドポイント | E-03 (158行目) | ○ |
| C-10 | 帳票カテゴリは「統計」 | E-04 (No.7行) | ○ |

## 4) 不足情報（Unknown / Missing）

特になし。全ての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] forward-fill処理が正確に欠損日を埋めているか確認
- [ ] startDate/endDateパラメータの境界値テスト
- [ ] 逆算ロジックが正確に会員数履歴を再現しているか確認
