---
generated_at: 2026-01-29 22:02:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-リファラー履歴レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全項目が根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/services/stats/referrers-stats-service.js` - リファラー統計ロジック
- E-02: `ghost/core/core/server/services/stats/stats-service.js` - 統計サービス集約
- E-03: `ghost/core/core/server/web/api/endpoints/admin/routes.js` - ルーティング定義
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SOURCE_NORMALIZATION_MAPでソース正規化 | E-01 (7-105行目: Map定義) | ○ |
| C-02 | normalizeSource関数で正規化実行 | E-01 (112-120行目: normalizeSource関数) | ○ |
| C-03 | 空・nullは"Direct"に正規化 | E-01 (113-115行目: if判定) | ○ |
| C-04 | getReferrersHistoryでメイン処理 | E-01 (135-171行目: getReferrersHistory関数) | ○ |
| C-05 | fetchAllSignupSourcesでサインアップ取得 | E-01 (193-205行目: fetchAllSignupSources関数) | ○ |
| C-06 | fetchAllPaidConversionSourcesで有料転換取得 | E-01 (176-188行目: fetchAllPaidConversionSources関数) | ○ |
| C-07 | デフォルト期間は90日 | E-01 (178行目, 195行目: subtract(90, 'days')) | ○ |
| C-08 | getTopSourcesWithRangeで集計取得 | E-01 (319-408行目: getTopSourcesWithRange関数) | ○ |
| C-09 | fetchMemberCountsBySourceで重複除外カウント | E-01 (244-306行目: fetchMemberCountsBySource関数) | ○ |
| C-10 | 日付昇順でソート | E-01 (163-165行目: sort関数) | ○ |
| C-11 | order, limitパラメータ対応 | E-01 (320行目: options.order, options.limit) | ○ |
| C-12 | 帳票カテゴリは「統計」 | E-04 (No.9行) | ○ |

## 4) 不足情報（Unknown / Missing）

特になし。全ての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] SOURCE_NORMALIZATION_MAPに必要なドメインが全て含まれているか確認
- [ ] 重複除外（DISTINCT）の処理が期待通りか確認
- [ ] date_from/date_toパラメータの境界値テスト
