---
generated_at: 2026-01-29 10:30:00
metrics:
  claims_total: 75
  claims_with_evidence: 72
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：業務要件一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：72 / 75、根拠なし：3
- 優先レビュー（高）
  1. **BR-065（システム通知管理）**：notifications.jsの詳細実装未確認
  2. **BR-075（統計情報取得）**：stats.jsの詳細実装未確認
  3. **BR-067（リダイレクト設定）**：redirects.jsの詳細実装未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/api/endpoints/posts.js`
- E-02: `ghost/core/core/server/api/endpoints/members.js`
- E-03: `ghost/core/core/server/api/endpoints/users.js`
- E-04: `ghost/core/core/server/api/endpoints/newsletters.js`
- E-05: `ghost/core/core/server/api/endpoints/themes.js`
- E-06: `ghost/core/core/server/api/endpoints/offers.js`
- E-07: `ghost/core/core/server/api/endpoints/tags.js`
- E-08: `ghost/core/core/server/api/endpoints/emails.js`
- E-09: `ghost/core/core/server/api/endpoints/recommendations.js`
- E-10: `ghost/core/core/server/api/endpoints/comments-members.js`
- E-11: `ghost/core/core/server/api/endpoints/session.js`
- E-12: `ghost/core/core/server/api/endpoints/authentication.js`
- E-13: `ghost/core/core/server/api/endpoints/db.js`
- E-14: `ghost/core/core/server/api/endpoints/integrations.js`
- E-15: `ghost/core/core/server/api/endpoints/tiers.js`
- E-16: `ghost/core/core/server/api/endpoints/settings.js`
- E-17: `ghost/core/core/server/services/posts/posts-service.js`
- E-18: `ghost/core/core/server/services/newsletters/newsletters-service.js`
- E-19: `ghost/core/core/server/data/schema/schema.js`
- E-20: `ghost/core/core/server/models/post.js`
- E-21: `ghost/core/core/server/models/member.js`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (BR-001) | 記事の作成・編集機能 | E-01, E-17, E-20 | ○ |
| C-02 (BR-002) | 記事の削除・一括操作 | E-01, E-17 | ○ |
| C-03 (BR-003) | 記事のコピー機能 | E-17 (copyPost) | ○ |
| C-04 (BR-004) | 記事の公開状態管理 | E-01, E-17, E-20 | ○ |
| C-05 (BR-005) | 記事のアクセス制御 | E-17, E-19, E-20 | ○ |
| C-06 (BR-006) | ページ管理 | E-19 (type: post/page) | ○ |
| C-07 (BR-007) | タグ管理 | E-07, E-19 | ○ |
| C-08 (BR-008) | 記事プレビュー | E-01, E-17 | ○ |
| C-09 (BR-009) | 記事CSVエクスポート | E-01 (exportCSV) | ○ |
| C-10 (BR-010) | メンバー登録・作成 | E-02, E-21 | ○ |
| C-11 (BR-011) | メンバー情報編集 | E-02 | ○ |
| C-12 (BR-012) | メンバー削除・一括削除 | E-02 | ○ |
| C-13 (BR-013) | メンバー一括編集 | E-02 (bulkEdit) | ○ |
| C-14 (BR-014) | メンバーCSVインポート | E-02 (importCSV) | ○ |
| C-15 (BR-015) | メンバーCSVエクスポート | E-02 (exportCSV) | ○ |
| C-16 (BR-016) | メンバーステータス管理 | E-21 (status: free/paid/comped) | ○ |
| C-17 (BR-017) | メンバー統計・分析 | E-02 (memberStats, mrrStats) | ○ |
| C-18 (BR-018) | メンバーログアウト強制 | E-02 (logout) | ○ |
| C-19 (BR-019) | サブスクリプション作成 | E-02 (createSubscription) | ○ |
| C-20 (BR-020) | サブスクリプション編集 | E-02 (editSubscription) | ○ |
| C-21 (BR-021) | ティア管理 | E-15 | ○ |
| C-22 (BR-022) | オファー管理 | E-06 | ○ |
| C-23 (BR-023) | ニュースレター作成 | E-04, E-18 | ○ |
| C-24 (BR-024) | ニュースレター編集 | E-04, E-18 | ○ |
| C-25 (BR-025) | ニュースレター一覧・取得 | E-04, E-18 | ○ |
| C-26 (BR-026) | メール送信・リトライ | E-08 | ○ |
| C-27 (BR-027) | メール配信状況確認 | E-08 | ○ |
| C-28 (BR-028) | メール分析 | E-08 | ○ |
| C-29 (BR-029) | メールプレビュー | エンドポイント存在確認済み | ○ |
| C-30 (BR-030) | スタッフユーザー管理 | E-03 | ○ |
| C-31 (BR-031) | パスワード変更 | E-03 (changePassword) | ○ |
| C-32 (BR-032) | オーナー権限移譲 | E-03 (transferOwnership) | ○ |
| C-33 (BR-033) | 個人APIトークン管理 | E-03 (readToken, regenerateToken) | ○ |
| C-34 (BR-034) | 初期セットアップ | E-12 (setup, isSetup) | ○ |
| C-35 (BR-035) | ログイン・ログアウト | E-11 | ○ |
| C-36 (BR-036) | パスワードリセット | E-12 | ○ |
| C-37 (BR-037) | 招待の承諾 | E-12 (acceptInvitation) | ○ |
| C-38 (BR-038) | 2要素認証 | E-11 (sendVerification, verify) | ○ |
| C-39 (BR-039) | テーマ一覧・詳細取得 | E-05 | ○ |
| C-40 (BR-040) | テーマアップロード | E-05 (upload) | ○ |
| C-41 (BR-041) | テーマGitHubインストール | E-05 (install) | ○ |
| C-42 (BR-042) | テーマ有効化 | E-05 (activate) | ○ |
| C-43 (BR-043) | テーマダウンロード・削除 | E-05 | ○ |
| C-44 (BR-044) | サイト設定の取得・更新 | E-16 | ○ |
| C-45 (BR-045) | Stripe連携設定 | E-16 | ○ |
| C-46 (BR-046) | ルート設定 | E-16 | ○ |
| C-47 (BR-047) | インテグレーション管理 | E-14 | ○ |
| C-48 (BR-048) | Webhook管理 | E-14, E-19 | ○ |
| C-49 (BR-049) | スタッフ招待 | エンドポイント存在確認済み | ○ |
| C-50 (BR-050) | コンテンツバックアップ | E-13 | ○ |
| C-51 (BR-051) | コンテンツインポート | E-13 (importContent) | ○ |
| C-52 (BR-052) | 全コンテンツ削除 | E-13 (deleteAllContent) | ○ |
| C-53 (BR-053) | 画像アップロード | エンドポイント存在確認済み | ○ |
| C-54 (BR-054) | メディアファイル管理 | エンドポイント存在確認済み | ○ |
| C-55 (BR-055) | メディアインライン化 | E-13 (inlineMedia) | ○ |
| C-56 (BR-056) | コメント投稿・編集 | E-10 | ○ |
| C-57 (BR-057) | コメントいいね・報告 | E-10 | ○ |
| C-58 (BR-058) | コメント管理（管理者） | エンドポイント存在確認済み | ○ |
| C-59 (BR-059) | レコメンデーション管理 | E-09 | ○ |
| C-60 (BR-060) | 受信レコメンデーション確認 | エンドポイント存在確認済み | ○ |
| C-61 (BR-061) | 検索インデックス管理 | エンドポイント存在確認済み | ○ |
| C-62 (BR-062) | oEmbed取得 | エンドポイント存在確認済み | ○ |
| C-63 (BR-063) | メンバーフィードバック | エンドポイント存在確認済み | ○ |
| C-64 (BR-064) | スラグ自動生成 | エンドポイント存在確認済み | ○ |
| C-65 (BR-065) | システム通知管理 | **根拠なし** | △ |
| C-66 (BR-066) | 予約投稿の公開 | エンドポイント存在確認済み | ○ |
| C-67 (BR-067) | リダイレクト設定 | **根拠なし** | △ |
| C-68 (BR-068) | アナウンスメント管理 | エンドポイント存在確認済み | ○ |
| C-69 (BR-069) | Webmention管理 | エンドポイント存在確認済み | ○ |
| C-70 (BR-070) | メンバーラベル管理 | エンドポイント存在確認済み | ○ |
| C-71 (BR-071) | アクション履歴取得 | エンドポイント存在確認済み | ○ |
| C-72 (BR-072) | リンククリック管理 | エンドポイント存在確認済み | ○ |
| C-73 (BR-073) | ロール一覧取得 | エンドポイント存在確認済み | ○ |
| C-74 (BR-074) | スニペット管理 | エンドポイント存在確認済み | ○ |
| C-75 (BR-075) | 統計情報取得 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- BR-065（システム通知管理）：notifications.jsの詳細コード読み取りを実施していないため、具体的な機能詳細は推定に基づく
  - 候補：notifications.js / admin-x-settings内のUI実装 / Ember admin内のnotificationsコンポーネント
- BR-067（リダイレクト設定）：redirects.jsの詳細コード読み取りを実施していない
  - 候補：redirects.js / route-settings service / ファイルアップロード処理
- BR-075（統計情報取得）：stats.jsの詳細コード読み取りを実施していない
  - 候補：stats.js / tinybird連携 / members-statsサービス

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 全体の96%の要件がソースコードから直接確認された根拠を持つ
- **1 (中リスク)**: 一部のエンドポイント（notifications, redirects, stats）は詳細実装未確認
- **0 (低リスク)**: データスキーマ（schema.js）との整合性確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] BR-001〜BR-009（コンテンツ管理）の機能範囲が実際のUI操作と一致するか
- [ ] BR-010〜BR-018（メンバー管理）の権限設定が適切か
- [ ] BR-019〜BR-022（サブスクリプション）のStripe連携動作確認
- [ ] BR-023〜BR-025（ニュースレター）のメール検証フロー確認
- [ ] BR-030〜BR-038（認証）のセキュリティ要件確認
- [ ] BR-065, BR-067, BR-075 の△マーク項目の詳細確認
- [ ] 優先度「高」の要件が実運用と一致するか確認
