---
generated_at: 2026-01-29 20:15:00
metrics:
  claims_total: 92
  claims_with_evidence: 89
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：89 / 92、根拠なし：3
- 優先レビュー（高）
  1. **C-84（Lexical Editor）**：依存パッケージとして参照されており、コード内に直接実装がない
  2. **C-55（Tinybird連携）**：設定ファイルとスクリプトのみで詳細な実装確認が必要
  3. **C-91（Explore連携）**：外部サービス連携のため、API仕様の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json（ルート）` - モノレポ構成、ワークスペース定義
- E-02: `ghost/core/package.json` - Ghost coreの依存関係、バージョン6.15.0
- E-03: `ghost/admin/package.json` - Ember.js管理画面、バージョン6.15.0
- E-04: `ghost/core/core/server/services/` - サーバーサイドサービス一覧（66ディレクトリ）
- E-05: `ghost/core/core/server/models/` - データモデル一覧（70ファイル）
- E-06: `ghost/core/core/server/api/endpoints/` - APIエンドポイント一覧
- E-07: `ghost/core/core/server/data/schema/schema.js` - データベーススキーマ定義
- E-08: `apps/portal/package.json` - Portalアプリ（メンバー向けUI）
- E-09: `apps/comments-ui/package.json` - コメントUIアプリ
- E-10: `apps/signup-form/package.json` - サインアップフォームアプリ
- E-11: `apps/sodo-search/package.json` - 検索UIアプリ
- E-12: `apps/announcement-bar/package.json` - アナウンスメントバーアプリ
- E-13: `apps/admin-x-settings/package.json` - 設定管理React UI
- E-14: `apps/posts/package.json` - 記事分析React UI
- E-15: `apps/stats/package.json` - 統計React UI
- E-16: `apps/activitypub/package.json` - ActivityPub管理React UI
- E-17: `apps/shade/` - 新デザインシステム
- E-18: `apps/admin-x-design-system/` - レガシーデザインシステム
- E-19: `apps/admin-x-framework/` - 管理画面フレームワーク
- E-20: `ghost/i18n/` - 国際化パッケージ
- E-21: `README.md` - プロジェクト概要
- E-22: `AGENTS.md（CLAUDE.md）` - 開発者向けドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 記事管理 | E-05, E-06, E-07 | ○ |
| C-02 | ページ管理 | E-06 | ○ |
| C-03 | タグ管理 | E-05, E-07 | ○ |
| C-04 | コレクション管理 | E-05 | ○ |
| C-05 | スニペット管理 | E-05 | ○ |
| C-06 | 記事リビジョン | E-05, E-07 | ○ |
| C-07 | メディアアップロード | E-06 | ○ |
| C-08 | メンバー登録 | E-05, E-08 | ○ |
| C-09 | メンバー認証 | E-04, E-06 | ○ |
| C-10 | メンバープロフィール | E-05 | ○ |
| C-11 | メンバーラベル | E-05 | ○ |
| C-12 | メンバーCSVインポート/エクスポート | E-06 | ○ |
| C-13 | メンバーアクティビティ | E-04 | ○ |
| C-14 | Stripe連携 | E-04 | ○ |
| C-15 | Tier（プラン）管理 | E-04, E-05 | ○ |
| C-16 | オファー管理 | E-04, E-05 | ○ |
| C-17 | 寄付機能 | E-04 | ○ |
| C-18 | サブスクリプション管理 | E-05 | ○ |
| C-19 | ニュースレター配信 | E-04 | ○ |
| C-20 | ニュースレター管理 | E-04, E-05 | ○ |
| C-21 | メールテンプレート | E-04 | ○ |
| C-22 | メール分析 | E-04 | ○ |
| C-23 | メール抑制リスト | E-04 | ○ |
| C-24 | メンバー歓迎メール | E-04 | ○ |
| C-25 | 記事コメント | E-04, E-09 | ○ |
| C-26 | コメントモデレーション | E-04 | ○ |
| C-27 | コメントいいね | E-05 | ○ |
| C-28 | コメント報告 | E-05 | ○ |
| C-29 | コメント通知 | E-04 | ○ |
| C-30 | テーマ管理 | E-04 | ○ |
| C-31 | カスタムテーマ設定 | E-04 | ○ |
| C-32 | コードインジェクション | E-07 | ○ |
| C-33 | カスタムリダイレクト | E-04 | ○ |
| C-34 | ルート設定 | E-04 | ○ |
| C-35 | 一般設定 | E-05, E-07 | ○ |
| C-36 | ソーシャルメディア連携 | E-07 | ○ |
| C-37 | 多言語対応（i18n） | E-20 | ○ |
| C-38 | SEO設定 | E-07 | ○ |
| C-39 | アナウンスメントバー | E-04, E-12 | ○ |
| C-40 | スタッフ管理 | E-05, E-07 | ○ |
| C-41 | ロール管理 | E-05, E-07 | ○ |
| C-42 | 権限管理 | E-04, E-05 | ○ |
| C-43 | 招待機能 | E-04, E-05 | ○ |
| C-44 | Content API | E-06 | ○ |
| C-45 | Admin API | E-06 | ○ |
| C-46 | カスタムインテグレーション | E-04, E-05 | ○ |
| C-47 | Webhook | E-04, E-05 | ○ |
| C-48 | oEmbed | E-04 | ○ |
| C-49 | サイト内検索 | E-06, E-11 | ○ |
| C-50 | 検索インデックス | E-06 | ○ |
| C-51 | サイト統計 | E-04, E-15 | ○ |
| C-52 | 記事分析 | E-06, E-14 | ○ |
| C-53 | メンバー分析 | E-04 | ○ |
| C-54 | リンクトラッキング | E-04 | ○ |
| C-55 | Tinybird連携 | E-04 | △ |
| C-56 | オーディエンスフィードバック | E-04 | ○ |
| C-57 | ActivityPub | E-04, E-16 | ○ |
| C-58 | Webmention | E-04 | ○ |
| C-59 | アウトボックス | E-04 | ○ |
| C-60 | サイトレコメンデーション | E-04 | ○ |
| C-61 | 受信レコメンデーション | E-06 | ○ |
| C-62 | 管理者通知 | E-04 | ○ |
| C-63 | Slack通知 | E-04 | ○ |
| C-64 | マイルストーン通知 | E-04 | ○ |
| C-65 | データベース管理 | E-06 | ○ |
| C-66 | ジョブ管理 | E-04 | ○ |
| C-67 | メール配信管理 | E-04 | ○ |
| C-68 | 更新チェック | E-04 | ○ |
| C-69 | 制限管理 | E-04 | ○ |
| C-70 | アダプター管理 | E-04 | ○ |
| C-71 | Portal | E-08 | ○ |
| C-72 | Comments UI | E-09 | ○ |
| C-73 | Signup Form | E-10 | ○ |
| C-74 | Search（Sodo Search） | E-11 | ○ |
| C-75 | Announcement Bar | E-12 | ○ |
| C-76 | Ghost Admin | E-03 | ○ |
| C-77 | Admin Settings（React） | E-13 | ○ |
| C-78 | Posts Analytics | E-14 | ○ |
| C-79 | Stats Dashboard | E-15 | ○ |
| C-80 | ActivityPub Admin | E-16 | ○ |
| C-81 | Shade | E-17 | ○ |
| C-82 | Admin X Design System | E-18 | ○ |
| C-83 | Admin X Framework | E-19 | ○ |
| C-84 | Lexical Editor | E-02（依存パッケージ） | △ |
| C-85 | Mobiledoc変換 | E-05, E-07 | ○ |
| C-86 | URL生成 | E-04 | ○ |
| C-87 | リンクリダイレクト | E-04 | ○ |
| C-88 | 認証 | E-04 | ○ |
| C-89 | APIキー管理 | E-05, E-07 | ○ |
| C-90 | ブルートフォース対策 | E-07 | ○ |
| C-91 | Explore連携 | E-04 | △ |
| C-92 | メンバー属性 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-55（Tinybird連携）**: Tinybirdとの連携はスクリプトと設定ファイルで確認できるが、詳細な実装は外部サービス依存のため完全な検証が困難
  - 候補：Tinybirdの公式ドキュメント / 設定ファイル / 運用マニュアル
- **C-84（Lexical Editor）**: @tryghost/koenig-lexicalとして依存パッケージに含まれているが、当リポジトリ内には実装がない
  - 候補：koenig-lexicalリポジトリ / npmパッケージドキュメント
- **C-91（Explore連携）**: Ghost Exploreプラットフォームは外部サービスのため、API仕様の詳細確認が必要
  - 候補：Ghost Explore公式ドキュメント / APIリファレンス

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分の機能はソースコード・スキーマから直接確認可能
- **1（中リスク）**: 外部サービス連携機能（Stripe, Tinybird, Explore）については、連携先の仕様変更に注意が必要
- **0（低リスク）**: フロントエンドアプリは独立したパッケージとして管理されており、依存関係が明確

## 6) レビュアーチェックリスト（最小）
- [ ] 92件の機能がプロジェクトの実際の範囲と一致しているか確認
- [ ] カテゴリ分類が適切か確認（コンテンツ管理、メンバー管理、課金・決済等）
- [ ] 備考欄に記載されているファイルパスが実際に存在するか抽出確認
- [ ] 外部連携機能（Stripe, Tinybird, Explore）の現在の実装状況を確認
- [ ] Lexical Editorの依存パッケージバージョンが最新か確認（@tryghost/koenig-lexical: 1.7.9）
- [ ] 廃止予定機能（Admin X Design System等）のステータスを確認
