# 機能設計書 14-Stripe連携

## 概要

本ドキュメントは、GhostにおけるStripe決済プラットフォームとの連携機能の設計仕様を記載する。本機能は、有料サブスクリプションの決済処理、Webhookによるイベント同期、および顧客情報の管理を提供する。

### 本機能の処理概要

**業務上の目的・背景**：
サイト運営者が有料コンテンツを提供し、購読者から定期課金を受け取るためには、安全で信頼性の高い決済システムが必要である。Stripeは世界的に利用されている決済プラットフォームであり、これと連携することで、クレジットカード決済、サブスクリプション管理、請求書発行などの決済機能をGhostに統合できる。

**機能の利用シーン**：
- 有料メンバーシップの決済処理時
- サブスクリプションの作成・更新・キャンセル時
- Webhookによる決済イベントの受信時
- Stripe Connect による初期設定時
- 顧客ポータルへのリダイレクト時

**主要な処理内容**：
1. Stripe APIの設定と初期化
2. Webhookの登録と管理
3. チェックアウトセッションの作成
4. サブスクリプションイベントの処理
5. 請求書イベントの処理
6. Billing Portalの管理

**関連システム・外部連携**：
- Stripe API（決済処理、顧客管理）
- Stripe Webhook（イベント通知）
- メンバー管理システム（顧客-メンバー紐付け）
- Tier管理システム（商品-価格紐付け）

**権限による制御**：
- Stripe設定の変更: Administrator以上
- 顧客ポータルアクセス: メンバー本人のみ

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 45 | ティア設定 | 補助機能 | 決済プラットフォームとの連携設定 |
| 57 | 投げ銭・寄付設定 | 補助機能 | Stripe経由での決済設定 |
| 81 | プラン選択ページ | 補助機能 | 決済処理 |
| 87 | オファーページ | 補助機能 | 割引決済処理 |

## 機能種別

外部API連携 / 決済処理

## 入力仕様

### 入力パラメータ（設定）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| secretKey | string | Yes | Stripe シークレットキー | sk_で始まる |
| publicKey | string | Yes | Stripe 公開キー | pk_で始まる |
| enablePromoCodes | boolean | No | プロモーションコード有効化 | - |
| enableAutomaticTax | boolean | No | 自動税計算有効化 | - |
| webhookSecret | string | Yes | Webhook署名検証用シークレット | whsec_で始まる |
| webhookHandlerUrl | string | Yes | Webhook受信URL | - |

### 入力データソース

- 管理画面からのStripe接続設定
- Stripe Webhookからのイベント通知

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| stripe_customer_id | string | Stripe顧客ID |
| subscription_id | string | StripeサブスクリプションID |
| checkout_session_url | string | チェックアウトセッションURL |
| billing_portal_url | string | Billing PortalのURL |

### 出力先

- Stripe API（決済リクエスト）
- DBテーブル（顧客・サブスクリプション情報）

## 処理フロー

### 処理シーケンス

```
1. Stripe初期設定
   └─ API キー設定、Webhook登録
2. チェックアウトセッション作成
   └─ 商品・価格情報を渡してセッションURL取得
3. Webhookイベント受信
   └─ 署名検証 → イベント種別判定 → 処理実行
4. サブスクリプション同期
   └─ 作成/更新/キャンセルをDB反映
5. 請求書処理
   └─ 支払い成功/失敗の処理
```

### フローチャート

```mermaid
flowchart TD
    A[Stripe連携開始] --> B{接続済み?}
    B -->|No| C[Stripe Connect設定]
    B -->|Yes| D[API初期化]
    C --> D
    D --> E[Webhook登録]
    E --> F[連携完了]

    G[Webhookイベント受信] --> H{署名検証}
    H -->|成功| I{イベント種別}
    H -->|失敗| J[400エラー]
    I -->|checkout.session.completed| K[チェックアウト完了処理]
    I -->|customer.subscription.*| L[サブスクリプション処理]
    I -->|invoice.*| M[請求書処理]
    K --> N[メンバー更新]
    L --> N
    M --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-14-01 | Webhook署名検証 | 全Webhookは署名検証を必須とする | Webhook受信時 |
| BR-14-02 | テスト環境分離 | testEnv設定でテスト/本番を分離 | API呼び出し時 |
| BR-14-03 | 自動再登録 | Webhookが削除された場合は自動再登録 | サービス起動時 |
| BR-14-04 | 顧客紐付け | Stripe顧客をGhostメンバーと紐付ける | チェックアウト完了時 |
| BR-14-05 | MRR計算 | サブスクリプションからMRRを計算 | サブスクリプション変更時 |
| BR-14-06 | 切断時のデータ保持 | Stripe切断時はローカルデータを削除 | disconnect実行時 |

### 計算ロジック

- MRR計算: サブスクリプション金額を月額に正規化

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 顧客作成 | members_stripe_customers | INSERT | Stripe顧客とメンバーの紐付け |
| サブスク作成 | members_stripe_customers_subscriptions | INSERT/UPDATE | サブスクリプション情報 |
| 価格作成 | stripe_prices | INSERT | Stripe価格情報 |
| 商品作成 | stripe_products | INSERT | Stripe商品情報 |
| 切断時削除 | stripe_prices, stripe_products, members_stripe_customers | DELETE | Stripe関連データ削除 |

### テーブル別操作詳細

#### members_stripe_customers

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | member_id | Ghostメンバー ID | - |
| INSERT | customer_id | Stripe顧客 ID | - |
| INSERT | name | 顧客名 | nullable |
| INSERT | email | 顧客メール | - |

#### members_stripe_customers_subscriptions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPSERT | subscription_id | StripeサブスクリプションID | - |
| UPSERT | customer_id | Stripe顧客ID | - |
| UPSERT | status | サブスクリプションステータス | active/canceled等 |
| UPSERT | cancel_at_period_end | 期末キャンセルフラグ | boolean |
| UPSERT | current_period_end | 現在期間終了日 | - |
| UPSERT | mrr | 月額収益 | 計算値 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | BadRequest | Webhook署名検証失敗 | 正しいWebhookシークレット設定 |
| 401 | Unauthorized | APIキー無効 | 正しいAPIキー設定 |
| 404 | NotFound | 顧客/サブスクが見つからない | Stripeダッシュボードで確認 |
| 500 | InternalError | Stripe API障害 | リトライまたはサポート連絡 |

### リトライ仕様

- Webhookは Stripe 側で自動リトライ（最大3日間）
- API呼び出しは必要に応じてアプリケーション側でリトライ

## トランザクション仕様

- Webhook処理: イベント種別ごとに適切なトランザクション管理
- 顧客紐付け: メンバー更新とStripe顧客作成を同一トランザクション

## パフォーマンス要件

- Webhook応答: 20秒以内（Stripeタイムアウト前）
- チェックアウトセッション作成: 即時応答

## セキュリティ考慮事項

- APIキーの安全な保管（暗号化）
- Webhook署名の必須検証
- センシティブ情報のログ出力抑制
- テスト/本番環境の分離

## 備考

- Stripe Live Mode 有効化時に StripeLiveEnabledEvent 発火
- 切断時に StripeLiveDisabledEvent 発火

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: サービス構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stripe-service.js | `ghost/core/core/server/services/stripe/stripe-service.js` | 全体構造、依存関係 |

**読解のコツ**:
- コンストラクタで各コンポーネント（API, WebhookManager, BillingPortalManager等）を初期化
- configure()で設定適用、connect()/disconnect()でライフサイクル管理

**主要処理フロー**:
- **32-139行目**: コンストラクタで各サービスコンポーネントを初期化
- **141-143行目**: connect() - Liveモード有効化
- **145-161行目**: disconnect() - データクリアと切断
- **167-192行目**: configure() - API設定とWebhook登録

#### Step 2: Webhook処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | webhook-controller.js | `ghost/core/core/server/services/stripe/webhook-controller.js` | Webhookルーティング |
| 2-2 | subscription-event-service.js | `ghost/core/core/server/services/stripe/services/webhook/subscription-event-service.js` | サブスク処理 |
| 2-3 | invoice-event-service.js | `ghost/core/core/server/services/stripe/services/webhook/invoice-event-service.js` | 請求書処理 |
| 2-4 | checkout-session-event-service.js | `ghost/core/core/server/services/stripe/services/webhook/checkout-session-event-service.js` | チェックアウト処理 |

#### Step 3: API層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stripe-api.js | `ghost/core/core/server/services/stripe/stripe-api.js` | Stripe API呼び出し |
| 3-2 | webhook-manager.js | `ghost/core/core/server/services/stripe/webhook-manager.js` | Webhook登録管理 |
| 3-3 | billing-portal-manager.js | `ghost/core/core/server/services/stripe/billing-portal-manager.js` | Billing Portal管理 |

### プログラム呼び出し階層図

```
StripeService
    │
    ├─ StripeAPI
    │      ├─ createCheckoutSession()
    │      ├─ createCustomer()
    │      ├─ updateSubscription()
    │      └─ getSubscription()
    │
    ├─ WebhookManager
    │      ├─ configure()
    │      ├─ start()
    │      └─ stop()
    │
    ├─ WebhookController
    │      ├─ handleWebhook()
    │      ├─ SubscriptionEventService
    │      ├─ InvoiceEventService
    │      └─ CheckoutSessionEventService
    │
    └─ BillingPortalManager
           ├─ configure()
           └─ start()
```

### データフロー図

```
[Stripe]                    [Ghost]                        [DB]

Webhook ──────────────▶ WebhookController
                              │
                              ├─ SubscriptionEventService ───▶ subscriptions
                              │
                              ├─ InvoiceEventService ────────▶ subscriptions
                              │                               members
                              └─ CheckoutSessionEventService ▶ customers
                                                              subscriptions

Checkout ◀────────────── StripeAPI
Session                       │
URL                          BillingPortalManager
                              │
Portal ◀──────────────────────┘
URL
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stripe-service.js | `ghost/core/core/server/services/stripe/stripe-service.js` | ソース | メインサービス |
| stripe-api.js | `ghost/core/core/server/services/stripe/stripe-api.js` | ソース | Stripe API呼び出し |
| webhook-controller.js | `ghost/core/core/server/services/stripe/webhook-controller.js` | ソース | Webhookハンドラ |
| webhook-manager.js | `ghost/core/core/server/services/stripe/webhook-manager.js` | ソース | Webhook登録管理 |
| billing-portal-manager.js | `ghost/core/core/server/services/stripe/billing-portal-manager.js` | ソース | Portal管理 |
| subscription-event-service.js | `ghost/core/core/server/services/stripe/services/webhook/subscription-event-service.js` | ソース | サブスク処理 |
| invoice-event-service.js | `ghost/core/core/server/services/stripe/services/webhook/invoice-event-service.js` | ソース | 請求書処理 |
| checkout-session-event-service.js | `ghost/core/core/server/services/stripe/services/webhook/checkout-session-event-service.js` | ソース | チェックアウト処理 |
| config.js | `ghost/core/core/server/services/stripe/config.js` | ソース | 設定管理 |
| stripe-migrations.js | `ghost/core/core/server/services/stripe/stripe-migrations.js` | ソース | マイグレーション |
