# 機能設計書 26-コメントモデレーション

## 概要

本ドキュメントは、Ghostのコメントモデレーション機能の設計仕様を記述する。コメントモデレーション機能は、管理者がサイト内のコメントを閲覧・管理し、不適切なコメントを非表示にしたり、報告されたコメントを確認したりするための機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：コメント機能を持つサイトでは、スパムや不適切なコンテンツが投稿される可能性がある。コメントモデレーション機能により、管理者はコミュニティの健全性を維持し、読者に安全な環境を提供できる。報告されたコメントの確認、コメントの非表示化、全サイトのコメント一覧表示などの機能を通じて、効率的なコンテンツ管理を実現する。

**機能の利用シーン**：
- 管理者が全サイトのコメントを一覧表示
- 報告件数でコメントをフィルタリング
- 不適切なコメントを非表示（hidden）に変更
- 非表示コメントを再公開（published）に復元
- 特定の投稿に関するコメントの管理

**主要な処理内容**：
1. 管理者向けコメント一覧取得（全サイト / 記事別）
2. コメントステータスの変更（published <-> hidden）
3. 報告件数によるフィルタリング
4. コメント返信の管理者向け取得
5. メンバー代理操作（impersonate_member_uuid）

**関連システム・外部連携**：
- Admin API
- Comment モデル

**権限による制御**：管理者権限が必要。一般メンバーはモデレーション機能にアクセスできない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コメント管理画面（Admin） | 主機能 | コメント一覧・モデレーション操作 |

## 機能種別

管理機能 / データ管理

## 入力仕様

### 入力パラメータ（コメント一覧）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| post_id | string | No | 特定記事のコメントに絞り込み | 存在する記事ID |
| filter | string | No | NQLフィルタ文字列 | 有効なNQL構文 |
| order | string | No | ソート順 | デフォルト: 'created_at desc' |
| page | number | No | ページ番号 | 1以上 |
| limit | number | No | 1ページあたりの件数 | 正の整数 |
| include_nested | boolean | No | 返信を含むか（フラットリスト） | true/false |
| impersonate_member_uuid | string | No | 代理操作するメンバーのUUID | 有効なUUID形式 |

### 入力パラメータ（ステータス変更）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | string | Yes | 対象コメントID | 存在するコメント |
| status | string | Yes | 新しいステータス | 'published' または 'hidden' |

### 入力データソース

- **comments テーブル**: コメントデータ
- **comment_reports テーブル**: 報告件数集計
- **members テーブル**: メンバー情報

## 出力仕様

### 出力データ（コメント一覧）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | string | コメントID |
| status | string | ステータス（published/hidden/deleted） |
| html | string | コメント本文 |
| created_at | datetime | 作成日時 |
| edited_at | datetime | 編集日時 |
| member | object | 投稿者情報（email含む） |
| post | object | 関連記事情報 |
| count.replies | number | 返信数 |
| count.likes | number | いいね数 |
| count.reports | number | 報告件数 |

### 出力先

- **comments テーブル**: ステータス更新
- **Admin API レスポンス**: コメント一覧・詳細

## 処理フロー

### 処理シーケンス（コメント一覧取得）

```
1. 管理者認証確認
   └─ permissions: true で Admin API 権限チェック

2. パラメータ解析
   └─ filter から count.reports を抽出（特殊処理）
   └─ mongoTransformer を生成

3. コメント取得
   └─ isAdmin: true フラグでクエリ
   └─ browseAll: true で全サイト取得 / post_id指定で記事別
   └─ hidden コメントを含む（deleted は除外）

4. 関連データ取得
   └─ member（メールアドレス含む）
   └─ post（タイトル、URL）
   └─ count.reports（報告件数）

5. レスポンス生成
   └─ commentMapper で出力形式に変換
```

### フローチャート

```mermaid
flowchart TD
    A[管理者リクエスト] --> B{権限チェック}
    B -->|No| C[403 Forbidden]
    B -->|Yes| D{browseAll?}
    D -->|Yes| E[全サイトコメント取得]
    D -->|No| F{post_id指定?}
    F -->|Yes| G[記事別コメント取得]
    F -->|No| H[エラー]
    E --> I[フィルタ適用]
    G --> I
    I --> J{count.reports filter?}
    J -->|Yes| K[報告件数でフィルタ]
    J -->|No| L[フィルタなし]
    K --> M[データ取得]
    L --> M
    M --> N[commentMapper変換]
    N --> O[レスポンス返却]

    subgraph ステータス変更
    P[ステータス変更リクエスト] --> Q{権限チェック}
    Q -->|No| R[403 Forbidden]
    Q -->|Yes| S[Comment.edit]
    S --> T[キャッシュ無効化]
    T --> U[更新完了]
    end
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-26-01 | 管理者専用 | モデレーション機能は管理者権限が必要 | 全操作 |
| BR-26-02 | hidden表示 | 管理者は hidden ステータスのコメントを閲覧可能 | コメント取得時 |
| BR-26-03 | deleted非表示 | deleted ステータスのコメントは管理者にも非表示 | コメント取得時 |
| BR-26-04 | ステータス制限 | ステータスは published/hidden のみ設定可能（deletedは論理削除のみ） | ステータス変更時 |
| BR-26-05 | 代理操作 | impersonate_member_uuid で特定メンバーのいいね状態を確認可能 | 一覧取得時 |
| BR-26-06 | 報告件数フィルタ | count.reports で報告されたコメントを効率的にフィルタ | 一覧取得時 |

### 計算ロジック

**報告件数のカウント**：
- comment_reports テーブルの該当コメントに対するレコード数をサブクエリでカウント
- フィルタ演算子: =, >, >=, <, <=, != をサポート

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| コメント一覧 | comments | SELECT | 管理者向けコメント取得 |
| ステータス変更 | comments | UPDATE | status カラムの更新 |
| 報告件数取得 | comment_reports | SELECT | COUNT集計 |

### テーブル別操作詳細

#### comments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | status != 'deleted' | 管理者は hidden も取得 |
| SELECT | count__reports | サブクエリでカウント | comment_reports からカウント |
| UPDATE | status | 'published' or 'hidden' | 管理者のみ実行可能 |
| UPDATE | updated_at | 現在日時 | 自動更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 403 | Forbidden | 管理者権限がない | ログインを促す |
| - | ValidationError | post_id が必須の場面で未指定 | エラーメッセージを返却 |
| - | NotFoundError | 指定されたコメントが存在しない | エラーメッセージを返却 |

### リトライ仕様

- 特になし

## トランザクション仕様

- ステータス変更は単一レコード操作のため、暗黙的トランザクション

## パフォーマンス要件

- コメント一覧取得: ページネーション対応
- 報告件数フィルタ: サブクエリによる効率的なフィルタリング

## セキュリティ考慮事項

- Admin API権限による厳格なアクセス制御
- メンバーのメールアドレスは管理者にのみ表示
- キャッシュ無効化ヘッダーによる整合性確保

## 備考

- status の値: 'published', 'hidden', 'deleted'
- hidden と deleted の違い：
  - hidden: 管理者が非表示にした状態（管理者は閲覧可能）
  - deleted: ユーザーまたはシステムが削除した状態（誰も閲覧不可）
- labs フラグ 'commentModeration' で一部機能が制御される可能性あり

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | schema.js | `ghost/core/core/server/data/schema/schema.js` | comments テーブル（973-984行）の status カラム |
| 1-2 | comments.js (mapper) | `ghost/core/core/server/api/endpoints/utils/serializers/output/mappers/comments.js` | 管理者向け出力フィールド（27-34行、49-53行） |

**読解のコツ**: 管理者向けにはメンバーのemail、count.reportsが追加される。status が 'hidden' でも管理者は html を取得可能。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | comments.js (endpoints) | `ghost/core/core/server/api/endpoints/comments.js` | Admin API エンドポイント定義 |
| 2-2 | comments-controller.js | `ghost/core/core/server/services/comments/comments-controller.js` | コントローラーロジック |

**主要処理フロー**:
1. **47-72行目** (endpoints): edit - ステータス変更
2. **73-100行目** (endpoints): browse - 記事別コメント取得
3. **101-120行目** (endpoints): browseAll - 全サイトコメント取得
4. **115-142行目** (controller): adminBrowse - 管理者向けコメント取得
5. **153-170行目** (controller): adminBrowseAll - 全サイト向け取得

#### Step 3: フィルタ処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | comments-controller.js | `ghost/core/core/server/services/comments/comments-controller.js` | #extractReportCountFilter（51-89行） |
| 3-2 | comment.js | `ghost/core/core/server/models/comment.js` | applyCustomQuery（61-87行）、countRelations（251-296行） |

**主要処理フロー**:
- **51-89行目**: #extractReportCountFilter() - count.reports フィルタの抽出と変換
- **61-87行目**: applyCustomQuery() - browseAll 時のステータスフィルタ、reportCount フィルタ適用
- **287-294行目**: countRelations.reports() - 報告件数のサブクエリ生成

### プログラム呼び出し階層図

```
Admin API
    │
    ├─ comments.edit (Admin Endpoint)
    │      │
    │      ├─ permissions: true (Admin権限チェック)
    │      │
    │      └─ Comment.edit({status})
    │             └─ handleCacheHeaders()
    │
    ├─ comments.browse (Admin Endpoint)
    │      │
    │      ├─ permissions: true
    │      │
    │      └─ CommentsController.adminBrowse(frame)
    │             ├─ #setImpersonationContext()
    │             └─ CommentsService.getAdminComments()
    │                    └─ Comment.findPage({isAdmin: true})
    │
    └─ comments.browseAll (Admin Endpoint)
           │
           ├─ permissions: {method: 'browse'}
           │
           └─ CommentsController.adminBrowseAll(frame)
                  │
                  ├─ #extractReportCountFilter()
                  │      └─ nql.parse() → splitFilter()
                  │
                  └─ CommentsService.getAdminAllComments()
                         └─ Comment.findPage({
                                isAdmin: true,
                                browseAll: true,
                                reportCount
                            })
```

### データフロー図

```
[入力]                     [処理]                          [出力]

filter (NQL) ────────────▶ #extractReportCountFilter()
                                 │
                                 ├─ count.reports 抽出
                                 │
                                 └─ reportCount オプション生成
                                 │
                                 ▼
                          Comment.findPage()
                                 │
                                 ├─ applyCustomQuery()
                                 │      ├─ status フィルタ
                                 │      └─ reportCount フィルタ
                                 │
                                 ├─ countRelations.reports()
                                 │      └─ サブクエリ: COUNT(comment_reports)
                                 │
                                 └─ withRelated: ['member', 'post', ...]
                                 │
                                 ▼
                          commentMapper() ───────────────▶ Admin JSON Response
                                 │
                                 ├─ memberFieldsAdmin (email含む)
                                 │
                                 └─ countFieldsAdmin (reports含む)

[ステータス変更フロー]

id, status ──────────────▶ Comment.edit()
                                 │
                                 └─ UPDATE comments SET status = ?
                                 │
                                 ▼
                          handleCacheHeaders() ───────────▶ X-Cache-Invalidate
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| comments.js | `ghost/core/core/server/api/endpoints/comments.js` | API | Admin API エンドポイント |
| comments-controller.js | `ghost/core/core/server/services/comments/comments-controller.js` | コントローラー | リクエスト処理 |
| comments-service.js | `ghost/core/core/server/services/comments/comments-service.js` | サービス | ビジネスロジック |
| comment.js | `ghost/core/core/server/models/comment.js` | モデル | データアクセス |
| comments.js (mapper) | `ghost/core/core/server/api/endpoints/utils/serializers/output/mappers/comments.js` | シリアライザー | 出力変換 |
| schema.js | `ghost/core/core/server/data/schema/schema.js` | 設定 | DBスキーマ定義 |
