# 機能設計書 36-ソーシャルメディア連携

## 概要

本ドキュメントは、Ghostのソーシャルメディア連携機能に関する設計仕様を定義する。この機能により、サイト管理者はTwitter/Facebookなどのソーシャルメディアアカウント情報を設定し、サイトやユーザープロフィールに連携できる。

### 本機能の処理概要

ソーシャルメディア連携は、サイト全体およびユーザー（スタッフ）個人のソーシャルメディアアカウント情報を管理する機能である。設定されたアカウント情報は、OGPタグやJSON-LDなどのメタデータとしてサイトに出力される。

**業務上の目的・背景**：サイトのソーシャルメディアプレゼンスを確立し、訪問者がサイト運営者や著者のソーシャルメディアアカウントを容易に見つけられるようにする。また、OGPタグを通じてコンテンツがソーシャルメディアで適切に表示されるよう制御する。

**機能の利用シーン**：
- サイトの公式Twitter/Facebookアカウントを設定する場合
- 記事著者の個人ソーシャルメディアアカウントを表示する場合
- ソーシャルシェア時の表示を最適化する場合
- サイトのブランディングを強化する場合

**主要な処理内容**：
1. サイトレベルのソーシャルアカウント設定（Settings API経由）
2. ユーザーレベルのソーシャルアカウント設定（Users API経由）
3. テーマテンプレートでのアカウント情報表示
4. OGPメタタグへの反映

**関連システム・外部連携**：
- Settings API：サイト全体のソーシャルアカウント管理
- Users API：ユーザー個別のソーシャルアカウント管理
- ghost_headヘルパー：OGPタグの出力

**権限による制御**：サイト設定は管理者（Administrator）以上が編集可能。ユーザー設定は自分自身のプロフィールのみ編集可能（一部上位ロールは他者編集可）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 38 | ソーシャルアカウント設定 | 主画面 | Twitter/Facebookアカウントの設定 |

## 機能種別

設定管理 / メタデータ出力

## 入力仕様

### 入力パラメータ（サイト設定）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| facebook | String | No | FacebookページURL/ハンドル | 文字列 |
| twitter | String | No | Twitterハンドル（@付き） | 文字列 |

### 入力パラメータ（ユーザー設定）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| facebook | String | No | FacebookプロフィールURL | 最大2000文字 |
| twitter | String | No | Twitterハンドル | 最大2000文字 |
| threads | String | No | Threadsハンドル | 最大191文字 |
| bluesky | String | No | Blueskyハンドル | 最大191文字 |
| mastodon | String | No | MastodonプロフィールURL | 文字列 |
| youtube | String | No | YouTubeチャンネルURL | 文字列 |
| linkedin | String | No | LinkedInプロフィールURL | 文字列 |
| instagram | String | No | Instagramハンドル | 文字列 |
| tiktok | String | No | TikTokハンドル | 文字列 |

### 入力データソース

- 管理画面（Ghost Admin > Settings > Social accounts）
- 管理画面（ユーザープロフィール編集）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| facebook | String | Facebookアカウント情報 |
| twitter | String | Twitterアカウント情報 |
| その他SNS | String | 各種ソーシャルメディアアカウント |

### 出力先

- settingsテーブル（サイト設定）
- usersテーブル（ユーザー設定）
- HTMLメタタグ（OGP、Twitter Cards等）
- テーマテンプレート

## 処理フロー

### 処理シーケンス

```
1. サイト設定更新
   └─ Settings API edit呼び出し
   └─ settingsテーブル更新
   └─ settingsキャッシュ更新

2. ユーザー設定更新
   └─ Users API edit呼び出し
   └─ usersテーブル更新

3. フロントエンド表示
   └─ テーマテンプレートで@site.facebookなどを参照
   └─ ghost_headでOGPタグ出力
```

### フローチャート

```mermaid
flowchart TD
    A[ソーシャル設定入力] --> B{サイト or ユーザー?}
    B -->|サイト| C[Settings API edit]
    B -->|ユーザー| D[Users API edit]
    C --> E[settingsテーブル更新]
    D --> F[usersテーブル更新]
    E --> G[settingsキャッシュ更新]
    F --> H[完了]
    G --> H

    I[ページ表示] --> J[テーマレンダリング]
    J --> K[ソーシャルアカウント情報取得]
    K --> L[HTMLに出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-36-01 | デフォルト値 | サイトfacebookは"ghost"、twitterは"@ghost" | 初期設定時 |
| BR-36-02 | Twitter形式 | Twitterハンドルは@付きで保存推奨 | Twitter設定時 |
| BR-36-03 | キャッシュ無効化 | ソーシャル設定変更時はサイトキャッシュを無効化 | 設定更新時 |

### 計算ロジック

特になし（文字列の保存・出力）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| サイト設定取得 | settings | SELECT | facebook, twitter設定の取得 |
| サイト設定更新 | settings | UPDATE | facebook, twitter設定の更新 |
| ユーザー設定取得 | users | SELECT | ユーザーのソーシャルアカウント取得 |
| ユーザー設定更新 | users | UPDATE | ユーザーのソーシャルアカウント更新 |

### テーブル別操作詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | value | key = 'facebook' / 'twitter' | サイト設定 |
| UPDATE | value | ユーザー入力値 | サイト設定 |

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | facebook, twitter, threads, bluesky等 | id = {user_id} | ユーザー設定 |
| UPDATE | facebook, twitter, threads, bluesky等 | ユーザー入力値 | ユーザー設定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ValidationError | 長さ制限超過 | バリデーションエラーを返却 |
| 403 | NoPermissionError | 権限なしでの編集試行 | 適切な権限で再試行 |

### リトライ仕様

リトライは不要。

## トランザクション仕様

- 設定更新は単一レコードの更新のため、標準的なトランザクション制御

## パフォーマンス要件

- 設定値はsettingsキャッシュに保存され、高速参照可能

## セキュリティ考慮事項

- ソーシャルメディアアカウント情報は公開情報として扱われる
- 管理者権限のチェック

## 備考

- デフォルトのfacebook/twitterはGhost公式アカウント
- ユーザーは複数のソーシャルメディアプラットフォーム（Threads, Bluesky, Mastodon, YouTube, LinkedIn, Instagram, TikTok）に対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ソーシャルメディア設定のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | default-settings.json | `ghost/core/core/server/data/schema/default-settings/default-settings.json` | **145-152行目**: facebook, twitter設定（デフォルト値 "ghost", "@ghost"） |
| 1-2 | schema.js | `ghost/core/core/server/data/schema/schema.js` | **135-138行目**: usersテーブルのfacebook, twitter, threads, blueskyカラム定義 |

**読解のコツ**:
- サイト設定はsettingsテーブル、ユーザー設定はusersテーブルに保存される
- ユーザー設定は複数のSNSプラットフォームに対応

#### Step 2: Users モデルを理解する

ユーザーのソーシャルアカウント管理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | user.js | `ghost/core/core/server/models/user.js` | ユーザーモデルの構造 |
| 2-2 | users.js | `ghost/core/core/server/api/endpoints/users.js` | **43-67行目**: ソーシャルアカウントフィールドがキャッシュ無効化の対象 |

**主要処理フロー**:
1. **46-67行目**: publicAttrs配列にfacebook, twitter等が含まれる
2. これらのフィールドが変更されるとキャッシュ無効化

### プログラム呼び出し階層図

```
[サイト設定]
Settings API edit
    │
    └─ settingsBREADService.edit()
           │
           └─ Settings Model
                  └─ settings table UPDATE (facebook, twitter)

[ユーザー設定]
Users API edit
    │
    └─ User Model.edit()
           │
           ├─ users table UPDATE
           │
           └─ shouldInvalidateCacheAfterChange()
                  └─ publicAttrs にfacebook, twitter等が含まれる場合キャッシュ無効化

[フロントエンド]
テーマテンプレート
    │
    ├─ @site.facebook / @site.twitter
    │      └─ settingsCache参照
    │
    └─ @author.facebook / @author.twitter
           └─ ユーザーモデル参照
```

### データフロー図

```
[入力]                    [処理]                           [出力]

管理画面入力 ───────▶ Settings/Users API edit
                              │
                              ▼
                        バリデーション
                              │
                              ▼
                        DB更新 (settings/users)
                              │
                              ▼
                        キャッシュ更新
                              │
                              │
テーマレンダリング ────▶ @site/@author参照
                              │
                              ▼
                        HTML出力 (OGPタグ等)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| default-settings.json | `ghost/core/core/server/data/schema/default-settings/default-settings.json` | 設定 | サイトソーシャル設定のデフォルト値 |
| schema.js | `ghost/core/core/server/data/schema/schema.js` | 設定 | usersテーブルのソーシャルカラム定義 |
| settings.js | `ghost/core/core/server/models/settings.js` | ソース | Settingsモデル |
| user.js | `ghost/core/core/server/models/user.js` | ソース | Userモデル |
| users.js | `ghost/core/core/server/api/endpoints/users.js` | ソース | Users APIエンドポイント |
| settings.js | `ghost/core/core/server/api/endpoints/settings.js` | ソース | Settings APIエンドポイント |
