# 機能設計書 4-コレクション管理

## 概要

本ドキュメントは、Ghost CMSにおけるコレクション機能について、その設計仕様を記載する。コレクション管理機能は、記事をグループ化して管理・表示するための機能を提供する。

### 本機能の処理概要

コレクション管理機能は、複数の記事を論理的にグループ化するコレクションを管理する機能である。コレクションには「自動コレクション」と「手動コレクション」の2種類があり、自動コレクションはフィルタ条件に基づいて記事を自動的に収集し、手動コレクションは管理者が明示的に記事を追加・並び替える。

**業務上の目的・背景**：従来のタグ機能だけでは、記事の柔軟なグループ化や表示順序の制御が難しい場合がある。コレクション機能により、「人気記事」「編集者のおすすめ」「シリーズ記事」などの概念を実現し、サイトのナビゲーションやコンテンツ発見を向上させることができる。

**機能の利用シーン**：
- 編集者が「今週のおすすめ」コレクションを作成し、注目記事を手動で選定する
- 管理者が「人気記事」コレクションを作成し、閲覧数の多い記事を自動収集する
- デザイナーがトップページに表示するコレクションを設定する
- マーケティング担当者がキャンペーン用のコレクションを作成する

**主要な処理内容**：
1. コレクションの作成・編集・削除
2. 自動コレクション：フィルタ条件に基づく記事の自動収集
3. 手動コレクション：記事の追加・削除・並び替え
4. コレクションのメタデータ管理（名前、スラッグ、説明、画像など）

**関連システム・外部連携**：
- 記事管理機能との連携（collections_postsテーブル経由）
- テーマテンプレートシステム（コレクションの表示）

**権限による制御**：
- Owner/Administrator/Editor: コレクションの作成・編集・削除が可能
- Author/Contributor: コレクションの閲覧のみ可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 現時点で専用管理画面は確認できず |

## 機能種別

CRUD操作 / データ連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| title | string | Yes | コレクション名 | - |
| slug | string | No | URLスラッグ | 一意制約 |
| description | string | No | コレクションの説明 | - |
| type | string | Yes | コレクションタイプ | automatic/manual |
| filter | string | No | 自動コレクションのフィルタ条件 | NQL形式 |
| feature_image | string | No | アイキャッチ画像URL | 有効なURL |
| posts | array | No | 手動コレクションの記事リスト | 記事IDの配列 |

### 入力データソース

- 管理画面（Ghost Admin）からのフォーム入力
- Admin APIを通じた外部クライアントからのリクエスト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | string | コレクションの一意識別子 |
| title | string | コレクション名 |
| slug | string | URLスラッグ |
| description | string | コレクションの説明 |
| type | string | コレクションタイプ |
| filter | string | フィルタ条件（自動コレクションの場合） |
| feature_image | string | アイキャッチ画像URL |
| posts | array | 関連記事一覧 |
| created_at | datetime | 作成日時 |
| updated_at | datetime | 更新日時 |

### 出力先

- APIレスポンス（JSON形式）
- データベース（collectionsテーブル、collections_postsテーブル）

## 処理フロー

### 処理シーケンス

```
1. APIリクエスト受信
   └─ リクエストパラメータのバリデーション
2. 権限チェック
   └─ ユーザーロールの確認
3. コレクションタイプ判定
   └─ automatic: フィルタ条件を保存
   └─ manual: 記事の関連付けを処理
4. データベース操作
   └─ collectionsテーブルへの挿入/更新/削除
   └─ collections_postsテーブルへの関連レコード管理
5. 並び順の更新（手動コレクションの場合）
   └─ sort_orderの更新
6. レスポンス返却
   └─ コレクションデータをJSON形式で返却
```

### フローチャート

```mermaid
flowchart TD
    A[APIリクエスト受信] --> B{権限チェック}
    B -->|権限なし| C[403エラー]
    B -->|権限あり| D{コレクションタイプ}
    D -->|automatic| E[フィルタ条件保存]
    D -->|manual| F[記事関連付け処理]
    E --> G[DB保存]
    F --> H[並び順更新]
    H --> G
    G --> I[レスポンス返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | タイプ制約 | コレクションタイプはautomaticまたはmanualのみ | 全コレクション作成時 |
| BR-002 | 自動収集 | type=automaticの場合、filterに基づいて記事が自動収集される | 自動コレクション |
| BR-003 | 手動管理 | type=manualの場合、記事の追加・削除・並び替えは手動で行う | 手動コレクション |
| BR-004 | 並び順保持 | 手動コレクションでは記事の並び順がsort_orderで管理される | 手動コレクション |

### 計算ロジック

- **自動コレクションの記事収集**: filterに指定されたNQL条件を評価し、マッチする記事を動的に取得する
- **手動コレクションの並び順**: collections_postsテーブルのsort_order列で管理される

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| コレクション作成 | collections | INSERT | 新規コレクションレコードの挿入 |
| コレクション更新 | collections | UPDATE | コレクションデータの更新 |
| 記事追加（手動） | collections_posts | INSERT | 記事との関連レコード挿入 |
| 記事削除（手動） | collections_posts | DELETE | 記事との関連レコード削除 |
| コレクション削除 | collections_posts | DELETE | 関連レコードの削除 |
| コレクション削除 | collections | DELETE | コレクションレコードの削除 |

### テーブル別操作詳細

#### collections

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | id | 自動生成 | |
| INSERT | title | リクエスト値 | 必須 |
| INSERT | slug | リクエスト値または自動生成 | 一意制約 |
| INSERT | type | リクエスト値 | automatic/manual |
| INSERT | filter | リクエスト値 | 自動コレクションの場合 |

#### collections_posts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | collection_id | 対象コレクションID | |
| INSERT | post_id | 追加する記事ID | |
| INSERT | sort_order | 並び順インデックス | 0から開始 |
| UPDATE | sort_order | 新しい並び順 | 並び替え時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | ValidationError | 必須パラメータが不足 | 必須パラメータを指定 |
| 400 | ValidationError | 不正なタイプ指定 | automatic/manualを指定 |
| 403 | NoPermissionError | 権限不足 | 適切な権限を持つユーザーで実行 |
| 404 | NotFoundError | コレクションが存在しない | 正しいIDを指定 |

### リトライ仕様

特別なリトライ処理は実装されていない。

## トランザクション仕様

コレクションの削除時は、collections_postsテーブルとcollectionsテーブルへの操作が順次実行される。

## パフォーマンス要件

- コレクション一覧取得: 500ms以内
- コレクション作成・更新・削除: 500ms以内

## セキュリティ考慮事項

- 認証: Ghost Admin SessionまたはAdmin API Key認証が必要
- 認可: Editor以上のロールでのみ作成・編集・削除可能

## 備考

- コレクション機能は比較的新しい機能であり、現時点では専用のAdmin APIエンドポイントは確認できなかった
- モデル層（collection.js）での基本的なCRUD操作と記事との関連付けは実装されている
- 今後のバージョンでAPIエンドポイントが追加される可能性がある

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

コレクションのモデル定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | collection.js | `ghost/core/core/server/models/collection.js` | Collectionモデルの全体構造 |

**主要処理フロー**:
- **5行目**: テーブル名 'collections'
- **7-38行目**: hooksでbelongsToManyの後処理（並び順更新）
- **40-45行目**: formatOnWriteでfeature_imageのURL変換
- **57-66行目**: relationships定義（posts）
- **75-85行目**: filterRelations定義（postsとのmanyToMany関係）
- **97-106行目**: posts()リレーション定義（collections_posts経由）

**読解のコツ**: hooks.belongsToMany.afterメソッドで、type='automatic'の場合は並び順更新をスキップしている点に注目。

### プログラム呼び出し階層図

```
Collection Model (collection.js)
    │
    ├─ posts() - belongsToMany relation
    │      └─ collections_posts テーブル経由
    │
    ├─ collectionPosts() - hasMany relation
    │      └─ CollectionPost モデル
    │
    └─ hooks.belongsToMany.after
           └─ type='manual'の場合のみ並び順更新
```

### データフロー図

```
[入力]                    [処理]                           [出力]

Collection Data
       │
       ▼
┌─────────────────┐
│ Collection Model│
└────────┬────────┘
         │
         ▼
┌─────────────────┐    ┌─────────────────────┐
│ collections     │───▶│ collections_posts   │
│ テーブル         │    │ テーブル（関連）      │
└─────────────────┘    └─────────────────────┘
                                │
                                ▼
                       ┌─────────────────┐
                       │ posts テーブル   │
                       │ (記事データ)     │
                       └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| collection.js | `ghost/core/core/server/models/collection.js` | モデル | Collectionモデル定義 |
| schema.js | `ghost/core/core/server/data/schema/schema.js` | スキーマ | DBスキーマ定義 |
