# 機能設計書 65-データベース管理

## 概要

本ドキュメントは、Ghost CMSにおけるデータベース管理機能の設計を記述する。この機能は、データベースのバックアップ、エクスポート、インポート、コンテンツ削除などのデータベース操作を提供する。

### 本機能の処理概要

この機能では、Ghost管理者がサイトコンテンツのバックアップ取得、JSONエクスポート、他サイトからのインポート、全コンテンツ削除などを行うことができる。

**業務上の目的・背景**：サイト運営において、データのバックアップ・移行・リセットは不可欠な操作である。この機能により、サイトデータの保護、他環境への移行、テスト用データのリセットなどが可能になる。

**機能の利用シーン**：
- サイト移行前のデータエクスポート
- 定期バックアップの取得
- 他プラットフォームからのデータインポート
- 開発/テスト環境のデータリセット

**主要な処理内容**：
1. データベースバックアップ作成（backupContent）
2. JSONフォーマットでのエクスポート（exportContent）
3. ファイルからのインポート（importContent）
4. 外部メディアのインライン化（inlineMedia）
5. 全コンテンツの削除（deleteAllContent）

**関連システム・外部連携**：ファイルシステム、ストレージアダプター、メール配信サービス

**権限による制御**：全操作に管理者権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 59 | マイグレーションツール | 主機能 | データのインポート・エクスポート処理 |
| 63 | 危険ゾーン | 主機能 | サイト削除等の危険な操作 |
| 76 | マイグレーション画面 | 主機能 | 他プラットフォームからのデータ移行 |

## 機能種別

データ管理 / バッチ処理

## 入力仕様

### 入力パラメータ（backupContent）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| include | array | No | 含めるテーブル | BACKUP_TABLESの値のみ |
| filename | string | No | ファイル名 | - |

### 入力パラメータ（exportContent）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| include | array | No | 含めるテーブル | BACKUP_TABLESの値のみ |
| filename | string | No | 既存バックアップファイル名 | - |

### 入力パラメータ（importContent）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| file | File | Yes | インポートファイル（ZIP/JSON） | - |

### 入力パラメータ（inlineMedia）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| domains | array | Yes | 対象ドメインリスト | - |

### 入力データソース

- データベース全テーブル
- アップロードファイル（ZIP/JSON）
- content/data ディレクトリ

## 出力仕様

### 出力データ（exportContent）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| meta.exported_on | number | エクスポート日時（タイムスタンプ） |
| meta.version | string | Ghostバージョン |
| data | object | テーブル別データ |

### 出力先

- content/data ディレクトリ（バックアップ）
- HTTPレスポンス（エクスポート）
- データベース（インポート）

## 処理フロー

### 処理シーケンス（importContent）

```
1. ファイル受信
   └─ ZIP/JSON形式のファイルを受け取る

2. ファイル処理
   ├─ ZIP: 解凍してハンドラーに振り分け
   └─ JSON: JSONハンドラーで処理

3. 前処理（preProcess）
   └─ 各インポーターがデータ変換

4. インポート実行（doImport）
   └─ 各インポーターがデータ挿入

5. レポート生成
   └─ インポート結果をまとめる

6. クリーンアップ
   └─ 一時ファイル削除

7. 完了通知
   └─ メールで結果を通知
```

### フローチャート

```mermaid
flowchart TD
    A[importContent開始] --> B{ZIPファイル?}
    B -->|Yes| C[ZIP解凍]
    B -->|No| D[ファイル処理]
    C --> E[ハンドラー振り分け]
    D --> E
    E --> F[preProcess]
    F --> G[doImport]
    G --> H[generateReport]
    H --> I[cleanUp]
    I --> J[完了メール送信]
    J --> K[終了]
```

### フローチャート（deleteAllContent）

```mermaid
flowchart TD
    A[deleteAllContent開始] --> B[バックアップ作成]
    B --> C[トランザクション開始]
    C --> D[全Post取得]
    D --> E[Post一括削除]
    E --> F[全Tag取得]
    F --> G[Tag一括削除]
    G --> H[トランザクション完了]
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 削除前バックアップ | deleteAllContent実行前に自動バックアップ | deleteAllContent時 |
| BR-02 | バックアップ無効化 | disableJSBackups設定でバックアップスキップ可能 | 大規模サイト向け |
| BR-03 | インポートタグ付与 | インポートしたコンテンツに自動タグ付与 | importContent時 |
| BR-04 | ブロックリスト適用 | 設定キーのブロックリスト除外 | export時 |
| BR-05 | 非同期インポート | 大量データはジョブとして実行 | importContent時（本番環境） |

### 計算ロジック

ファイル名生成: `Ghost.{siteName}.{timestamp}.json`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| backupContent | 全テーブル | SELECT | データ読み取り |
| exportContent | 全テーブル | SELECT | データ読み取り |
| importContent | posts, tags, users等 | INSERT/UPDATE | データ挿入・更新 |
| deleteAllContent | posts, tags | DELETE | データ削除 |

### テーブル別操作詳細

#### posts（deleteAllContent）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | 全件取得 | columns: 'id'で高速化 |
| DELETE | - | 全件削除 | pool(100)で並列実行 |

#### tags（deleteAllContent）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | 全件取得 | columns: 'id'で高速化 |
| DELETE | - | 全件削除 | pool(100)で並列実行 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | NotFoundError | 指定バックアップファイルが存在しない | 404エラーを返却 |
| - | DataExportError | エクスポート処理失敗 | エラーログ出力 |
| - | UnsupportedMediaTypeError | 無効なZIP構造 | エラーメッセージで原因を通知 |
| INVALID_ZIP_FILE_NAME_ENCODING | UnsupportedMediaTypeError | ZIPファイル名エンコードエラー | MacOS特有の問題を説明 |

### リトライ仕様

インポート失敗時はジョブとしてリトライせず、エラーメールで通知

## トランザクション仕様

deleteAllContent: 単一トランザクションで全Post/Tag削除を実行

## パフォーマンス要件

- 削除処理: pool(100)で100件並列処理
- インポート: ジョブマネージャーでバックグラウンド実行
- エクスポート: columns指定で必要最小限のデータ取得

## セキュリティ考慮事項

- Admin API経由のアクセスには管理者権限が必要
- settings のブロックリストキーはエクスポートから除外
- バックアップファイルはcontent/dataディレクトリに保存

## 備考

- disableJSBackups設定は大規模サイトのメモリ対策
- インポート完了時は自動でメール通知される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: APIエンドポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | db.js | `ghost/core/core/server/api/endpoints/db.js` | 各APIメソッドの定義 |

**読解のコツ**: Controller形式のAPI定義。各メソッドのvalidation、permissions、queryを確認。

**主要処理フロー**:
- **15-36行目**: backupContent - バックアップ作成
- **39-77行目**: exportContent - JSONエクスポート
- **79-109行目**: importContent - ファイルインポート
- **111-128行目**: inlineMedia - メディアインライン化
- **130-174行目**: deleteAllContent - 全削除

#### Step 2: バックアップ処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | backup.js | `ghost/core/core/server/data/db/backup.js` | バックアップファイル処理 |

**主要処理フロー**:
- **16-21行目**: writeExportFile - ファイル書き込み
- **26-39行目**: readBackup - ファイル読み込み
- **47-66行目**: backup - メイン処理

#### Step 3: エクスポート処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | exporter.js | `ghost/core/core/server/data/exporter/exporter.js` | エクスポートロジック |

**主要処理フロー**:
- **18-25行目**: exportTable - テーブル単位エクスポート
- **27-31行目**: getSettingsTableData - 設定ブロックリスト適用
- **33-68行目**: doExport - メイン処理

#### Step 4: インポート処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | import-manager.js | `ghost/core/core/server/data/importer/import-manager.js` | インポートマネージャー |

**主要処理フロー**:
- **56-113行目**: コンストラクタ - ハンドラー/インポーター初期化
- **220-252行目**: extractZip - ZIP解凍
- **304-340行目**: processZip - ZIP処理
- **381-385行目**: loadFile - ファイル読み込み
- **494-552行目**: importFromFile - メインエントリポイント

### プログラム呼び出し階層図

```
db.js (API Endpoint)
    │
    ├─ backupContent
    │      └─ dbBackup.backup()
    │              └─ exporter.doExport()
    │              └─ writeExportFile()
    │
    ├─ exportContent
    │      ├─ dbBackup.readBackup()（filename指定時）
    │      └─ exporter.doExport()（通常時）
    │
    ├─ importContent
    │      └─ importer.importFromFile()
    │              ├─ loadFile()
    │              │      ├─ processZip()
    │              │      └─ processFile()
    │              ├─ preProcess()
    │              ├─ doImport()
    │              ├─ generateReport()
    │              └─ cleanUp()
    │
    └─ deleteAllContent
           ├─ dbBackup.backup()
           └─ transaction
                  ├─ Post.findAll() → Post.destroy()
                  └─ Tag.findAll() → Tag.destroy()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

データベース ──────▶ doExport() ──────────▶ JSONファイル
                          │                    │
                          ▼                    ▼
                    writeExportFile() ──▶ content/data/

ZIP/JSONファイル ──▶ importFromFile() ──▶ データベース
                          │
                          ├─ preProcess()
                          └─ doImport()
                                │
                                ▼
                          完了メール送信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| db.js | `ghost/core/core/server/api/endpoints/db.js` | ソース | APIエンドポイント |
| backup.js | `ghost/core/core/server/data/db/backup.js` | ソース | バックアップ処理 |
| exporter.js | `ghost/core/core/server/data/exporter/exporter.js` | ソース | エクスポートロジック |
| index.js | `ghost/core/core/server/data/exporter/index.js` | ソース | エクスポーターエクスポート |
| import-manager.js | `ghost/core/core/server/data/importer/import-manager.js` | ソース | インポートマネージャー |
| json.js | `ghost/core/core/server/data/importer/handlers/json.js` | ソース | JSONハンドラー |
| image.js | `ghost/core/core/server/data/importer/handlers/image.js` | ソース | 画像ハンドラー |
| data-importer.js | `ghost/core/core/server/data/importer/importers/data/data-importer.js` | ソース | データインポーター |
