# 機能設計書 66-ジョブ管理

## 概要

本ドキュメントは、Ghost CMSにおけるジョブ管理機能の設計を記述する。この機能は、バックグラウンドジョブのスケジューリング、実行、監視を行うための機能である。

### 本機能の処理概要

この機能では、定期実行ジョブ、遅延実行ジョブ、非同期処理などを統一的に管理し、メインプロセスをブロックせずに重い処理を実行することができる。

**業務上の目的・背景**：Ghost CMSでは、メール配信、更新チェック、インポート処理など、時間のかかる処理が多数存在する。これらをメインリクエスト処理とは別に実行することで、ユーザー体験を損なわずに処理を完了させる必要がある。

**機能の利用シーン**：
- ニュースレター配信のバックグラウンド処理
- 定期的な更新チェック
- データインポートの非同期処理
- スケジュール投稿の公開処理

**主要な処理内容**：
1. ジョブの追加（addJob）
2. インラインキューでの実行管理
3. Breeによるスケジュール実行
4. ワーカースレッドでの並列実行
5. ジョブ状態の監視
6. エラーハンドリングとSentry連携

**関連システム・外部連携**：Sentry（エラー監視）、DomainEvents

**権限による制御**：内部処理のため、直接的な権限制御は適用されない

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | バックグラウンド処理のため関連画面なし |

## 機能種別

システム基盤 / バッチ処理

## 入力仕様

### 入力パラメータ（addJob）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| job | Function/string | Yes | 実行するジョブ（関数またはファイルパス） | - |
| name | string | No | ジョブ名 | - |
| at | string | No | cron式またはDate（スケジュール実行時） | - |
| offloaded | boolean | No | ワーカースレッド実行フラグ（default: true） | - |
| data | object | No | ジョブに渡すデータ | - |

### 入力データソース

- アプリケーション内からの呼び出し
- 設定ファイル（スケジュール定義）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| job.id | string | ジョブID |
| job.status | string | ジョブ状態 |
| job.result | any | 実行結果 |

### 出力先

- ジョブキュー
- ログ出力
- Sentry（エラー時）
- DomainEvents

## 処理フロー

### 処理シーケンス

```
1. ジョブ登録
   ├─ インラインジョブ: inlineQueueに追加
   └─ スケジュールジョブ: bree.addに追加

2. ジョブ実行
   ├─ インライン: async-queue-managerで順次実行
   └─ スケジュール: Breeがワーカースレッドで実行

3. 結果処理
   ├─ 成功: ログ出力、DomainEvents発行
   └─ 失敗: エラーログ、Sentry送信

4. 後処理
   └─ ジョブ完了イベント発行
```

### フローチャート

```mermaid
flowchart TD
    A[addJob呼び出し] --> B{offloaded?}
    B -->|Yes| C{at指定あり?}
    B -->|No| D[inlineQueueに追加]
    C -->|Yes| E[Bree schedule追加]
    C -->|No| F[Bree即時実行追加]
    E --> G[スケジュール時刻待機]
    F --> H[ワーカースレッド起動]
    G --> H
    D --> I[キュー順次実行]
    H --> J{実行成功?}
    I --> J
    J -->|Yes| K[完了ログ出力]
    J -->|No| L[エラーハンドリング]
    L --> M[Sentry送信]
    K --> N[終了]
    M --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | インラインデフォルト | offloaded=falseの場合はインラインキューで実行 | offloaded未指定時 |
| BR-02 | ワーカー分離 | offloaded=trueの場合はワーカースレッドで実行 | 重い処理時 |
| BR-03 | エラー通知 | ワーカーエラーは自動的にSentryに送信 | エラー発生時 |
| BR-04 | メッセージログ | ワーカーからのメッセージはログに出力 | ワーカー通信時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ジョブ記録 | jobs | INSERT/UPDATE | ジョブ状態の記録（JobModel使用時） |

### テーブル別操作詳細

#### jobs（JobModel使用時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name, status, started_at | 新規ジョブ記録 | - |
| UPDATE | status, finished_at | 完了/失敗状態更新 | - |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Error | ジョブ実行中の例外 | Sentry送信、エラーログ出力 |
| - | WorkerError | ワーカースレッドでのエラー | errorHandler呼び出し |

### リトライ仕様

標準のリトライ機能はなし。必要に応じてジョブ内で実装

## トランザクション仕様

ジョブ内で個別にトランザクション管理

## パフォーマンス要件

- インラインキュー: 同時実行数はasync-queue-managerの設定に依存
- ワーカースレッド: Node.jsのワーカースレッド数に依存

## セキュリティ考慮事項

- ジョブファイルパスはrequire('path').resolveで解決
- ワーカースレッドは分離されたコンテキストで実行

## 備考

- @tryghost/job-managerパッケージをラップして使用
- テストモードでは5秒ごとにキュー状態をログ出力

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: サービス初期化を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | job-service.js | `ghost/core/core/server/services/jobs/job-service.js` | JobManagerのインスタンス化と設定 |
| 1-2 | index.js | `ghost/core/core/server/services/jobs/index.js` | エクスポート |

**読解のコツ**: @tryghost/job-managerの使用方法を理解する。errorHandler、workerMessageHandlerのカスタマイズ箇所が重要。

**主要処理フロー（job-service.js）**:
- **6-16行目**: errorHandler - エラー時のSentry連携
- **19-23行目**: workerMessageHandler - ワーカーメッセージ処理
- **25-44行目**: initTestMode - テストモード初期化
- **46行目**: JobManager インスタンス生成

#### Step 2: 外部ライブラリの使用箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | job-service.js | `ghost/core/core/server/services/jobs/job-service.js` | 依存関係とオプション |

**主要処理フロー**:
- **6行目**: JobManagerインポート（@tryghost/job-manager）
- **46行目**: JobManager初期化オプション
  - errorHandler: エラー処理コールバック
  - workerMessageHandler: ワーカーメッセージコールバック
  - JobModel: Bookshelfモデル（ジョブ永続化用）
  - domainEvents: イベント発行用
  - config: 設定オブジェクト
  - events: 内部イベント

#### Step 3: 使用例を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.js | `ghost/core/core/server/services/update-check/index.js` | scheduleRecurringJobs使用例 |

**主要処理フロー**:
- **75-86行目**: addJobの使用例（更新チェックのスケジューリング）

### プログラム呼び出し階層図

```
job-service.js
    │
    └─ new JobManager({...})
           │
           ├─ addJob(options)
           │      │
           │      ├─ offloaded=false → inlineQueue.add()
           │      │
           │      └─ offloaded=true → bree.add()
           │                              │
           │                              ├─ at指定あり → schedule登録
           │                              └─ at指定なし → 即時実行
           │
           ├─ inlineQueue
           │      └─ async-queue-manager
           │             └─ 順次実行
           │
           └─ bree
                  └─ ワーカースレッド
                         │
                         ├─ 成功 → workerMessageHandler
                         └─ 失敗 → errorHandler
                                      └─ sentry.captureException
```

### データフロー図

```
[入力]                    [処理]                           [出力]

addJob() ──────────▶ JobManager ──────────▶ 実行結果
 │                        │                     │
 ├─ job (Function)       ├─ inlineQueue        ├─ 成功ログ
 ├─ name                 │      └─ 順次実行     │
 ├─ at (cron)           │                      ├─ エラーログ
 └─ data                └─ bree               │
                              └─ ワーカー       └─ Sentry通知
                                    │
                                    ▼
                              ワーカーメッセージ
                                    │
                                    ▼
                               logging.info
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job-service.js | `ghost/core/core/server/services/jobs/job-service.js` | ソース | メインサービス |
| index.js | `ghost/core/core/server/services/jobs/index.js` | ソース | エクスポート |
| @tryghost/job-manager | node_modules | 外部ライブラリ | ジョブ管理基盤 |
| bree | node_modules | 外部ライブラリ | スケジューラー |
| sentry.js | `ghost/core/core/shared/sentry.js` | ソース | Sentry連携 |
