# 機能設計書：77-Admin Settings（React）

## 1. 概要

### 1.1 機能の目的
Admin Settings（admin-x-settings）は、Ghost管理画面の設定機能を提供するReactベースのマイクロフロントエンドアプリケーションです。サイト設定、メンバーシップ設定、メール設定、成長機能、高度な設定など、包括的な設定管理UIを提供します。

### 1.2 機能の範囲
- **一般設定（General）**: タイトル・説明、タイムゾーン、言語、ユーザー管理、SEOメタ、ソーシャルアカウント、パスワード保護
- **サイト設定（Site）**: デザイン・テーマ、ナビゲーション、告知バー
- **メンバーシップ設定（Membership）**: Portal設定、Tier設定、Stripe連携、アクセス制御
- **メール設定（Email）**: ニュースレター設定、メールボックス設定
- **成長機能（Growth）**: レコメンデーション、オファー、埋め込みフォーム、Tips & Donations
- **高度な設定（Advanced）**: 統合、Labs、コードインジェクション、移行ツール、履歴、危険ゾーン

### 1.3 関連画面
| 画面No | 画面名 | 関連度 |
|--------|--------|--------|
| 71-92 | 設定画面群 | 高 |

## 2. 機能種別
- 種別：管理画面（マイクロフロントエンド）
- 分類：管理画面
- カテゴリ：設定管理

## 3. 入力仕様

### 3.1 フレームワークプロパティ
| プロパティ | 型 | 必須 | 説明 |
|-----------|-----|------|------|
| framework | TopLevelFrameworkProps | Yes | Ghost Admin APIアクセス設定 |
| designSystem | DesignSystemAppProps | Yes | デザインシステム設定 |
| upgradeStatus | UpgradeStatusType | No | アップグレード状態 |

### 3.2 ルーティングパス
| パス | モーダル名 | 説明 |
|------|-----------|------|
| design/change-theme | DesignAndThemeModal | テーマ変更 |
| design/edit | DesignAndThemeModal | デザイン編集 |
| navigation/edit | NavigationModal | ナビゲーション編集 |
| staff/invite | InviteUserModal | ユーザー招待 |
| staff/:slug | UserDetailModal | ユーザー詳細 |
| portal/edit | PortalModal | Portal編集 |
| tiers/add | TierDetailModal | Tier追加 |
| tiers/:id | TierDetailModal | Tier編集 |
| stripe-connect | StripeConnectModal | Stripe連携 |
| newsletters/new | AddNewsletterModal | ニュースレター追加 |
| newsletters/:id | NewsletterDetailModal | ニュースレター詳細 |
| history/view | HistoryModal | 履歴表示 |
| integrations/zapier | ZapierModal | Zapier連携 |
| integrations/:id | CustomIntegrationModal | カスタム統合 |
| recommendations/add | AddRecommendationModal | レコメンデーション追加 |
| offers/edit/:id | OffersContainerModal | オファー編集 |
| about | AboutModal | About |

## 4. 出力仕様

### 4.1 レンダリング出力
- コンテナクラス: `.admin-x-settings`
- レスポンシブ: `tablet:max-w-[760px]`
- パディング: `px-8 pt-16 tablet:px-14 tablet:pt-0`

### 4.2 API操作
- Ghost Admin API経由で設定を読み書き
- @tryghost/admin-x-framework提供のAPIフック使用

## 5. 処理フロー

### 5.1 アプリケーション初期化フロー
```
1. index.tsx
   └─ StandaloneApp エクスポート

2. StandaloneApp (app.tsx:32-38)
   ├─ FrameworkProvider: Ghost Admin API接続
   └─ App コンポーネント

3. App (app.tsx:14-30)
   ├─ SettingsAppProvider: アプリコンテキスト
   │   ├─ officialThemes: テーマデータ
   │   ├─ zapierTemplates: Zapierテンプレート
   │   └─ search: 検索サービス
   ├─ NiceModal.Provider: モーダル管理
   ├─ RoutingProvider: ルーティング（basePath='settings'）
   ├─ DesignSystemApp: デザインシステム適用
   ├─ SettingsRouter: ルート変更ハンドリング
   └─ MainContent → Settings コンポーネント
```

### 5.2 設定セクション構成
```
Settings (settings.tsx)
├── GeneralSettings
│   ├── TitleAndDescription
│   ├── TimeZone
│   ├── PublicationLanguage
│   ├── Users
│   ├── SEOMeta
│   ├── SocialAccounts
│   ├── Analytics
│   └── LockSite
├── SiteSettings
│   ├── DesignAndTheme
│   ├── Navigation
│   └── AnnouncementBar
├── MembershipSettings
│   ├── Portal
│   ├── Access
│   ├── Tiers
│   └── Analytics
├── EmailSettings
│   ├── Newsletters
│   └── Mailgun
├── GrowthSettings
│   ├── Recommendations
│   ├── Offers
│   ├── EmbedSignupForm
│   └── TipsAndDonations
└── AdvancedSettings
    ├── Integrations
    ├── Labs
    ├── CodeInjection
    ├── MigrationTools
    ├── History
    └── DangerZone
```

### 5.3 検索機能フロー
```
1. useSearchService()
   ├─ filter: 検索文字列
   ├─ setFilter(): フィルタ更新
   ├─ checkVisible(): 表示判定
   └─ highlightKeywords(): キーワードハイライト

2. SearchableSection
   ├─ keywords: 検索キーワード配列
   └─ checkVisible(keywords) で表示制御

3. searchKeywords定義（各設定コンポーネント）
   例: titleAndDescription: ['general', 'title and description', 'site title', ...]
```

## 6. ビジネスルール

### 6.1 設定カテゴリルール
| カテゴリ | 含まれる設定 | アクセス権限 |
|----------|-------------|-------------|
| General | 基本設定、ユーザー管理 | Admin以上 |
| Site | テーマ、ナビゲーション | Admin以上 |
| Membership | 会員、Tier、Stripe | Admin以上 |
| Email | ニュースレター | Admin以上 |
| Growth | レコメンデーション、オファー | Admin以上 |
| Advanced | 統合、Labs、履歴 | Admin以上 |

### 6.2 モーダルルーティングルール
- モーダルパスは`modalPaths`オブジェクトで定義
- 動的パラメータ（`:slug`, `:id`）対応
- `loadModals()`で遅延ロード

## 7. データベース操作仕様

本機能はクライアントサイドアプリのため、Ghost Admin API経由でデータ操作を行います。

### 7.1 主要API操作
| 操作 | APIエンドポイント | 説明 |
|------|------------------|------|
| 設定取得 | GET /settings/ | サイト設定取得 |
| 設定更新 | PUT /settings/ | サイト設定更新 |
| ユーザー一覧 | GET /users/ | スタッフ一覧取得 |
| ユーザー招待 | POST /invites/ | ユーザー招待 |
| テーマ一覧 | GET /themes/ | テーマ一覧取得 |
| テーマアップロード | POST /themes/upload/ | テーマアップロード |
| Tier一覧 | GET /tiers/ | 料金プラン一覧 |
| ニュースレター | GET /newsletters/ | ニュースレター一覧 |
| 統合 | GET /integrations/ | 統合一覧 |

## 8. エラー処理

### 8.1 フレームワークレベルエラー
- FrameworkProviderでAPI通信エラーをキャッチ
- エラーバウンダリによるUIフォールバック

### 8.2 フォームバリデーション
- validator.jsによる入力検証
- @tryghost/nqlによるフィルタ式検証
- 各入力コンポーネントでのリアルタイムバリデーション

## 9. トランザクション仕様

本機能はクライアントサイドアプリのため、トランザクション管理はGhost CoreのAPIが担当します。

## 10. パフォーマンス要件

### 10.1 コード分割
- モーダルは`loadModals()`で動的インポート
- 設定セクションは必要に応じてレンダリング

### 10.2 検索最適化
- キーワードベースの表示フィルタリング
- コンポーネント登録/解除でメモリ管理

## 11. セキュリティ考慮事項

### 11.1 認証
- Ghost Admin APIセッションに依存
- FrameworkProviderで認証状態管理

### 11.2 入力検証
- validatorライブラリによるサニタイズ
- NQLフィルタの構文検証

### 11.3 外部サービス連携
- Stripe Connect: OAuth認証
- Unsplash: API Key認証
- Zapier: Webhook認証

## 12. 備考

### 12.1 技術スタック
- React 18.3.1
- TypeScript
- Vite（ビルドツール）
- @tryghost/admin-x-framework（APIフック）
- @tryghost/admin-x-design-system（UIコンポーネント）
- @tryghost/shade（新デザインシステム）
- @ebay/nice-modal-react（モーダル管理）
- CodeMirror 6（HTMLエディタ）
- @tryghost/i18n（多言語対応）

### 12.2 公式テーマ
officialThemesデータで定義された公式テーマリスト：
- Casper（デフォルト）
- その他Ghost公式テーマ

### 12.3 Zapierテンプレート
zapierTemplatesデータで定義されたZapier連携テンプレート

---

## コードリーディングガイド

### 推奨読解順序

#### 1. エントリーポイント
**ファイル**: `apps/admin-x-settings/src/index.tsx`

```
index.tsx (1-6行目)
├─ './styles/index.css': スタイル読み込み
└─ StandaloneApp as AdminXApp: エクスポート
```

#### 2. アプリケーション構造
**ファイル**: `apps/admin-x-settings/src/app.tsx`

```
StandaloneApp (32-38行目)
└─ FrameworkProvider
    └─ App

App (14-30行目)
├─ SettingsAppProvider
│   └─ GlobalDataProvider
│       └─ ScrollSectionProvider
├─ NiceModal.Provider
├─ RoutingProvider (basePath='settings')
├─ DesignSystemApp (className='admin-x-settings')
├─ SettingsRouter
└─ MainContent
```

#### 3. ルーティング設定
**ファイル**: `apps/admin-x-settings/src/components/providers/settings-router.tsx`

```
modalPaths (6-41行目)
├─ 'design/change-theme': 'DesignAndThemeModal'
├─ 'staff/invite': 'InviteUserModal'
├─ 'portal/edit': 'PortalModal'
├─ 'tiers/:id': 'TierDetailModal'
├─ 'stripe-connect': 'StripeConnectModal'
├─ 'newsletters/:id': 'NewsletterDetailModal'
└─ ... その他多数

SettingsRouter (45-64行目)
├─ useRouteChangeCallback(): ルート変更検知
└─ updateNavigatedSection(): セクション更新
```

#### 4. アプリコンテキスト
**ファイル**: `apps/admin-x-settings/src/components/providers/settings-app-provider.tsx`

```
SettingsAppProvider (65-92行目)
├─ officialThemes: 公式テーマリスト
├─ zapierTemplates: Zapierテンプレート
├─ search: 検索サービス
├─ sortingState: ソート状態
└─ GlobalDataProvider
    └─ ScrollSectionProvider
```

#### 5. 設定画面メインコンポーネント
**ファイル**: `apps/admin-x-settings/src/components/settings.tsx`

```
Settings (10-25行目)
├─ GeneralSettings
├─ SiteSettings
├─ MembershipSettings
├─ EmailSettings
├─ GrowthSettings
└─ AdvancedSettings
```

#### 6. 設定セクション例（General）
**ファイル**: `apps/admin-x-settings/src/components/settings/general/general-settings.tsx`

```
searchKeywords (13-22行目)
├─ titleAndDescription: ['general', 'title and description', ...]
├─ timeZone: ['general', 'time', 'date', ...]
└─ users: ['general', 'users and permissions', ...]

GeneralSettings (24-41行目)
├─ SearchableSection (keywords=Object.values(searchKeywords).flat())
│   ├─ TitleAndDescription
│   ├─ TimeZone
│   ├─ PublicationLanguage
│   ├─ Users
│   ├─ SEOMeta
│   ├─ SocialAccounts
│   ├─ Analytics
│   └─ LockSite
```

### プログラム呼び出し階層図

```
[Ghost Admin (Ember)]
    │
    ▼
AdminXComponent.ReactComponent()
    │
    └─ <AdminXApp framework={...} designSystem={...} />
           │
           └─ index.tsx::StandaloneApp
                  │
                  └─ app.tsx::StandaloneApp
                         │
                         ├─ FrameworkProvider
                         │   └─ API通信設定
                         │
                         └─ App
                             │
                             ├─ SettingsAppProvider
                             │   ├─ officialThemes
                             │   ├─ zapierTemplates
                             │   ├─ useSearchService()
                             │   └─ GlobalDataProvider
                             │       └─ ScrollSectionProvider
                             │
                             ├─ NiceModal.Provider
                             │
                             ├─ RoutingProvider
                             │   └─ modalPaths / loadModals
                             │
                             ├─ DesignSystemApp
                             │
                             ├─ SettingsRouter
                             │   └─ useRouteChangeCallback()
                             │
                             └─ MainContent
                                 └─ Settings
                                     ├─ GeneralSettings
                                     │   └─ TitleAndDescription, TimeZone, ...
                                     ├─ SiteSettings
                                     │   └─ DesignAndTheme, Navigation, ...
                                     ├─ MembershipSettings
                                     │   └─ Portal, Access, Tiers, ...
                                     ├─ EmailSettings
                                     │   └─ Newsletters, Mailgun, ...
                                     ├─ GrowthSettings
                                     │   └─ Recommendations, Offers, ...
                                     └─ AdvancedSettings
                                         └─ Integrations, Labs, ...
```

### データフロー図

```
[Ghost Admin (Ember)]
    │
    ├── framework props
    │   ├── ghostVersion
    │   ├── externalNavigate
    │   └── unsplashConfig
    │
    ▼
[FrameworkProvider]
    │
    ├── API hooks (useBrowse, useEdit, etc.)
    │
    ▼
[SettingsAppProvider]
    │
    ├── officialThemes (静的データ)
    ├── zapierTemplates (静的データ)
    ├── search service
    │   ├── filter
    │   ├── checkVisible()
    │   └── highlightKeywords()
    │
    ▼
[GlobalDataProvider]
    │
    ├── settings (Ghost Admin API)
    ├── users
    ├── tiers
    ├── newsletters
    └── integrations
    │
    ▼
[Settings Components]
    │
    ├── 読み取り: useGlobalData()
    ├── 更新: useEditSettings()
    │
    └── モーダル
        └── NiceModal.show()
            └── [各モーダルコンポーネント]
```

### 関連ファイル一覧

| ファイルパス | 役割 | 重要度 |
|-------------|------|--------|
| apps/admin-x-settings/src/index.tsx | エントリーポイント | 高 |
| apps/admin-x-settings/src/app.tsx | アプリルート | 高 |
| apps/admin-x-settings/src/components/settings.tsx | 設定メインコンポーネント | 高 |
| apps/admin-x-settings/src/components/providers/settings-router.tsx | ルーティング定義 | 高 |
| apps/admin-x-settings/src/components/providers/settings-app-provider.tsx | アプリコンテキスト | 高 |
| apps/admin-x-settings/src/components/settings/general/general-settings.tsx | 一般設定 | 中 |
| apps/admin-x-settings/src/components/settings/site/site-settings.tsx | サイト設定 | 中 |
| apps/admin-x-settings/src/components/settings/membership/membership-settings.tsx | メンバーシップ設定 | 中 |
| apps/admin-x-settings/src/components/settings/email/email-settings.tsx | メール設定 | 中 |
| apps/admin-x-settings/src/components/settings/growth/growth-settings.tsx | 成長機能設定 | 中 |
| apps/admin-x-settings/src/components/settings/advanced/advanced-settings.tsx | 高度な設定 | 中 |
| apps/admin-x-settings/src/utils/search.tsx | 検索サービス | 中 |
| apps/admin-x-settings/src/data/official-themes.ts | 公式テーマデータ | 低 |
| apps/admin-x-settings/src/data/zapier-templates.ts | Zapierテンプレート | 低 |
| apps/admin-x-settings/package.json | 依存関係定義 | 中 |
