# 機能設計書 82-Admin X Design System

## 概要

本ドキュメントは、Ghostのレガシーデザインシステム「Admin X Design System」の機能設計を定義する。これはGhost Admin内のReactベースのマイクロフロントエンドアプリケーションで使用されるUIコンポーネントライブラリであり、段階的にShadeへ移行中である。

### 本機能の処理概要

Admin X Design Systemは、Ghost管理画面の設定セクションや各種Reactアプリで使用されるUIコンポーネント、フォーム要素、レイアウトコンポーネント、設定専用コンポーネントを提供する。

**業務上の目的・背景**：Ghost Admin内のReactアプリケーション（admin-x-settings等）において、統一されたUIを提供し、開発効率を向上させることを目的とする。ただし、新規開発ではShadeの使用が推奨されており、本システムは段階的に廃止予定である。

**機能の利用シーン**：
- 設定画面（Settings）でのフォーム構築
- モーダルダイアログの表示
- テーブル、リスト、ナビゲーションの構築
- Chrome（デスクトップ/モバイル）プレビューフレームの表示

**主要な処理内容**：
1. フォームコンポーネントの提供（TextField、Select、Toggle、CodeEditor等）
2. モーダルコンポーネントの提供（Modal、ConfirmationModal、PreviewModal等）
3. 設定専用コンポーネントの提供（SettingGroup、SettingSection、SettingValue等）
4. レイアウトコンポーネントの提供（Page、ViewContainer、Chrome等）
5. ユーティリティフックの提供（useGlobalDirtyState、usePagination等）

**関連システム・外部連携**：
- @radix-ui/* - アクセシブルなプリミティブコンポーネント
- @dnd-kit - ドラッグアンドドロップ機能
- @ebay/nice-modal-react - モーダル管理
- react-colorful - カラーピッカー
- react-select - セレクトボックス
- @uiw/react-codemirror - コードエディタ

**権限による制御**：デザインシステムとしての本機能には権限制御は存在しない。利用するアプリケーション側で適切な認証・認可を実装する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32-63 | 設定画面系 | 主画面 | SettingGroup、SettingSectionを使用した設定UI |

## 機能種別

UIコンポーネントライブラリ / デザインシステム（レガシー）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| darkMode | boolean | Yes | ダークモードの有効/無効 | - |
| fetchKoenigLexical | Function | No | Koenigエディタのフェッチ関数 | - |
| className | string | No | 追加のCSSクラス | - |

### 入力データソース

- 呼び出し元Reactコンポーネントからのprops
- TailwindCSSの設定ファイル（tailwind.config.cjs）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ReactElement | JSX.Element | レンダリングされたUIコンポーネント |
| CSS Styles | string | Tailwindによって生成されたスタイル |

### 出力先

- DOMへのレンダリング
- ESモジュールとしてのエクスポート（es/index.js）

## 処理フロー

### 処理シーケンス

```
1. DesignSystemAppでアプリケーションをラップ
   └─ .admin-x-designスコープの適用
2. DesignSystemProviderによるコンテキスト提供
   └─ フォーカス状態、Koenigエディタ参照の管理
3. 個別コンポーネントの利用
   └─ propsに基づくレンダリング
4. NiceModal.Providerによるモーダル管理
```

### フローチャート

```mermaid
flowchart TD
    A[DesignSystemApp開始] --> B[DesignSystemProviderでラップ]
    B --> C[NiceModal.Provider]
    C --> D[子コンポーネントのレンダリング]
    D --> E{コンポーネント種別}
    E -->|Form| F[フォームコンポーネント]
    E -->|Modal| G[モーダルコンポーネント]
    E -->|Setting| H[設定コンポーネント]
    E -->|Layout| I[レイアウトコンポーネント]
    F --> J[DOM出力]
    G --> J
    H --> J
    I --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-82-01 | 段階的廃止 | 新規開発ではShadeを使用 | 新機能開発時 |
| BR-82-02 | CSSスコープ | admin-x-* セレクタでスコープ | 常時 |
| BR-82-03 | モーダル管理 | NiceModalを通じて管理 | モーダル使用時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

なし（UIライブラリのためDB操作なし）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | RenderError | コンポーネントレンダリング失敗 | ErrorBoundaryでキャッチ |

### リトライ仕様

なし

## トランザクション仕様

なし

## パフォーマンス要件

- バンドルサイズの最小化（tree-shakingサポート）

## セキュリティ考慮事項

- ユーザー入力のサニタイズは利用側アプリケーションで実施

## 備考

- **段階的廃止予定**：新規開発ではShadeの使用を推奨
- Storybookでコンポーネントドキュメントを提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | index.ts | `apps/admin-x-design-system/src/index.ts` | 全エクスポートの確認 |
| 1-2 | design-system-app.tsx | `apps/admin-x-design-system/src/design-system-app.tsx` | アプリケーションラッパー |

**読解のコツ**: index.tsで提供されているすべてのコンポーネントとhooksを確認し、どのカテゴリ（form、modal、settings、global）に分類されているかを把握する。

#### Step 2: プロバイダを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | design-system-provider.tsx | `apps/admin-x-design-system/src/providers/design-system-provider.tsx` | コンテキスト定義 |

#### Step 3: 設定コンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | setting-group.tsx | `apps/admin-x-design-system/src/settings/setting-group.tsx` | 設定グループの構造 |
| 3-2 | setting-section.tsx | `apps/admin-x-design-system/src/settings/setting-section.tsx` | 設定セクションの構造 |

#### Step 4: フォームコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | text-field.tsx | `apps/admin-x-design-system/src/global/form/text-field.tsx` | テキスト入力 |
| 4-2 | select.tsx | `apps/admin-x-design-system/src/global/form/select.tsx` | セレクトボックス |

### プログラム呼び出し階層図

```
DesignSystemApp
    │
    ├─ DesignSystemProvider
    │      └─ DesignSystemContext.Provider
    │             └─ フォーカス状態、Koenigエディタ参照
    │
    ├─ NiceModal.Provider
    │      └─ モーダル状態管理
    │
    └─ UI Components
           ├─ Settings Components
           │      ├─ SettingGroup
           │      ├─ SettingSection
           │      └─ SettingValue
           │
           ├─ Form Components
           │      ├─ TextField, Select
           │      ├─ Toggle, Checkbox
           │      └─ CodeEditor
           │
           ├─ Modal Components
           │      ├─ Modal
           │      ├─ ConfirmationModal
           │      └─ PreviewModal
           │
           └─ Layout Components
                  ├─ Page, ViewContainer
                  └─ DesktopChrome, MobileChrome
```

### データフロー図

```
[入力]               [処理]                    [出力]

Props           ───▶ Component Logic       ───▶ ReactElement
  (value, onChange)

Context         ───▶ Provider              ───▶ State sharing
  (focusState)

Modal State     ───▶ NiceModal             ───▶ Modal rendering
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| package.json | `apps/admin-x-design-system/package.json` | 設定 | パッケージ定義 |
| index.ts | `apps/admin-x-design-system/src/index.ts` | ソース | エクスポート集約 |
| design-system-app.tsx | `apps/admin-x-design-system/src/design-system-app.tsx` | ソース | アプリラッパー |
| design-system-provider.tsx | `apps/admin-x-design-system/src/providers/design-system-provider.tsx` | ソース | コンテキスト |
| setting-group.tsx | `apps/admin-x-design-system/src/settings/setting-group.tsx` | ソース | 設定グループ |
| tailwind.config.cjs | `apps/admin-x-design-system/tailwind.config.cjs` | 設定 | Tailwind設定 |
