# 機能設計書 83-Admin X Framework

## 概要

本ドキュメントは、「Admin X Framework」の機能設計を定義する。Admin X Frameworkは、Ghostのマイクロフロントエンドアプリケーション（admin-x-settings、posts、stats、activitypub等）で共通使用されるAPI通信、ルーティング、ユーティリティ機能を提供するフレームワークである。

### 本機能の処理概要

Admin X Frameworkは、データフェッチング（@tanstack/react-query）、ルーティング（react-router）、状態管理、API通信のための共通基盤を提供する。

**業務上の目的・背景**：複数のReactマイクロフロントエンドアプリケーションで共通する機能（API呼び出し、ルーティング、設定管理）を集約し、コードの重複を避け、保守性を向上させることを目的とする。

**機能の利用シーン**：
- Ghost Admin APIとの通信（設定取得、投稿管理、メンバー管理等）
- アプリ内ナビゲーション（ルーティング）
- Tinybirdアナリティクスデータの取得
- フォーム状態管理と検証

**主要な処理内容**：
1. FrameworkProvider/AppProviderによるコンテキスト提供
2. API通信用フック（useBrowse、useEdit、useAdd等）の提供
3. React Routerベースのルーティング機能
4. Tinybirdトークン管理とクエリ実行
5. フォームハンドリング（useForm）
6. 権限チェック（usePermissions）

**関連システム・外部連携**：
- @tanstack/react-query - データフェッチング・キャッシング
- react-router - クライアントサイドルーティング
- @tinybirdco/charts - アナリティクスチャート
- Ghost Admin API - バックエンドAPI
- Tinybird - アナリティクスプラットフォーム

**権限による制御**：usePermissionsフックにより、ユーザーの権限に基づいた機能制御が可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 全管理画面 | - | 補助機能 | API通信、ルーティング基盤として利用 |

## 機能種別

フレームワーク / ユーティリティライブラリ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ghostVersion | string | Yes | Ghostのバージョン | - |
| externalNavigate | Function | No | 外部ナビゲーション関数 | - |
| unsplashConfig | object | No | Unsplash API設定 | - |
| sentryDSN | string | No | Sentry DSN | URL形式 |
| onUpdate | Function | No | 更新時コールバック | - |
| onInvalidate | Function | No | キャッシュ無効化コールバック | - |
| onDelete | Function | No | 削除時コールバック | - |

### 入力データソース

- Ghost Admin APIレスポンス
- Tinybird APIレスポンス
- アプリケーション設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| APIレスポンス | object | Ghost APIからのデータ |
| ルーティング状態 | object | 現在のルート情報 |
| フォーム状態 | object | フォームの値・エラー・dirty状態 |

### 出力先

- Reactコンポーネントへの状態提供
- ブラウザのHistory API

## 処理フロー

### 処理シーケンス

```
1. FrameworkProviderでアプリケーションをラップ
   └─ QueryClientの初期化
   └─ 基本設定の注入
2. AppProviderでアプリ固有の設定を注入
   └─ サイト情報、設定キャッシュの提供
3. RouterProviderでルーティング設定
   └─ react-routerの初期化
4. 個別フックの利用
   └─ useBrowse/useEdit等でAPI通信
   └─ useFormでフォーム管理
```

### フローチャート

```mermaid
flowchart TD
    A[FrameworkProvider] --> B[QueryClientProvider]
    B --> C[AppProvider]
    C --> D[RouterProvider]
    D --> E[アプリケーションコンポーネント]
    E --> F{APIリクエスト?}
    F -->|Yes| G[useQuery/useMutation]
    G --> H[Ghost Admin API]
    H --> I[レスポンスキャッシュ]
    F -->|No| J[ローカル状態管理]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-83-01 | APIキャッシング | react-queryでレスポンスをキャッシュ | API呼び出し時 |
| BR-83-02 | エラーハンドリング | useHandleErrorでエラー処理を統一 | APIエラー発生時 |
| BR-83-03 | フォームダーティ状態 | 未保存変更がある場合に警告 | ページ離脱時 |
| BR-83-04 | 権限チェック | usePermissionsで操作可否を判定 | 権限必要な操作時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

なし（フレームワークとしてはDBに直接アクセスしない。Ghost Admin APIを経由）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | APIError | API通信失敗 | useHandleErrorでトースト表示 |
| - | ValidationError | フォームバリデーション失敗 | エラーメッセージ表示 |
| - | PermissionError | 権限不足 | 操作を無効化 |

### リトライ仕様

react-queryのデフォルトリトライ設定に準拠

## トランザクション仕様

なし（Ghost Admin API側で管理）

## パフォーマンス要件

- react-queryによる効率的なキャッシング
- staleTime/cacheTime設定による最適化

## セキュリティ考慮事項

- APIキー・トークンの安全な管理
- CSRFトークンの自動付与

## 備考

- ESMとCommonJS両方のエクスポートをサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | index.ts | `apps/admin-x-framework/src/index.ts` | 全エクスポートの確認 |
| 1-2 | package.json | `apps/admin-x-framework/package.json` | エクスポートパス定義 |

#### Step 2: プロバイダを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | framework-provider.tsx | `apps/admin-x-framework/src/providers/framework-provider.tsx` | フレームワークコンテキスト |
| 2-2 | app-provider.tsx | `apps/admin-x-framework/src/providers/app-provider.tsx` | アプリコンテキスト |
| 2-3 | router-provider.tsx | `apps/admin-x-framework/src/providers/router-provider.tsx` | ルーティング設定 |

#### Step 3: APIフックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | hooks.ts | `apps/admin-x-framework/src/utils/api/hooks.ts` | useBrowse、useEdit等の実装 |
| 3-2 | fetch-api.ts | `apps/admin-x-framework/src/utils/api/fetch-api.ts` | API通信の基盤 |

#### Step 4: ユーティリティフックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | use-form.ts | `apps/admin-x-framework/src/hooks/use-form.ts` | フォーム管理 |
| 4-2 | use-permissions.ts | `apps/admin-x-framework/src/hooks/use-permissions.ts` | 権限チェック |
| 4-3 | use-tinybird-query.ts | `apps/admin-x-framework/src/hooks/use-tinybird-query.ts` | Tinybird連携 |

### プログラム呼び出し階層図

```
FrameworkProvider
    │
    ├─ QueryClientProvider (@tanstack/react-query)
    │      └─ APIリクエストのキャッシング
    │
    ├─ AppProvider
    │      └─ AppContext (siteData, config, settings)
    │
    └─ RouterProvider
           └─ react-router (Routes, Navigate)
```

### データフロー図

```
[入力]               [処理]                    [出力]

API Request     ───▶ useBrowse/useEdit      ───▶ Cached Data
                     (react-query)

Form Input      ───▶ useForm                ───▶ Form State
                     (validation)                (values, errors)

Route Change    ───▶ RouterProvider         ───▶ Component Render
                     (react-router)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| package.json | `apps/admin-x-framework/package.json` | 設定 | パッケージ定義 |
| index.ts | `apps/admin-x-framework/src/index.ts` | ソース | エクスポート集約 |
| framework-provider.tsx | `apps/admin-x-framework/src/providers/framework-provider.tsx` | ソース | フレームワークコンテキスト |
| app-provider.tsx | `apps/admin-x-framework/src/providers/app-provider.tsx` | ソース | アプリコンテキスト |
| router-provider.tsx | `apps/admin-x-framework/src/providers/router-provider.tsx` | ソース | ルーティング |
| hooks.ts | `apps/admin-x-framework/src/utils/api/hooks.ts` | ソース | APIフック |
| fetch-api.ts | `apps/admin-x-framework/src/utils/api/fetch-api.ts` | ソース | API通信基盤 |
| use-form.ts | `apps/admin-x-framework/src/hooks/use-form.ts` | ソース | フォーム管理 |
| use-permissions.ts | `apps/admin-x-framework/src/hooks/use-permissions.ts` | ソース | 権限チェック |
