# 機能設計書 85-Mobiledoc変換

## 概要

本ドキュメントは、「Mobiledoc変換」機能の設計を定義する。この機能は、レガシーのMobiledocフォーマットで保存された記事コンテンツを管理し、過去のリビジョンを保持する。新規コンテンツはLexical形式で作成されるが、既存のMobiledocコンテンツの互換性を維持する。

### 本機能の処理概要

Mobiledoc変換機能は、従来のMobiledocエディタで作成されたコンテンツのリビジョン履歴を保持し、必要に応じて過去のバージョンを参照できるようにする。

**業務上の目的・背景**：Ghost 4.x以前はMobiledocフォーマットを使用していたが、Ghost 5.xでLexicalエディタに移行した。既存のMobiledocコンテンツおよびその編集履歴を保持し、データ移行の安全性を確保する必要がある。

**機能の利用シーン**：
- 過去のMobiledocリビジョンの参照
- レガシーコンテンツのバックアップ
- マイグレーション時のデータ保全

**主要な処理内容**：
1. MobiledocリビジョンのDB保存・取得
2. タイムスタンプによるリビジョン順序管理
3. フィルタリングによるリビジョン検索

**関連システム・外部連携**：
- Ghost Core Bookshelfモデル
- posts テーブル（mobiledocカラム）

**権限による制御**：内部モデルとして動作し、権限は上位のAPI層で管理。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 14 | 投稿復元画面 | 参照画面 | 削除された投稿の復元処理 |

## 機能種別

データモデル / リビジョン管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| post_id | string | Yes | 関連する投稿ID | 24文字 |
| mobiledoc | text | No | Mobiledoc JSON | - |
| filter | string | No | 検索フィルタ（NQL） | - |

### 入力データソース

- Ghost Admin APIからのリクエスト
- 内部サービスからの呼び出し

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | string | リビジョンID（24文字） |
| post_id | string | 関連投稿ID |
| mobiledoc | text | Mobiledoc JSON |
| created_at | dateTime | 作成日時 |

### 出力先

- mobiledoc_revisions テーブル

## 処理フロー

### 処理シーケンス

```
1. リビジョン保存
   └─ post_id と mobiledoc を受け取る
   └─ タイムスタンプ（created_at_ts）を設定
   └─ mobiledoc_revisions テーブルに INSERT
2. リビジョン取得
   └─ post_id でフィルタリング
   └─ created_at_ts DESC で並び替え
   └─ リビジョン一覧を返却
```

### フローチャート

```mermaid
flowchart TD
    A[リビジョン保存リクエスト] --> B{post_id存在?}
    B -->|Yes| C[mobiledoc_revisions INSERT]
    B -->|No| D[エラー返却]
    C --> E[created_at_ts設定]
    E --> F[保存完了]

    G[リビジョン取得リクエスト] --> H[post_idでフィルタ]
    H --> I[created_at_ts DESCでソート]
    I --> J[結果返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-85-01 | 降順ソート | リビジョンはcreated_at_ts降順で返却 | 常時 |
| BR-85-02 | タイムスタンプ非表示 | created_at_tsはJSON出力から除外 | toJSON時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 保存 | mobiledoc_revisions | INSERT | リビジョンの新規作成 |
| 取得 | mobiledoc_revisions | SELECT | リビジョン一覧の取得 |

### テーブル別操作詳細

#### mobiledoc_revisions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | id | 24文字のID | 主キー |
| INSERT | post_id | 関連投稿ID | インデックスあり |
| INSERT | mobiledoc | Mobiledoc JSON | 最大1GB |
| INSERT | created_at_ts | BigIntタイムスタンプ | ソート用 |
| INSERT | created_at | DateTime | 表示用 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | NotFoundError | 存在しないpost_id | エラー返却 |
| - | ValidationError | 不正なパラメータ | エラー返却 |

### リトライ仕様

なし

## トランザクション仕様

Bookshelfのトランザクション機構を使用

## パフォーマンス要件

- post_idカラムにインデックス設定済み

## セキュリティ考慮事項

- 内部モデルとして動作し、直接の外部アクセスは不可

## 備考

- レガシーフォーマットのため、新規開発での使用は非推奨
- Lexical移行後もデータ互換性のために保持

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | schema.js | `ghost/core/core/server/data/schema/schema.js` | mobiledoc_revisionsテーブル定義（395-401行目） |

**読解のコツ**:
- `created_at_ts`（BigInt）: 高精度タイムスタンプ、ソート用
- `created_at`（DateTime）: 表示用日時
- `post_id`にインデックスが設定されている

#### Step 2: モデル層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mobiledoc-revision.js | `ghost/core/core/server/models/mobiledoc-revision.js` | MobiledocRevisionモデル |

**主要処理フロー**:
1. **3-4行目**: ghostBookshelfの拡張
2. **6-17行目**: permittedOptionsの定義（filter, columns許可）
3. **19-21行目**: orderDefaultRawで降順ソート設定
4. **23-29行目**: toJSONでcreated_at_tsを除外

### プログラム呼び出し階層図

```
Ghost Admin API
    │
    └─ Posts Controller
           │
           └─ MobiledocRevision Model
                  │
                  ├─ findAll (filter, columns)
                  │      └─ orderDefaultRaw: created_at_ts DESC
                  │
                  └─ toJSON
                         └─ created_at_ts を除外
```

### データフロー図

```
[入力]               [処理]                    [出力]

Post Edit       ───▶ Revision Save          ───▶ mobiledoc_revisions
  (mobiledoc)        (INSERT)                    (DB)

Revision List   ───▶ findAll                ───▶ JSON Array
  Request            (filter, sort)              (without created_at_ts)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| schema.js | `ghost/core/core/server/data/schema/schema.js` | スキーマ | テーブル定義 |
| mobiledoc-revision.js | `ghost/core/core/server/models/mobiledoc-revision.js` | モデル | Bookshelfモデル |
