# 機能設計書 89-APIキー管理

## 概要

本ドキュメントは、「APIキー管理」機能の設計を定義する。APIキー管理機能は、Content APIおよびAdmin APIへのプログラマティックアクセスを可能にするAPIキーの発行・管理を行う。

### 本機能の処理概要

ApiKeyモデルは、外部システムやカスタムインテグレーションがGhost APIにアクセスするためのAPIキーを管理する。キーの種類（content/admin）に応じて異なる権限が付与される。

**業務上の目的・背景**：Ghost APIへのプログラマティックアクセスを提供し、外部システムとの連携（JAMstack、カスタムフロントエンド、自動化スクリプト等）を可能にする。Content APIは公開コンテンツの読み取り、Admin APIは管理操作を許可する。

**機能の利用シーン**：
- カスタムフロントエンドからのコンテンツ取得（Content API）
- 自動投稿スクリプト（Admin API）
- Webhook連携
- サードパーティサービス連携
- バックアップ・マイグレーションツール

**主要な処理内容**：
1. APIキーの生成（セキュアなランダムシークレット）
2. キータイプに応じたロール割り当て
3. インテグレーションとの関連付け
4. シークレットのリフレッシュ
5. 最終使用日時の記録

**関連システム・外部連携**：
- Integration（カスタムインテグレーション）
- Role（権限管理）
- User（ユーザー関連付け、オプション）

**権限による制御**：Admin APIキーはAdministratorロールを付与。Content APIキーにはロールなし（公開コンテンツのみ）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 58 | インテグレーション設定 | 主画面 | APIキーの発行・管理 |

## 機能種別

データモデル / セキュリティ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| type | string | Yes | キータイプ（content/admin） | isIn: ['content', 'admin'] |
| integration_id | string | No | 関連インテグレーションID | 24文字 |
| role | string | No | Admin APIキーのロール名 | デフォルト: 'Admin Integration' |
| user_id | string | No | 関連ユーザーID | 24文字 |

### 入力データソース

- Ghost Admin（インテグレーション設定画面）
- Admin API

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | string | APIキーID（24文字） |
| type | string | キータイプ |
| secret | string | シークレット（26-128文字） |
| role_id | string | 関連ロールID（admin のみ） |
| integration_id | string | 関連インテグレーションID |
| last_seen_at | dateTime | 最終使用日時 |

### 出力先

- api_keys テーブル
- APIレスポンス

## 処理フロー

### 処理シーケンス

```
1. APIキー作成リクエスト
   └─ typeパラメータ検証
2. シークレット生成
   └─ security.secret.create(type)
3. ロール割り当て（admin タイプのみ）
   └─ Admin Integrationロールを検索
   └─ role_idを設定
4. 保存
   └─ api_keysテーブルにINSERT
5. シークレットリフレッシュ（必要時）
   └─ 新しいシークレット生成
   └─ refreshedアクション記録
```

### フローチャート

```mermaid
flowchart TD
    A[APIキー作成] --> B[type検証]
    B --> C[シークレット生成]
    C --> D{type == admin?}
    D -->|Yes| E[Admin Integrationロール取得]
    E --> F[role_id設定]
    D -->|No| G[role_id = null]
    F --> H[api_keysテーブル保存]
    G --> H
    H --> I[完了]

    J[シークレットリフレッシュ] --> K[新シークレット生成]
    K --> L[api_keysテーブル更新]
    L --> M[refreshedアクション記録]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-89-01 | Admin ロール強制 | Adminキーは必ずAdmin Integrationロールを持つ | type='admin'時 |
| BR-89-02 | Contentロールなし | Contentキーはロールなし（null） | type='content'時 |
| BR-89-03 | シークレット一意性 | シークレットはユニーク | 常時 |
| BR-89-04 | リフレッシュ監査 | シークレット更新時にrefreshedアクションを記録 | refreshSecret時 |

### 計算ロジック

シークレット生成: @tryghost/securityのsecret.create(type)を使用。26-128文字のセキュアなランダム文字列。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 作成 | api_keys | INSERT | 新規APIキー作成 |
| 更新 | api_keys | UPDATE | シークレットリフレッシュ |
| ロール取得 | roles | SELECT | Admin Integrationロール検索 |

### テーブル別操作詳細

#### api_keys

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | id | 24文字ID | 主キー |
| INSERT | type | 'content' or 'admin' | - |
| INSERT | secret | セキュアランダム文字列 | ユニーク、26-128文字 |
| INSERT | role_id | ロールID or null | admin時のみ設定 |
| INSERT | integration_id | インテグレーションID | nullable |
| INSERT | user_id | ユーザーID | nullable |
| UPDATE | last_seen_at | 現在日時 | API使用時 |
| UPDATE | last_seen_version | APIバージョン | API使用時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ValidationError | 不正なtype | エラー返却 |
| - | NotFoundError | ロールが見つからない | エラー返却 |
| - | UniqueConstraint | シークレット重複 | 再生成 |

### リトライ仕様

シークレット重複時は自動再生成

## トランザクション仕様

Bookshelfのトランザクション機構を使用

## パフォーマンス要件

- シークレット検索は高速（ユニークインデックス）

## セキュリティ考慮事項

- シークレットは16進数エンコードで保存
- JWT署名に使用（Admin API）
- APIキーは定期的なローテーション推奨

## 備考

- actionsCollectCRUDによりCRUD操作が監査ログに記録される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | schema.js | `ghost/core/core/server/data/schema/schema.js` | api_keysテーブル定義（371-394行目） |

**読解のコツ**: type（content/admin）、secret（26-128文字、ユニーク）、role_id/integration_id/user_idがnullableであることを確認。

#### Step 2: モデル層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | api-key.js | `ghost/core/core/server/models/api-key.js` | ApiKeyモデル |

**主要処理フロー**:
- **6-8行目**: tableName, actionsCollectCRUD設定
- **13-17行目**: defaults() - シークレット自動生成
- **20-30行目**: リレーション定義（role, integration, user）
- **36-54行目**: onSaving - ロール強制ロジック
- **55-59行目**: onUpdated - refreshedアクション記録
- **61-64行目**: refreshSecret静的メソッド

#### Step 3: 認証での使用を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | admin.js | `ghost/core/core/server/services/auth/api-key/admin.js` | Admin APIでの認証 |

**主要処理フロー**:
- **104-198行目**: authenticateWithToken - JWT検証、ApiKeyモデル使用

### プログラム呼び出し階層図

```
ApiKey Model (api-key.js)
    │
    ├─ defaults()
    │      └─ security.secret.create(type)
    │
    ├─ onSaving()
    │      └─ Role.findOne({name: 'Admin Integration'})
    │             └─ role_id設定
    │
    ├─ onUpdated()
    │      └─ addAction('refreshed')
    │
    ├─ role() / integration() / user()
    │      └─ belongsTo関係
    │
    └─ refreshSecret()
           └─ security.secret.create(type)
           └─ edit()
```

### データフロー図

```
[入力]               [処理]                    [出力]

Create Request  ───▶ ApiKey.add             ───▶ api_keys INSERT
  (type, etc)        (defaults, onSaving)

API Request     ───▶ authenticateWithToken  ───▶ req.api_key
  (JWT Header)       (ApiKey.findOne)

Refresh         ───▶ refreshSecret          ───▶ api_keys UPDATE
  Request            (new secret)                + 'refreshed' action
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| schema.js | `ghost/core/core/server/data/schema/schema.js` | スキーマ | api_keysテーブル定義 |
| api-key.js | `ghost/core/core/server/models/api-key.js` | モデル | ApiKeyモデル |
| admin.js | `ghost/core/core/server/services/auth/api-key/admin.js` | ソース | Admin API認証 |
| content.js | `ghost/core/core/server/services/auth/api-key/content.js` | ソース | Content API認証 |
