---
generated_at: 2026-01-29 10:30:00
metrics:
  claims_total: 42
  claims_with_evidence: 40
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：1-記事管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：40 / 42、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**：コード内に明示的な定義なし
  2. **メンバー制限チェックの詳細条件**：limitServiceの内部実装要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/models/post.js`
- E-02: `ghost/core/core/server/services/posts/posts-service.js`
- E-03: `ghost/core/core/server/api/endpoints/posts.js`
- E-04: `ghost/core/core/server/data/schema/schema.js`
- E-05: `ghost/core/core/server/models/post-revision.js`
- E-06: `ghost/core/core/server/services/posts/post-email-handler.js`（参照のみ）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 記事ステータスはdraft/scheduled/published/sentの4種類 | E-04 (74行目) | ○ |
| C-02 | Lexical形式でリッチテキストを保存 | E-01 (15行目, 67行目), E-04 (67行目) | ○ |
| C-03 | Mobiledoc形式もサポート | E-01 (14行目, 66行目), E-04 (66行目) | ○ |
| C-04 | 記事タイトルは最大255文字 | E-04 (64行目) | ○ |
| C-05 | スラッグは最大191文字 | E-04 (65行目) | ○ |
| C-06 | カスタム抜粋は最大300文字 | E-04 (92行目) | ○ |
| C-07 | デフォルトステータスはdraft | E-01 (92行目), E-04 (74行目) | ○ |
| C-08 | デフォルトvisibilityはpublic | E-01 (73行目), E-04 (77-82行目) | ○ |
| C-09 | 記事のリレーション: tags, authors, mobiledoc_revisions, post_revisions, posts_meta, tiers | E-01 (102行目) | ○ |
| C-10 | 予約投稿は最低2分先の日時が必要 | E-01 (590-600行目) | ○ |
| C-11 | 公開済み→予約投稿への変更は禁止 | E-01 (565-571行目) | ○ |
| C-12 | Contributorは下書き以外のステータスに変更不可 | E-01 (1418-1424行目) | ○ |
| C-13 | email_only=trueの場合、公開時にstatus=sentになる | E-01 (819-825行目) | ○ |
| C-14 | 無料Tierは記事に関連付けできない | E-01 (971-974行目) | ○ |
| C-15 | Lexical→HTML変換処理がある | E-01 (714-734行目) | ○ |
| C-16 | Mobiledoc→HTML変換処理がある | E-01 (693-711行目) | ○ |
| C-17 | HTMLからplaintextを生成 | E-01 (736-751行目) | ○ |
| C-18 | タイトル変更時に自動でスラッグを更新（下書きで未公開の場合） | E-01 (828-860行目) | ○ |
| C-19 | リビジョンは最大25件保存 | E-01 (38行目) POST_REVISIONS_COUNT = 25 | ○ |
| C-20 | 編集操作はトランザクション内で実行 | E-01 (1317-1325行目) | ○ |
| C-21 | 追加操作はトランザクション内で実行 | E-01 (1353-1361行目) | ○ |
| C-22 | 削除操作はトランザクション内で実行 | E-01 (1371-1378行目) | ○ |
| C-23 | browseアクションのallowedIncludesが定義されている | E-03 (4-20行目) | ○ |
| C-24 | addアクションは201ステータスコードを返す | E-03 (151-152行目) | ○ |
| C-25 | destroyアクションは204ステータスコードを返す | E-03 (283-284行目) | ○ |
| C-26 | bulkEditで一括unpublish操作が可能 | E-02 (114-119行目) | ○ |
| C-27 | bulkEditで一括unschedule操作が可能 | E-02 (120-132行目) | ○ |
| C-28 | bulkEditで一括feature操作が可能 | E-02 (133-138行目) | ○ |
| C-29 | bulkEditで一括unfeature操作が可能 | E-02 (139-144行目) | ○ |
| C-30 | bulkEditでアクセス制御変更が可能 | E-02 (145-161行目) | ○ |
| C-31 | bulkEditでタグ追加が可能 | E-02 (162-185行目) | ○ |
| C-32 | copyPost機能が存在 | E-02 (450-513行目) | ○ |
| C-33 | post.added イベントが発行される | E-01 (387行目) | ○ |
| C-34 | post.edited イベントが発行される | E-01 (458行目) | ○ |
| C-35 | post.published イベントが発行される | E-01 (434-436行目) | ○ |
| C-36 | post.unpublished イベントが発行される | E-01 (429-431行目) | ○ |
| C-37 | postsテーブルに格納されるカラムが正しい | E-04 (61-105行目) | ○ |
| C-38 | posts_metaテーブルに格納されるカラムが正しい | E-04 (106-122行目) | ○ |
| C-39 | post_revisionsテーブルに格納されるカラムが正しい | E-04 (402-416行目) | ○ |
| C-40 | permissible関数で権限チェックが実装されている | E-01 (1386-1448行目) | ○ |
| C-41 | パフォーマンス要件（100件500ms以内など） | **根拠なし** | △ |
| C-42 | メンバー制限超過時のエラー処理 | E-01 (1411-1415行目) limitService参照のみ | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の具体的数値**
  - コード内には明示的なSLAやパフォーマンス目標の定義が見つからなかった
  - 候補：運用ドキュメント / SLA定義書 / パフォーマンステスト仕様書
- **メンバー制限チェックの詳細**
  - limitServiceの内部実装は別ファイルに存在し、詳細な制限条件は要調査
  - 候補：`ghost/core/core/server/services/limits.js`

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: データベーススキーマ関連の記述（根拠が明確）
- **0 (低リスク)**: ビジネスルールの記述（コード内に条件が明記）
- **1 (中リスク)**: パフォーマンス要件（運用実績に基づく推測値の可能性）
- **0 (低リスク)**: API仕様（コードから直接抽出）

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の数値が実際の運用基準と一致しているか確認
- [ ] 権限制御の記述がシステムの実装と一致しているか確認
- [ ] ビジネスルール（BR-001〜BR-006）がすべて正しく記載されているか確認
- [ ] 関連画面のマッピングが画面機能マッピング.csvと一致しているか確認
- [ ] Lexical/Mobiledocの変換処理の詳細が十分に記載されているか確認
