---
generated_at: 2026-01-29 11:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-メンバープロフィール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。特に優先度の高いレビュー項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/members/middleware.js`
- E-02: `ghost/core/core/server/services/members/members-ssr.js`
- E-03: `ghost/core/core/server/services/members/members-api/controllers/member-controller.js`
- E-04: `ghost/core/core/server/services/members/members-api/members-api.js`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | loadMemberSessionでセッションからメンバー読み込み | E-01 (89-99行目) | ○ |
| C-02 | authMemberByUuidでuuid+key認証可能 | E-01 (105-147行目) | ○ |
| C-03 | HMACキー検証にmembers_validation_keyを使用 | E-01 (128行目) | ○ |
| C-04 | getMemberDataでメンバーデータ取得 | E-01 (214-226行目) | ○ |
| C-05 | updateMemberDataでプロフィール更新 | E-01 (300-325行目) | ○ |
| C-06 | 更新可能フィールドはname, expertise, subscribed, newsletters, enable_comment_notifications | E-01 (302行目) | ○ |
| C-07 | getMemberNewslettersでニュースレター設定取得 | E-01 (250-270行目) | ○ |
| C-08 | updateMemberNewslettersでニュースレター設定更新 | E-01 (272-298行目) | ○ |
| C-09 | deleteSuppressionで配信停止解除 | E-01 (228-248行目) | ○ |
| C-10 | 配信停止解除でemail_disabled=falseに更新 | E-01 (235行目) | ○ |
| C-11 | setAccessCookiesでティアベースキャッシュ用Cookie設定 | E-01 (40-77行目) | ○ |
| C-12 | ghost-accessのMaxAgeは3600秒 | E-01 (70行目) | ○ |
| C-13 | Cookie値は{tier_id}:{timestamp}形式 | E-01 (67行目) | ○ |
| C-14 | Cookie署名はHMAC-SHA256 | E-01 (68行目) | ○ |
| C-15 | deleteSessionでログアウト | E-01 (198-212行目) | ○ |
| C-16 | getIdentityTokenで認証トークン取得 | E-01 (149-158行目) | ○ |
| C-17 | updateEmailAddressでメールアドレス変更 | E-03 (40-75行目) | ○ |
| C-18 | メールアドレス変更はupdateEmailタイプでマジックリンク送信 | E-03 (70行目) | ○ |
| C-19 | マジックリンク検証後にメールアドレス更新 | E-04 (264-267行目) | ○ |
| C-20 | formattedMemberResponseでレスポンス整形 | E-01 (218行目, 312行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主張に対して根拠が確認できた。不足情報なし。

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: プロフィール取得・更新（コードから明確）
- **0 (低リスク)**: uuid+key認証（コードから明確）
- **0 (低リスク)**: アクセスCookie管理（コードから明確）
- **0 (低リスク)**: メールアドレス変更フロー（コードから明確）

## 6) レビュアーチェックリスト（最小）
- [ ] セッション認証が正しく動作するか確認
- [ ] uuid+key認証のHMAC検証が正しいか確認
- [ ] 更新可能フィールドの制限が正しいか確認
- [ ] メールアドレス変更の確認フローが正しいか確認
- [ ] 配信停止解除がemail_suppression_listとemail_disabledの両方を更新するか確認
